package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum FoldType {

	//@formatter:off
	ONE_FOLD("One fold"), //$NON-NLS-1$
	TWO_FOLD("Two fold"), //$NON-NLS-1$
	THREE_FOLD("Three fold"),  //$NON-NLS-1$
	;
	//@formatter:on

	private final String foldType;

	public String getFoldType() {
		return foldType;
	}

	private FoldType(String reportTyp) {
		this.foldType = reportTyp;
	}

	public static FoldType fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return ONE_FOLD;
		}

		FoldType[] values = values();
		for (FoldType foldTypeEnum : values) {
			if (name.equals(foldTypeEnum.name())) {
				return foldTypeEnum;
			}
		}

		return ONE_FOLD;
	}

	@Override
	public String toString() {
		return foldType;
	}

}
