package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.NoteType;
import com.floreantpos.model.Notes;

public class NotesDAO extends BaseNotesDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public NotesDAO() {
	}

	public List<Notes> findAll(NoteType termsAndConditions) {
		try (Session session = this.createNewSession()) {
			Criteria criteria = session.createCriteria(this.getReferenceClass());
			this.addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(Notes.PROP_NOTE_TYPE, termsAndConditions.name()).ignoreCase());
			return criteria.list();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
		return null;
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void delete(Object obj, Session s) {
		Notes notes = (Notes) obj;
		notes.setDeleted(true);
		update(notes, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}
}