package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the STORE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="STORE"
 */

public abstract class BaseStore  implements Comparable, Serializable {

	public static String REF = "Store"; //$NON-NLS-1$
	public static String PROP_CREATED_TIME = "createdTime"; //$NON-NLS-1$
	public static String PROP_TELEPHONE = "telephone"; //$NON-NLS-1$
	public static String PROP_ADDRESS = "address"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_PERCENTAGE = "serviceChargePercentage"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_TICKET_FOOTER_MESSAGE = "ticketFooterMessage"; //$NON-NLS-1$
	public static String PROP_CURRENCY_SYMBOL = "currencySymbol"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_DEFAULT_OUTLET_ID = "defaultOutletId"; //$NON-NLS-1$
	public static String PROP_DEFAULT_GRATUITY_PERCENTAGE = "defaultGratuityPercentage"; //$NON-NLS-1$
	public static String PROP_OWNER_ID = "ownerId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_CAPACITY = "capacity"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_STREET = "street"; //$NON-NLS-1$
	public static String PROP_TABLES = "tables"; //$NON-NLS-1$
	public static String PROP_COUNTRY_CODE = "countryCode"; //$NON-NLS-1$
	public static String PROP_USE_DETAILED_RECONCILIATION = "useDetailedReconciliation"; //$NON-NLS-1$
	public static String PROP_RESELLER_ID = "resellerId"; //$NON-NLS-1$
	public static String PROP_OUTLET_NAME = "outletName"; //$NON-NLS-1$
	public static String PROP_FRIENDLY_UID = "friendlyUid"; //$NON-NLS-1$
	public static String PROP_ZIP_CODE = "zipCode"; //$NON-NLS-1$
	public static String PROP_FLAT_NO = "flatNo"; //$NON-NLS-1$
	public static String PROP_HOUSE = "house"; //$NON-NLS-1$
	public static String PROP_ALLOW_MODIFIER_MAX_EXCEED = "allowModifierMaxExceed"; //$NON-NLS-1$
	public static String PROP_CITY = "city"; //$NON-NLS-1$
	public static String PROP_CASH_BALANCE = "cashBalance"; //$NON-NLS-1$
	public static String PROP_CURRENCY_NAME = "currencyName"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE3 = "addressLine3"; //$NON-NLS-1$
	public static String PROP_LAST_LOGIN_TIME = "lastLoginTime"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE2 = "addressLine2"; //$NON-NLS-1$
	public static String PROP_TOTAL_BALANCE = "totalBalance"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE1 = "addressLine1"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_UUID = "uuid"; //$NON-NLS-1$
	public static String PROP_ITEM_PRICE_INCLUDES_TAX = "itemPriceIncludesTax"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_STATE = "state"; //$NON-NLS-1$
	public static String PROP_COUNTRY = "country"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_ENABLE_ONLINE_ORDERING = "enableOnlineOrdering"; //$NON-NLS-1$


	// constructors
	public BaseStore () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseStore (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date lastLoginTime;
				private java.util.Date createdTime;
				private java.lang.String uuid;
				private java.lang.String friendlyUid;
				private java.lang.String resellerId;
				private java.lang.String ownerId;
				private java.lang.String defaultOutletId;
				private java.lang.String name;
				private java.lang.String outletName;
				private java.lang.String addressLine1;
				private java.lang.String addressLine2;
				private java.lang.String addressLine3;
				private java.lang.String house;
				private java.lang.String flatNo;
				private java.lang.String type;
				private java.lang.String street;
				private java.lang.String city;
				private java.lang.String state;
				private java.lang.String country;
				private java.lang.String countryCode;
				private java.lang.String zipCode;
				private java.lang.String telephone;
				private java.lang.Integer capacity;
				private java.lang.Integer tables;
				private java.lang.String currencyName;
				private java.lang.String currencySymbol;
				private java.lang.Double serviceChargePercentage;
				private java.lang.Double defaultGratuityPercentage;
				private java.lang.String ticketFooterMessage;
				private java.lang.Boolean itemPriceIncludesTax;
				private java.lang.Boolean allowModifierMaxExceed;
				private java.lang.Boolean useDetailedReconciliation;
				private java.lang.Boolean enableOnlineOrdering;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.Double cashBalance;
				private java.lang.Double totalBalance;
	
	// many to one
	private com.floreantpos.model.Address address;

	// collections
	private java.util.Map<String,String> properties;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="assigned"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: LAST_LOGIN_TIME
	 */

	public java.util.Date getLastLoginTime () {
			return lastLoginTime;
	}



	/**
	 * Set the value related to the column: LAST_LOGIN_TIME
	 * @param lastLoginTime the LAST_LOGIN_TIME value
	 */
			public void setLastLoginTime (java.util.Date lastLoginTime) {
			this.lastLoginTime = lastLoginTime;
	}



	/**
	 * Return the value associated with the column: CREATED_TIME
	 */

	public java.util.Date getCreatedTime () {
			return createdTime;
	}



	/**
	 * Set the value related to the column: CREATED_TIME
	 * @param createdTime the CREATED_TIME value
	 */
			public void setCreatedTime (java.util.Date createdTime) {
			this.createdTime = createdTime;
	}



	/**
	 * Return the value associated with the column: UUID
	 */

	public java.lang.String getUuid () {
			return uuid;
	}



	/**
	 * Set the value related to the column: UUID
	 * @param uuid the UUID value
	 */
			public void setUuid (java.lang.String uuid) {
			this.uuid = uuid;
	}



	/**
	 * Return the value associated with the column: FRIENTLY_UID
	 */

	public java.lang.String getFriendlyUid () {
			return friendlyUid;
	}



	/**
	 * Set the value related to the column: FRIENTLY_UID
	 * @param friendlyUid the FRIENTLY_UID value
	 */
			public void setFriendlyUid (java.lang.String friendlyUid) {
			this.friendlyUid = friendlyUid;
	}



	/**
	 * Return the value associated with the column: RESELLER_ID
	 */

	public java.lang.String getResellerId () {
			return resellerId;
	}



	/**
	 * Set the value related to the column: RESELLER_ID
	 * @param resellerId the RESELLER_ID value
	 */
			public void setResellerId (java.lang.String resellerId) {
			this.resellerId = resellerId;
	}



	/**
	 * Return the value associated with the column: OWNER_ID
	 */

	public java.lang.String getOwnerId () {
			return ownerId;
	}



	/**
	 * Set the value related to the column: OWNER_ID
	 * @param ownerId the OWNER_ID value
	 */
			public void setOwnerId (java.lang.String ownerId) {
			this.ownerId = ownerId;
	}



	/**
	 * Return the value associated with the column: DEF_OUTLET_ID
	 */

	public java.lang.String getDefaultOutletId () {
			return defaultOutletId;
	}



	/**
	 * Set the value related to the column: DEF_OUTLET_ID
	 * @param defaultOutletId the DEF_OUTLET_ID value
	 */
			public void setDefaultOutletId (java.lang.String defaultOutletId) {
			this.defaultOutletId = defaultOutletId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: OUTLET_NAME
	 */

	public java.lang.String getOutletName () {
			return outletName;
	}



	/**
	 * Set the value related to the column: OUTLET_NAME
	 * @param outletName the OUTLET_NAME value
	 */
			public void setOutletName (java.lang.String outletName) {
			this.outletName = outletName;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE1
	 */

	public java.lang.String getAddressLine1 () {
			return addressLine1;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE1
	 * @param addressLine1 the ADDRESS_LINE1 value
	 */
			public void setAddressLine1 (java.lang.String addressLine1) {
			this.addressLine1 = addressLine1;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE2
	 */

	public java.lang.String getAddressLine2 () {
			return addressLine2;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE2
	 * @param addressLine2 the ADDRESS_LINE2 value
	 */
			public void setAddressLine2 (java.lang.String addressLine2) {
			this.addressLine2 = addressLine2;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE3
	 */

	public java.lang.String getAddressLine3 () {
			return addressLine3;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE3
	 * @param addressLine3 the ADDRESS_LINE3 value
	 */
			public void setAddressLine3 (java.lang.String addressLine3) {
			this.addressLine3 = addressLine3;
	}



	/**
	 * Return the value associated with the column: HOUSE
	 */

	public java.lang.String getHouse () {
			return house;
	}



	/**
	 * Set the value related to the column: HOUSE
	 * @param house the HOUSE value
	 */
			public void setHouse (java.lang.String house) {
			this.house = house;
	}



	/**
	 * Return the value associated with the column: FLAT_NO
	 */

	public java.lang.String getFlatNo () {
			return flatNo;
	}



	/**
	 * Set the value related to the column: FLAT_NO
	 * @param flatNo the FLAT_NO value
	 */
			public void setFlatNo (java.lang.String flatNo) {
			this.flatNo = flatNo;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */

	public java.lang.String getType () {
			return type;
	}



	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
			public void setType (java.lang.String type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: STREET
	 */

	public java.lang.String getStreet () {
			return street;
	}



	/**
	 * Set the value related to the column: STREET
	 * @param street the STREET value
	 */
			public void setStreet (java.lang.String street) {
			this.street = street;
	}



	/**
	 * Return the value associated with the column: CITY
	 */

	public java.lang.String getCity () {
			return city;
	}



	/**
	 * Set the value related to the column: CITY
	 * @param city the CITY value
	 */
			public void setCity (java.lang.String city) {
			this.city = city;
	}



	/**
	 * Return the value associated with the column: STATE
	 */

	public java.lang.String getState () {
			return state;
	}



	/**
	 * Set the value related to the column: STATE
	 * @param state the STATE value
	 */
			public void setState (java.lang.String state) {
			this.state = state;
	}



	/**
	 * Return the value associated with the column: COUNTRY
	 */

	public java.lang.String getCountry () {
			return country;
	}



	/**
	 * Set the value related to the column: COUNTRY
	 * @param country the COUNTRY value
	 */
			public void setCountry (java.lang.String country) {
			this.country = country;
	}



	/**
	 * Return the value associated with the column: COUNTRY_CODE
	 */

	public java.lang.String getCountryCode () {
			return countryCode;
	}



	/**
	 * Set the value related to the column: COUNTRY_CODE
	 * @param countryCode the COUNTRY_CODE value
	 */
			public void setCountryCode (java.lang.String countryCode) {
			this.countryCode = countryCode;
	}



	/**
	 * Return the value associated with the column: ZIPCODE
	 */

	public java.lang.String getZipCode () {
			return zipCode;
	}



	/**
	 * Set the value related to the column: ZIPCODE
	 * @param zipCode the ZIPCODE value
	 */
			public void setZipCode (java.lang.String zipCode) {
			this.zipCode = zipCode;
	}



	/**
	 * Return the value associated with the column: TELEPHONE
	 */

	public java.lang.String getTelephone () {
			return telephone;
	}



	/**
	 * Set the value related to the column: TELEPHONE
	 * @param telephone the TELEPHONE value
	 */
			public void setTelephone (java.lang.String telephone) {
			this.telephone = telephone;
	}



	/**
	 * Return the value associated with the column: CAPACITY
	 */

	public java.lang.Integer getCapacity () {
						return capacity == null ? Integer.valueOf(0) : capacity;
		}



	/**
	 * Set the value related to the column: CAPACITY
	 * @param capacity the CAPACITY value
	 */
			public void setCapacity (java.lang.Integer capacity) {
			this.capacity = capacity;
	}



	/**
	 * Return the value associated with the column: TABLES
	 */

	public java.lang.Integer getTables () {
						return tables == null ? Integer.valueOf(0) : tables;
		}



	/**
	 * Set the value related to the column: TABLES
	 * @param tables the TABLES value
	 */
			public void setTables (java.lang.Integer tables) {
			this.tables = tables;
	}



	/**
	 * Return the value associated with the column: CNAME
	 */

	public java.lang.String getCurrencyName () {
			return currencyName;
	}



	/**
	 * Set the value related to the column: CNAME
	 * @param currencyName the CNAME value
	 */
			public void setCurrencyName (java.lang.String currencyName) {
			this.currencyName = currencyName;
	}



	/**
	 * Return the value associated with the column: CSYMBOL
	 */

	public java.lang.String getCurrencySymbol () {
			return currencySymbol;
	}



	/**
	 * Set the value related to the column: CSYMBOL
	 * @param currencySymbol the CSYMBOL value
	 */
			public void setCurrencySymbol (java.lang.String currencySymbol) {
			this.currencySymbol = currencySymbol;
	}



	/**
	 * Return the value associated with the column: SC_PERCENTAGE
	 */

	public java.lang.Double getServiceChargePercentage () {
						return serviceChargePercentage == null ? Double.valueOf(0) : serviceChargePercentage;
		}



	/**
	 * Set the value related to the column: SC_PERCENTAGE
	 * @param serviceChargePercentage the SC_PERCENTAGE value
	 */
			public void setServiceChargePercentage (java.lang.Double serviceChargePercentage) {
			this.serviceChargePercentage = serviceChargePercentage;
	}



	/**
	 * Return the value associated with the column: GRATUITY_PERCENTAGE
	 */

	public java.lang.Double getDefaultGratuityPercentage () {
						return defaultGratuityPercentage == null ? Double.valueOf(0) : defaultGratuityPercentage;
		}



	/**
	 * Set the value related to the column: GRATUITY_PERCENTAGE
	 * @param defaultGratuityPercentage the GRATUITY_PERCENTAGE value
	 */
			public void setDefaultGratuityPercentage (java.lang.Double defaultGratuityPercentage) {
			this.defaultGratuityPercentage = defaultGratuityPercentage;
	}



	/**
	 * Return the value associated with the column: TICKET_FOOTER
	 */

	public java.lang.String getTicketFooterMessage () {
			return ticketFooterMessage;
	}



	/**
	 * Set the value related to the column: TICKET_FOOTER
	 * @param ticketFooterMessage the TICKET_FOOTER value
	 */
			public void setTicketFooterMessage (java.lang.String ticketFooterMessage) {
			this.ticketFooterMessage = ticketFooterMessage;
	}



	/**
	 * Return the value associated with the column: PRICE_INCLUDES_TAX
	 */

	public java.lang.Boolean isItemPriceIncludesTax () {
					return itemPriceIncludesTax == null ? Boolean.FALSE : itemPriceIncludesTax;
		}

	public java.lang.Boolean getItemPriceIncludesTax () {
				return itemPriceIncludesTax == null ? Boolean.FALSE : itemPriceIncludesTax;
			}


	/**
	 * Set the value related to the column: PRICE_INCLUDES_TAX
	 * @param itemPriceIncludesTax the PRICE_INCLUDES_TAX value
	 */
			public void setItemPriceIncludesTax (java.lang.Boolean itemPriceIncludesTax) {
			this.itemPriceIncludesTax = itemPriceIncludesTax;
	}



	/**
	 * Return the value associated with the column: ALLOW_MODIFIER_MAX_EXCEED
	 */

	public java.lang.Boolean isAllowModifierMaxExceed () {
					return allowModifierMaxExceed == null ? Boolean.FALSE : allowModifierMaxExceed;
		}

	public java.lang.Boolean getAllowModifierMaxExceed () {
				return allowModifierMaxExceed == null ? Boolean.FALSE : allowModifierMaxExceed;
			}


	/**
	 * Set the value related to the column: ALLOW_MODIFIER_MAX_EXCEED
	 * @param allowModifierMaxExceed the ALLOW_MODIFIER_MAX_EXCEED value
	 */
			public void setAllowModifierMaxExceed (java.lang.Boolean allowModifierMaxExceed) {
			this.allowModifierMaxExceed = allowModifierMaxExceed;
	}



	/**
	 * Return the value associated with the column: USE_DETAILED_RECONCILIATION
	 */

	public java.lang.Boolean isUseDetailedReconciliation () {
					return useDetailedReconciliation == null ? Boolean.FALSE : useDetailedReconciliation;
		}

	public java.lang.Boolean getUseDetailedReconciliation () {
				return useDetailedReconciliation == null ? Boolean.FALSE : useDetailedReconciliation;
			}


	/**
	 * Set the value related to the column: USE_DETAILED_RECONCILIATION
	 * @param useDetailedReconciliation the USE_DETAILED_RECONCILIATION value
	 */
			public void setUseDetailedReconciliation (java.lang.Boolean useDetailedReconciliation) {
			this.useDetailedReconciliation = useDetailedReconciliation;
	}



	/**
	 * Return the value associated with the column: ENABLE_ONLINE_ORDERING
	 */

	public java.lang.Boolean isEnableOnlineOrdering () {
					return enableOnlineOrdering == null ? Boolean.FALSE : enableOnlineOrdering;
		}

	public java.lang.Boolean getEnableOnlineOrdering () {
				return enableOnlineOrdering == null ? Boolean.FALSE : enableOnlineOrdering;
			}


	/**
	 * Set the value related to the column: ENABLE_ONLINE_ORDERING
	 * @param enableOnlineOrdering the ENABLE_ONLINE_ORDERING value
	 */
			public void setEnableOnlineOrdering (java.lang.Boolean enableOnlineOrdering) {
			this.enableOnlineOrdering = enableOnlineOrdering;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: CASH_BALANCE
	 */

	public java.lang.Double getCashBalance () {
						return cashBalance == null ? Double.valueOf(0) : cashBalance;
		}



	/**
	 * Set the value related to the column: CASH_BALANCE
	 * @param cashBalance the CASH_BALANCE value
	 */
			public void setCashBalance (java.lang.Double cashBalance) {
			this.cashBalance = cashBalance;
	}



	/**
	 * Return the value associated with the column: TOTAL_BALANCE
	 */

	public java.lang.Double getTotalBalance () {
						return totalBalance == null ? Double.valueOf(0) : totalBalance;
		}



	/**
	 * Set the value related to the column: TOTAL_BALANCE
	 * @param totalBalance the TOTAL_BALANCE value
	 */
			public void setTotalBalance (java.lang.Double totalBalance) {
			this.totalBalance = totalBalance;
	}



	/**
	 * Return the value associated with the column: ADDRESS
	 */

	public com.floreantpos.model.Address getAddress () {
			return address;
	}



	/**
	 * Set the value related to the column: ADDRESS
	 * @param address the ADDRESS value
	 */
			public void setAddress (com.floreantpos.model.Address address) {
			this.address = address;
	}



	/**
	 * Return the value associated with the column: properties
	 */

			public java.util.Map<String,String> getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: properties
	 * @param properties the properties value
	 */
			public void setProperties (java.util.Map<String,String> properties) {
			this.properties = properties;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Store)) return false;
		else {
			com.floreantpos.model.Store store = (com.floreantpos.model.Store) obj;
			if (null == this.getId() || null == store.getId()) return this == obj;
			else return (this.getId().equals(store.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}