package com.floreantpos.gsonAdapter;

import java.lang.reflect.Type;

import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

public class UserAdapter implements JsonSerializer<User> {

	@Override
	public JsonElement serialize(User src, Type typeOfSrc, JsonSerializationContext context) {
		JsonObject jsonObject = new JsonObject();

		if (src instanceof User) {
			jsonObject.addProperty(User.PROP_ID, src.getId());
			jsonObject.addProperty(User.PROP_FIRST_NAME, src.getFirstName());
			jsonObject.addProperty(User.PROP_LAST_NAME, src.getLastName());
			jsonObject.addProperty(User.PROP_PHONE_NO, src.getPhoneNo());
			jsonObject.addProperty(User.PROP_EMAIL, src.getEmail());
			UserType type = src.getType();
			if (type != null) {
				jsonObject.addProperty("Role", type.toString());
			}
			jsonObject.addProperty("workHour", src.getRegularWorkHour());
			jsonObject.addProperty("costPerHour", src.getCostPerHour());
			jsonObject.addProperty("overtime/hour", src.getOvertimePerHourRate());
			jsonObject.addProperty(User.PROP_ACTIVE, src.getActive());
			jsonObject.addProperty("LabStuff", src.isLabStuff());
		}
		return jsonObject;
	}
}
