package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum SharingRule {

	//@formatter:off
	DATE_WISE("Date wise"),
	;
	//@formatter:on

	private final String roleName;

	public String getRoleName() {
		return roleName;
	}

	private SharingRule(String reportTyp) {
		this.roleName = reportTyp;
	}

	public static SharingRule fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return DATE_WISE;
		}

		SharingRule[] values = values();
		for (SharingRule rule : values) {
			if (name.equals(rule.name())) {
				return rule;
			}
		}

		return DATE_WISE;
	}

	@Override
	public String toString() {
		return roleName;
	}

}
