package com.floreantpos.db.update;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.SalaryTransaction;
import com.floreantpos.model.UserSalaryDeductionModel;
import com.floreantpos.model.dao.SalaryTransactionDAO;
import com.floreantpos.util.GsonUtil;

public class UpdateDBTo468 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo468(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() {
		updateSalaryTransactions();
	}

	private void updateSalaryTransactions() {
		PosLog.info(getClass(), "Updating Salary Transactions in " + schemaName + " schema.");
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();
			try {
				Criteria criteria = session.createCriteria(SalaryTransaction.class);
				List<SalaryTransaction> salaryTransactions = criteria.list();
				if (salaryTransactions != null) {
					for (SalaryTransaction salaryTransaction : salaryTransactions) {
						String deductionGsonData = salaryTransaction.getDeductionGsonData();
						if (StringUtils.isNotBlank(deductionGsonData)) {
							double totalProvidendFund = 0;
							List<UserSalaryDeductionModel> salaryDeductionModels = GsonUtil.convertJSONToList(deductionGsonData,
									UserSalaryDeductionModel.class);
							for (UserSalaryDeductionModel salaryDeductionModel : salaryDeductionModels) {
								if ("PF".equals(salaryDeductionModel.getDeductionReason())) {
									totalProvidendFund += salaryDeductionModel.getDeductionAmount();
								}
							}
							salaryTransaction.setProvidentFundAmount(totalProvidendFund);
							SalaryTransactionDAO.getInstance().saveOrUpdate(salaryTransaction, session);
						}
					}
				}
				transaction.commit();
				PosLog.info(getClass(), schemaName + " Salary Transactions update completed successfully");
			} catch (Exception e) {
				transaction.rollback();
				PosLog.error(getClass(), "Error updating salary transactions in " + schemaName, e);
			}
		}
	}
}
