package com.floreantpos.model.util;

import org.apache.commons.lang.StringUtils;

public enum ServiceChargeType {
	//@formatter:off
		EMPTY(""), //$NON-NLS-1$
		PERCENTAGE("Percentage"),
		FIXEDAMOUNT("Fixed amount") 
		;
		//@formatter:on

	String displayString;

	private ServiceChargeType(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static ServiceChargeType fromName(String name) {
		return fromName(name, ServiceChargeType.PERCENTAGE);
	}

	public static ServiceChargeType fromName(String name, ServiceChargeType defaultValue) {
		if (StringUtils.isBlank(name)) {
			return defaultValue;
		}

		ServiceChargeType[] values = values();
		for (ServiceChargeType chargeType : values) {
			if (name.equals(chargeType.name())) {
				return chargeType;
			}
		}

		return defaultValue;
	}
}
