package com.floreantpos.report;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.util.NumberUtil;

public class GrandTotalCollectionReportData {

	public static final String OTHERS = "Others"; //$NON-NLS-1$
	
	private String particularId;
	private String particularName;
	private String consumableItem;
	private String categoryName;
	private String categoryId;
	private String serviceType;
	private String reportGroupId;
	private String reportGroupName;

	private double qunatity;

	private double ot;
	private double otherCost;
	private double doctorCharge;
	private double roomCharge;

	private double grossSalesAmount;
	private double discount;
	private double rfAmount;
	private double ldfAmount;
	private double refundAmount;
	private double subTotalAmount;
	private double discountAmount;
	private double totalAmount;
	private double taxAmount;
	private double consumableItemAmount;
	private double ticketItemAdjustedDiscount;
	private double cashAmount;
	private double othersAmount;

	public GrandTotalCollectionReportData() {

	}

	public GrandTotalCollectionReportData(int totalQuantity, double totalAmount) {
		setQunatity(totalQuantity);
		setTotalAmount(totalAmount);
	}

	public GrandTotalCollectionReportData(Ticket ticket, TicketItem ticketItem) {

		setParticularId(ticketItem.getMenuItemId());
		setParticularName(ticketItem.getName());

		setSubTotalAmount(ticketItem.getSubtotalAmount());
		setDiscountAmount(ticketItem.getDiscountAmount());
		setTotalAmount(ticketItem.getTotalAmount());
		setTaxAmount(ticketItem.getTaxAmount());

	}

	public String getParticularName() {
		if (StringUtils.isNotBlank(particularName)) {
			return particularName;
		}
		if (StringUtils.isNotBlank(particularId)) {
			MenuItem menuItem = MenuItemDAO.getInstance().get(particularId);
			if (menuItem != null) {
				particularName = menuItem.getName();
			}
		}
		return particularName;
	}

	public void setParticularName(String particular) {
		this.particularName = particular;
	}

	public String getConsumableItem() {
		return consumableItem;
	}

	public void setConsumableItem(String consumableItem) {
		this.consumableItem = consumableItem;
	}

	public String getQunatityDisplay() {
		return NumberUtil.formatNumberIfNeeded(getQunatity());
	}

	public double getQunatity() {
		return qunatity;
	}

	public void setQunatity(double qunatity) {
		this.qunatity = qunatity;
	}

	public double getOt() {
		return ot;
	}

	public void setOt(double otCharge) {
		this.ot = otCharge;
	}

	public double getOtherCost() {
		return otherCost;
	}

	public void setOtherCost(double otherCost) {
		this.otherCost = otherCost;
	}

	public double getDoctorCharge() {
		return doctorCharge;
	}

	public void setDoctorCharge(double doctorCharge) {
		this.doctorCharge = doctorCharge;
	}

	public double getRoomCharge() {
		return roomCharge;
	}

	public void setRoomCharge(double roomCharge) {
		this.roomCharge = roomCharge;
	}

	public double getSubTotalAmount() {
		return subTotalAmount;
	}

	public void setSubTotalAmount(double subTotalAmount) {
		this.subTotalAmount = subTotalAmount;
	}

	public double getDiscountAmount() {
		return discountAmount;
	}

	public void setDiscountAmount(double discountAmount) {
		this.discountAmount = discountAmount;
	}

	public double getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(double totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getParticularId() {
		return particularId;
	}

	public void setParticularId(String particularId) {
		this.particularId = particularId;
	}

	public double getTaxAmount() {
		return taxAmount;
	}

	public void setTaxAmount(double taxAmount) {
		this.taxAmount = taxAmount;
	}

	public double getConsumableItemAmount() {
		return consumableItemAmount;
	}

	public void setConsumableItemAmount(double consumableItemAmount) {
		this.consumableItemAmount = consumableItemAmount;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(String categoryId) {
		this.categoryId = categoryId;
	}

	public double getGrossSalesAmount() {
		return grossSalesAmount;
	}

	public void setGrossSalesAmount(double grossSalesAmount) {
		this.grossSalesAmount = grossSalesAmount;
	}

	public double getDiscount() {
		return discount;
	}

	public void setDiscount(double discountAndOtherAmount) {
		this.discount = discountAndOtherAmount;
	}

	public String getServiceType() {
		return serviceType;
	}

	public void setServiceType(String serviceType) {
		this.serviceType = serviceType;
	}

	public double getRfAmount() {
		return rfAmount;
	}

	public void setRfAmount(double rfAmount) {
		this.rfAmount = rfAmount;
	}

	public double getLdfAmount() {
		return ldfAmount;
	}

	public void setLdfAmount(double ldfAmount) {
		this.ldfAmount = ldfAmount;
	}

	public double getRefundAmount() {
		return refundAmount;
	}

	public void setRefundAmount(double refundAmount) {
		this.refundAmount = refundAmount;
	}

	public double getTicketItemAdjustedDiscount() {
		return ticketItemAdjustedDiscount;
	}

	public void setTicketItemAdjustedDiscount(double ticketItemDiscount) {
		this.ticketItemAdjustedDiscount = ticketItemDiscount;
	}

	public double getCashAmount() {
		return cashAmount;
	}

	public void setCashAmount(double cashAmount) {
		this.cashAmount = cashAmount;
	}

	public double getOthersAmount() {
		return othersAmount;
	}

	public void setOthersAmount(double othersAmount) {
		this.othersAmount = othersAmount;
	}

	public String getReportGroupId() {
		return reportGroupId;
	}

	public void setReportGroupId(String reportGroupId) {
		this.reportGroupId = reportGroupId;
	}

	public String getReportGroupName() {
		if (StringUtils.isNotBlank(reportGroupName)) {
			return reportGroupName;
		}
		if (StringUtils.isNotBlank(reportGroupId)) {
			ReportGroup reportGroup = ReportGroupDAO.getInstance().get(reportGroupId);
			if (reportGroup != null) {
				reportGroupName = reportGroup.getName();
			}
		}
		return StringUtils.isBlank(reportGroupName) ? OTHERS : reportGroupName;
	}

	public void setReportGroupName(String reportGroupName) {
		this.reportGroupName = reportGroupName;
	}
}
