package com.floreantpos.model;

public enum AppointmentStatus {
	BOOKED("Booked", 0, "#ef6c00", "#FFFFFF"),
	ARRIVED("Arrived", 1, "#886ce4", "#FFFFFF"),
	ON_GOING("On Going", 2, "#b71c1c", "#FFF"), 
	COMPLETED("Completed", 3, "#00A86B", "#FFF"), 
	CANCELLED("Cancelled", 4, "#2a2731", "#FFF"), 
	PATIENT_NOT_AVAILABLE("Patient not available", 5, "#787189", "#FFF");
	private String displayString;
	private int index;
	private String backgroundColor;
	private String foreColor;

	private AppointmentStatus(String displayString, int index, String backgroundColor, String foreColor) {
		this.displayString = displayString;
		this.index = index;
		this.backgroundColor = backgroundColor;
		this.foreColor = foreColor;
	}

	public int getIndex() {
		return index;
	}

	public String getDisplayString() {
		return displayString;
	}
	
	public String getBackgroundColor() {
		switch (this) {
				
			default:
				break;
		}
		return backgroundColor;
	}
	
	public String getForeColor() {
		return foreColor;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

}