package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the DOCTOR_VISIT_MEDICINE_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="DOCTOR_VISIT_MEDICINE_ITEM"
 */

public abstract class BaseDoctorVisitMedicineItem  implements Comparable, Serializable {

	public static String REF = "DoctorVisitMedicineItem"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_ITEM_QUANTITY = "itemQuantity"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_DOCTOR_VISIT = "doctorVisit"; //$NON-NLS-1$
	public static String PROP_ITEM_ID = "itemId"; //$NON-NLS-1$


	// constructors
	public BaseDoctorVisitMedicineItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDoctorVisitMedicineItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseDoctorVisitMedicineItem (
		java.lang.String id,
		com.floreantpos.model.DoctorVisit doctorVisit) {

		this.setId(id);
		this.setDoctorVisit(doctorVisit);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date createdDate;
				private java.lang.String itemId;
				private java.lang.Double itemQuantity;
				private java.lang.String status;
				private java.lang.String properties;
	
	// many to one
	private com.floreantpos.model.DoctorVisit doctorVisit;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: ITEM_ID
	 */

	public java.lang.String getItemId () {
			return itemId;
	}



	/**
	 * Set the value related to the column: ITEM_ID
	 * @param itemId the ITEM_ID value
	 */
			public void setItemId (java.lang.String itemId) {
			this.itemId = itemId;
	}



	/**
	 * Return the value associated with the column: ITEM_QUANTITY
	 */

	public java.lang.Double getItemQuantity () {
						return itemQuantity == null ? Double.valueOf(0) : itemQuantity;
		}



	/**
	 * Set the value related to the column: ITEM_QUANTITY
	 * @param itemQuantity the ITEM_QUANTITY value
	 */
			public void setItemQuantity (java.lang.Double itemQuantity) {
			this.itemQuantity = itemQuantity;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DOCTOR_VISIT_ID
	 */

	public com.floreantpos.model.DoctorVisit getDoctorVisit () {
			return doctorVisit;
	}



	/**
	 * Set the value related to the column: DOCTOR_VISIT_ID
	 * @param doctorVisit the DOCTOR_VISIT_ID value
	 */
			public void setDoctorVisit (com.floreantpos.model.DoctorVisit doctorVisit) {
			this.doctorVisit = doctorVisit;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.DoctorVisitMedicineItem)) return false;
		else {
			com.floreantpos.model.DoctorVisitMedicineItem doctorVisitMedicineItem = (com.floreantpos.model.DoctorVisitMedicineItem) obj;
			if (null == this.getId() || null == doctorVisitMedicineItem.getId()) return this == obj;
			else return (this.getId().equals(doctorVisitMedicineItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}