package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MENU_PAGE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MENU_PAGE"
 */

public abstract class BaseMenuPage  implements Comparable, Serializable {

	public static String REF = "MenuPage"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_BUTTON_WIDTH = "buttonWidth"; //$NON-NLS-1$
	public static String PROP_FLIXIBLE_BUTTON_SIZE = "flixibleButtonSize"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_BUTTON_HEIGHT = "buttonHeight"; //$NON-NLS-1$
	public static String PROP_MENU_GROUP_ID = "menuGroupId"; //$NON-NLS-1$
	public static String PROP_COLS = "cols"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ORDER_TYPE_ID = "orderTypeId"; //$NON-NLS-1$
	public static String PROP_VISIBLE = "visible"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_ROWS = "rows"; //$NON-NLS-1$


	// constructors
	public BaseMenuPage () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMenuPage (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseMenuPage (
		java.lang.String id,
		java.lang.String name) {

		this.setId(id);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.Integer sortOrder;
				private java.lang.Integer cols;
				private java.lang.String menuGroupId;
				private java.lang.String orderTypeId;
				private java.lang.String outletId;
				private java.lang.Integer buttonWidth;
				private java.lang.Integer buttonHeight;
				private java.lang.Integer rows;
				private java.lang.Boolean flixibleButtonSize;
				private java.lang.Boolean visible;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.List<com.floreantpos.model.MenuPageItem> pageItems;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: NUM_OF_COLUMN
	 */

	public java.lang.Integer getCols () {
						return cols == null ? Integer.valueOf(0) : cols;
		}



	/**
	 * Set the value related to the column: NUM_OF_COLUMN
	 * @param cols the NUM_OF_COLUMN value
	 */
			public void setCols (java.lang.Integer cols) {
			this.cols = cols;
	}



	/**
	 * Return the value associated with the column: GROUP_ID
	 */

	public java.lang.String getMenuGroupId () {
			return menuGroupId;
	}



	/**
	 * Set the value related to the column: GROUP_ID
	 * @param menuGroupId the GROUP_ID value
	 */
			public void setMenuGroupId (java.lang.String menuGroupId) {
			this.menuGroupId = menuGroupId;
	}



	/**
	 * Return the value associated with the column: ORDER_TYPE_ID
	 */

	public java.lang.String getOrderTypeId () {
			return orderTypeId;
	}



	/**
	 * Set the value related to the column: ORDER_TYPE_ID
	 * @param orderTypeId the ORDER_TYPE_ID value
	 */
			public void setOrderTypeId (java.lang.String orderTypeId) {
			this.orderTypeId = orderTypeId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: BWIDTH
	 */

	public java.lang.Integer getButtonWidth () {
						return buttonWidth == null ? 100 : buttonWidth;
			}



	/**
	 * Set the value related to the column: BWIDTH
	 * @param buttonWidth the BWIDTH value
	 */
			public void setButtonWidth (java.lang.Integer buttonWidth) {
			this.buttonWidth = buttonWidth;
	}


	/**
	 * Custom property
	 */
	public static String getButtonWidthDefaultValue () {
		return "100";
	}


	/**
	 * Return the value associated with the column: BHEIGHT
	 */

	public java.lang.Integer getButtonHeight () {
						return buttonHeight == null ? 100 : buttonHeight;
			}



	/**
	 * Set the value related to the column: BHEIGHT
	 * @param buttonHeight the BHEIGHT value
	 */
			public void setButtonHeight (java.lang.Integer buttonHeight) {
			this.buttonHeight = buttonHeight;
	}


	/**
	 * Custom property
	 */
	public static String getButtonHeightDefaultValue () {
		return "100";
	}


	/**
	 * Return the value associated with the column: NUM_OF_ROW
	 */

	public java.lang.Integer getRows () {
						return rows == null ? Integer.valueOf(0) : rows;
		}



	/**
	 * Set the value related to the column: NUM_OF_ROW
	 * @param rows the NUM_OF_ROW value
	 */
			public void setRows (java.lang.Integer rows) {
			this.rows = rows;
	}



	/**
	 * Return the value associated with the column: FBS
	 */

	public java.lang.Boolean isFlixibleButtonSize () {
					return flixibleButtonSize == null ? Boolean.FALSE : flixibleButtonSize;
		}

	public java.lang.Boolean getFlixibleButtonSize () {
				return flixibleButtonSize == null ? Boolean.FALSE : flixibleButtonSize;
			}


	/**
	 * Set the value related to the column: FBS
	 * @param flixibleButtonSize the FBS value
	 */
			public void setFlixibleButtonSize (java.lang.Boolean flixibleButtonSize) {
			this.flixibleButtonSize = flixibleButtonSize;
	}



	/**
	 * Return the value associated with the column: VISIBLE
	 */

	public java.lang.Boolean isVisible () {
						return visible == null ? Boolean.valueOf(true) : visible;
			}

	public java.lang.Boolean getVisible () {
					return visible == null ? Boolean.valueOf(true) : visible;
			}


	/**
	 * Set the value related to the column: VISIBLE
	 * @param visible the VISIBLE value
	 */
			public void setVisible (java.lang.Boolean visible) {
			this.visible = visible;
	}


	/**
	 * Custom property
	 */
	public static String getVisibleDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: pageItems
	 */

	public java.util.List<com.floreantpos.model.MenuPageItem> getPageItems () {
			return pageItems;
	}



	/**
	 * Set the value related to the column: pageItems
	 * @param pageItems the pageItems value
	 */
			public void setPageItems (java.util.List<com.floreantpos.model.MenuPageItem> pageItems) {
			this.pageItems = pageItems;
	}

	public void addTopageItems (com.floreantpos.model.MenuPageItem menuPageItem) {
		if (null == getPageItems()) setPageItems(new java.util.ArrayList<com.floreantpos.model.MenuPageItem>());
		getPageItems().add(menuPageItem);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MenuPage)) return false;
		else {
			com.floreantpos.model.MenuPage menuPage = (com.floreantpos.model.MenuPage) obj;
			if (null == this.getId() || null == menuPage.getId()) return this == obj;
			else return (this.getId().equals(menuPage.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}