package com.floreantpos.report.model;

import java.text.SimpleDateFormat;

import com.floreantpos.model.Appointment;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;

public class DoctorAppointmentReportModel extends ListTableModel {
	SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm a"); //$NON-NLS-1$

	public DoctorAppointmentReportModel() {
		super(new String[] { "patientName", "appointmentDate", "appointmentTime", "appointmentId", "total" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$

	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		Appointment data = (Appointment) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return data.getProperty("patientName");
			case 1:
				return DateUtil.formatAsShortDate(data.getFromDate());
			case 2:
				return simpleDateFormat.format(data.getFromDate());
			case 3:
				return data.getAppoinmentId();
			case 4:
				return data.getDoctorFee();

		}
		return null;
	}

}