package com.orocube.siiopa.accounting.client.service;

import java.util.Date;
import java.util.List;

import com.floreantpos.model.dao.LedgerEntryDAO;
import com.floreantpos.report.model.BalanceSheetLedgerEntryModel;

public class IncomeStatementService {

	private Date startDate;
	private Date endDate;

	private double totalSales;
	private double totalDirectCost;
	private List<BalanceSheetLedgerEntryModel> expenseList;
	private double totalExpenseAamount;
	private double grossProfit;
	private double totalOparatingProfit;
	private double totalDiscount;

	public IncomeStatementService(Date startDate, Date endDate) {
		this.startDate = startDate;
		this.endDate = endDate;

		searchData();

	}

	private void searchData() {
		totalDiscount = 0;
		double totalReturn = 0;
		totalSales = LedgerEntryDAO.getInstance().getLedgerEntriesAmountByTypeId("revenue", startDate, endDate); //$NON-NLS-1$
		totalDirectCost = LedgerEntryDAO.getInstance().getLedgerEntriesAmountByTypeId("direct_costs", startDate, endDate); //$NON-NLS-1$

		totalReturn = LedgerEntryDAO.getInstance().getLedgerEntriesAmountByTypeId("contra_account", startDate, endDate); //$NON-NLS-1$
		totalDiscount = LedgerEntryDAO.getInstance().getLedgerEntriesAmountByTypeId("", "5016", startDate, endDate); //$NON-NLS-1$

		totalSales += totalReturn;
		expenseList = LedgerEntryDAO.getInstance().getExpenseLedgerEntries(startDate, endDate, true);
		//by default sales will be negative
		totalExpenseAamount = expenseList.stream().mapToDouble(e -> e.getAmount()).sum();
		grossProfit = totalSales + totalDirectCost + totalDiscount;
		totalOparatingProfit = grossProfit + totalExpenseAamount;
	}

	public double getTotalSales() {
		return totalSales;
	}

	public double getTotalDirectCost() {
		return totalDirectCost;
	}

	public List<BalanceSheetLedgerEntryModel> getExpenseList() {
		return expenseList;
	}

	public double getTotalExpenseAamount() {
		return totalExpenseAamount;
	}

	public double getGrossProfit() {
		return grossProfit;
	}

	public double getTotalOparatingProfit() {
		return totalOparatingProfit;
	}

	public double getTotalDiscount() {
		return totalDiscount;
	}

}
