/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

public class TipsCashoutReportData {

	private String ticketId;
	private String saleType;
	private Double ticketTotal;
	private Double cashTips;
	private Double chargedTips;
	private Double tipsPaidAmount;
	private boolean paid;
	private User owner;
	private Double amount;
	private Double declareTipsAmount;

	public TipsCashoutReportData() {
	}

	public String getSaleType() {
		return saleType;
	}

	public void setSaleType(String saleType) {
		this.saleType = saleType;
		if (this.saleType == null) {
			this.saleType = ""; //$NON-NLS-1$
		}
		else {
			this.saleType = this.saleType.replaceAll("_", " "); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	public String getTicketId() {
		return ticketId;
	}

	public void setTicketId(String ticketId) {
		this.ticketId = ticketId;
	}

	public Double getTicketTotal() {
		return ticketTotal;
	}

	public void setTicketTotal(Double ticketTotal) {
		this.ticketTotal = ticketTotal;
	}

	public Double getCashTips() {
		return cashTips == null ? 0 : cashTips;
	}

	public void setCashTips(Double tips) {
		this.cashTips = tips;
	}

	public boolean isPaid() {
		return paid;
	}

	public void setPaid(boolean paid) {
		this.paid = paid;
	}

	public Double getTipsPaidAmount() {
		return tipsPaidAmount == null ? 0 : tipsPaidAmount;
	}

	public void setTipsPaidAmount(Double tipsPaidAmount) {
		this.tipsPaidAmount = tipsPaidAmount;
	}

	public Double getChargedTips() {
		return chargedTips == null ? 0 : chargedTips;
	}

	public void setChargedTips(Double chargedTips) {
		this.chargedTips = chargedTips;
	}

	public User getOwner() {
		return owner;
	}

	public void setOwner(User owner) {
		this.owner = owner;
	}

	public Double getAmount() {
		return amount == null ? 0 : amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

	public double getDueAmount() {
		return getAmount() - getTipsPaidAmount() - declareTipsAmount;
	}

	public Double getDeclareTipsAmount() {
		return declareTipsAmount == null ? 0 : declareTipsAmount;
	}

	public void setDeclareTipsAmount(Double declareTipsAmount) {
		this.declareTipsAmount = declareTipsAmount;
	}
}