package com.floreantpos.hl7.mythic;

import java.util.Map;
import java.util.Scanner;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

import com.floreantpos.PosLog;
import com.floreantpos.hl7.HL7Util;
import com.floreantpos.hl7.astm.AstmParser;
import com.floreantpos.hl7.model.Result;
import com.floreantpos.hl7.model.Test;
import com.floreantpos.model.InventoryUnit;

public class MythicParser {
	public static Test parseMythicMessage(Session session, String storeId, String inputData, Map<String, InventoryUnit> unitsMap, boolean readSampleIDFromPBlock) throws Exception {
		Scanner scanner = new Scanner(inputData);
		Test mythicTestResult = new Test();
		mythicTestResult.machine = "Mythic";

		while (scanner.hasNextLine()) {
			String line = scanner.nextLine();
			String[] tokens = line.split(";");

			String key = tokens[0];
			if (StringUtils.isBlank(key)) {
				continue;
			}

			String value = "";
			if (tokens.length > 1) {
				value = tokens[1];
			}
			if (StringUtils.isNotBlank(value)) {
				value.trim();
			}

			switch (key) {
				case "DATE":
					mythicTestResult.date = value;
					break;

				case "TIME":
					mythicTestResult.time = value;
					break;

				case "UNIT":
					mythicTestResult.unit = value == "1" ? "each" : value;
					break;

				case "PID":
					if (readSampleIDFromPBlock) {
						mythicTestResult.sampleId = value;
						PosLog.debug(MythicParser.class, "Sample ID From PID Block: " + mythicTestResult.sampleId);
					}
					mythicTestResult.patientId = value;
					break;

				case "SID":
					if (!readSampleIDFromPBlock) {
						mythicTestResult.sampleId = value;
						PosLog.debug(AstmParser.class, "Sample ID From SID Block:  " + mythicTestResult.sampleId);
					}
					break;

				default:
					if (tokens.length >= 7) {
						String name = key;

						Result result = new Result();
						result.testName = name;
						result.result = value;

						HL7Util hl7Util = new HL7Util(session, storeId, null);
						hl7Util.updateUnit(unitsMap, result, mythicTestResult.unit);

						result.status = tokens[2].trim().isEmpty() ? "Normal" : tokens[2].trim();
						result.lowRange = tokens[3].trim();
						result.normalLow = tokens[4].trim();
						result.normalHigh = tokens[5].trim();
						result.highRange = tokens[6].trim();
						mythicTestResult.resultmap.put(name, result);
					}
			}
		}
		scanner.close();

		return mythicTestResult;
	}

	public static String getSampleData1() {
		//@formatter:off
		String inputData = ""
				+ "DATE;05/11/2024\r\n"
				+ "TIME;14:48:41\r\n"
				+ "WBC;6.0;;;2.0;4.0;12.0;15.0\r\n"
				+ "RBC;3.62;;l;2.50;4.00;6.20;7.00\r\n"
				+ "HGB;12.0;;;8.5;11.0;17.0;19.0\r\n"
				+ "PLT;38;;L;70;150;400;500"
				+ "";
				
		//@formatter:on
		return inputData;
	}

	public static String getSampleData2() {//@formatter:off
		String sampleData = "MYTHIC 1;;RESULT\r\n" 
				+ "DATE;05/11/2024\r\n" 
				+ "TIME;14:48:41\r\n" 
				+ "MODE;NORMAL\r\n" 
				+ "UNIT;1\r\n" 
				+ "SEQ;12;0\r\n"
				+ "SID;00010\r\n" 
				+ "PID;SERVICE\r\n" 
				+ "ID;\r\n" 
				+ "TYPE;STANDARD\r\n" 
				+ "TEST;DIF\r\n" 
				+ "OPERATOR;\r\n" 
				+ "PREL;OT\r\n" 
				+ "CYCLE;N\r\n"
				+ "WBC;6.0  ;;;2.0  ;4.0  ;12.0 ;15.0 \r\n" 
				+ "RBC;3.62 ;;l;2.50 ;4.00 ;6.20 ;7.00 \r\n" 
				+ "HGB;12.0;;;8.5 ;11.0;17.0;19.0\r\n"
				+ "HCT;34.8;;l;25.0;35.0;55.0;60.0\r\n" 
				+ "PLT;38   ;;L;70   ;150  ;400  ;500  \r\n" 
				+ "LYM;2.0  ;;;0.7  ;1.0  ;5.0  ;5.5  \r\n"
				+ "MON;0.1  ;;;0.0  ;0.1  ;1.0  ;1.1  \r\n" 
				+ "NEU;3.6  ;;;1.5  ;2.0  ;8.0  ;9.0  \r\n" 
				+ "LYM%;33.8;;;15.0;25.0;50.0;55.0\r\n"
				+ "MON%;1.2 ;;l;1.0 ;2.0 ;10.0;12.0\r\n" 
				+ "NEU%;60.1;;;45.0;50.0;80.0;85.0\r\n" 
				+ "MCV;96.1 ;;;70.0 ;80.0 ;100.0;120.0\r\n"
				+ "MCH;33.1 ;;;25.0 ;26.0 ;34.0 ;35.0 \r\n" 
				+ "MCHC;34.5 ;;;28.0 ;31.0 ;35.5 ;37.0 \r\n" 
				+ "RDW;14.0 ;;;7.0  ;10.0 ;16.0 ;25.0 \r\n"
				+ "MPV;10.1 ;;;6.0  ;7.0  ;11.0 ;12.5 \r\n" 
				+ "PCT;0.039;;L;0.100;0.200;0.500;0.600\r\n" 
				+ "PDW;16.5 ;;;8.0  ;10.0 ;18.0 ;25.0 \r\n"
				+ "EOS;0.3  ;;;0.0  ;0.0  ;0.4  ;0.6  \r\n" 
				+ "BAS;0.0  ;;;0.0  ;0.0  ;0.2  ;0.3  \r\n" + "EOS%;4.2 ;;;0.0 ;0.0 ;5.0 ;8.0 \r\n"
				+ "BAS%;0.7 ;;;0.0 ;0.0 ;2.0 ;5.0 \r\n"
				+ "WBC CURVE;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;6;17;30;40;46;51;53;51;48;45;42;38;33;31;33;38;41;44;49;56;65;76;89;105;126;147;158;163;173;187;200;213;227;235;232;223;217;210;194;178;168;160;146;132;121;115;111;109;112;120;124;126;135;152;172;187;196;203;207;208;209;214;220;220;215;213;214;215;217;212;198;188;182;171;156;141;137;138;131;120;111;100;89;82;80;76;69;61;54;47;43;39;32;27;23;17;13;12;11;10;8;8;10;9;8;10;14;14;\r\n"
				+ "WBC THRESHOLDS;32;49;0;\r\n"
				+ "RBC CURVE;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;2;3;4;6;10;16;23;32;44;62;83;106;130;157;183;206;223;236;244;248;245;237;227;212;194;176;158;138;118;99;83;70;60;49;40;33;26;20;16;13;10;8;6;4;3;2;2;2;2;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;\r\n"
				+ "RBC THRESHOLDS;32;57\r\n"
				+ "PLT CURVE;0;0;0;0;0;0;1;3;6;10;14;18;23;27;32;36;41;46;52;57;63;68;72;75;77;77;77;76;76;75;74;73;71;69;67;65;62;60;58;56;55;54;53;51;50;48;45;43;41;39;38;37;36;35;35;34;33;32;32;31;30;30;29;29;29;29;28;28;28;27;27;27;27;27;27;26;25;25;25;24;24;24;22;21;20;19;18;18;18;18;17;17;16;16;15;15;15;14;14;14;14;13;12;12;11;10;9;9;9;9;9;9;9;10;9;9;9;9;9;9;9;9;8;7;6;5;4;4;\r\n"
				+ "PLT THRESHOLDS;69\r\n" 
				+ "ALARMS;L1;N2;P2;\r\n" 
				+ "INTERPRETIVE_WBC;ERYB;\r\n" 
				+ "INTERPRETIVE_RBC;\r\n"
				+ "INTERPRETIVE_PLT;THR<;SCHIZ;PLTAGGR;\r\n" 
				+ "COMMENT;;\r\n" + "LMNE MATRIX;\r\n"
				+ "Z18;28;8c;Zc;5;4;2;10;4;Zb;22;3;11;20;80;Zc;80;24;Ze;30;80;Zd;1;0;70;5;Ze;4;Zd;2;0;20;Ze;13;61;Ze;c2;3;Ze;53;e0;Ze;21;Zf;20;10;45;Ze;20;8;Ze;10;40;Z2;10;Z9;2;8d;4a;0;20;Zc;22;6;80;Zd;10;0;1;Zc;1;40;98;Z6;1;Z7;4;1;2;Ze;63;Z2;80;Zb;41;e8;40;Zd;60;\r\n"
				+ ";80;80;Zd;88;1;Z5;80;Z7;4;c;cc;Zd;3;18;40;Z2;4;Z2;2;Z8;35;8;Ze;10;90;Ze;a;48;Z6;1;Z7;44;0;2;Zc;2;14;d0;Z4;80;Z9;20;c0;80;Ze;11;0;1;Zb;4;4;10;Zd;6;20;50;Zd;1;1;40;30;2;Zd;30;20;10;40;Zb;18;10;0;8;80;20;0;40;Z8;49;80;10;0;10;Zc;8;8;84;Zb;8;80;10;\r\n"
				+ ";Z6;1;Z6;1;Z3;70;Ze;9;87;12;Zc;20;0;41;c0;Zd;2;14;90;Zc;2;c;2c;c0;Zd;7;20;4a;0;2;Z9;8;0;8f;e5;a;Zd;b;a8;Zd;40;1d;ae;20;Zd;b4;7b;d8;c0;Zb;2;d;fb;c;Zc;1;35;f6;61;Zd;18;5e;78;0;4;Za;10;17;bf;a8;80;Z2;2;Z8;10;ef;df;14;80;Za;20;1;fb;fc;e0;Zc;b;7f;\r\n"
				+ ";fb;64;Zc;3;3b;fd;4e;Zb;80;20;U1;df;94;Zc;3;3f;f7;6a;20;Z8;80;Z3;f7;U1;70;0;1;Z8;40;10;43;U2;c0;Zc;5d;U1;fc;98;Zb;40;2f;U1;fb;4a;Zc;7;U2;60;Zc;bf;U1;fb;40;Z8;8;Z3;6f;U1;f4;91;Zc;bf;U1;fb;4;Zb;1;af;U1;ec;50;Zc;7f;U1;fe;90;Zb;22;U2;fc;40;Za;1;0;\r\n"
				+ ";U2;d0;40;Zb;2;7f;U1;f4;Za;2;0;9;U2;b6;Zb;1;5;U2;f4;Zb;40;e;U1;df;a8;Zc;45;7f;fd;74;Zc;5d;U1;fe;60;Zc;2f;U1;fe;60;Zb;4;bf;U1;f4;Zc;1;7f;U1;df;Zb;2;5;7e;U1;fb;8;Z3;2;Z4;80;0;1;c3;f7;f7;40;0;4;Za;85;3f;fd;81;Zc;1c;7f;fd;0;4d;Za;20;1b;df;fd;c8;0;30;\r\n"
				+ ";Z9;5;17;f7;f1;68;a0;11;2;Z9;1c;bf;fc;81;63;40;Z9;40;eb;ae;62;8;de;8;Z8;4;2;d3;9f;48;a;42;90;Za;9e;e;c1;2d;f3;48;80;Z7;28;5;85;ba;80;66;fb;4;Z9;48;f7;4e;30;d3;ef;e8;Z8;82;46;da;23;83;a7;df;f0;Z8;3;20;4f;70;d;3f;bf;20;Za;31;44;20;bf;fd;40;Z9;40;\r\n"
				+ ";0;b9;43;U1;fe;Z9;10;1;8;82;2f;U1;f0;Z4;40;Z3;2;Z2;52;5;ba;U1;62;40;Z7;42;10;0;8;15;df;bf;80;Z8;43;80;1c;10;ce;2a;f;60;10;Z6;3;Z3;ab;c;76;U1;44;Z8;20;80;11;b8;d5;9d;ce;24;Z7;1;81;40;2f;ea;3;df;ed;10;Z8;10;2;1f;fb;7d;4c;90;Z8;4;0;6;U1;fe;80;82;\r\n"
				+ ";b2;Z9;2;f;U2;f6;a0;2;Z8;8;10;2f;U2;ed;11;Z9;20;0;3f;U2;b8;a0;Zb;f;U1;fe;81;80;Za;11;1f;U1;fa;80;80;Z9;2;0;U2;a3;Zc;16;7f;U1;c2;40;Za;20;ad;U2;f4;Zc;7b;f7;fa;8a;Zb;3;U1;f7;e7;80;Zb;7f;fe;fa;c1;20;Zb;7f;U1;fc;2c;Zc;U2;ca;Zd;U2;dd;Zd;7f;e5;12;60;\r\n"
				+ ";Zc;3f;e8;Ze;3c;32;Ze;18;Z2d;T\r\n" 
				+ "LMNE SHADE MATRIX;\r\n"
				+ "Z18;28;8c;Zc;5;4;2;10;4;Zb;22;3;11;20;80;Zc;80;24;Ze;30;80;Zd;1;0;70;5;Ze;4;Zd;2;0;20;Ze;11;61;Ze;c2;1;Ze;53;60;Ze;21;Zf;20;0;45;Zf;8;Ze;10;40;Z2;10;Z9;2;89;4a;0;20;Zc;22;6;80;Zf;1;Zc;1;40;98;Z6;1;Z7;4;1;2;Ze;23;Z2;80;Zb;41;a0;40;Zd;60;0;80;\r\n"
				+ ";Zd;88;1;Z5;80;Z8;c;cc;Zd;3;18;40;Z2;4;Z2;2;Z8;34;8;Ze;10;80;Ze;a;48;Z6;1;Z9;2;Zc;2;14;d0;Z4;80;Z9;20;c0;80;Ze;11;0;1;Zb;4;4;10;Zd;6;20;50;Zd;1;1;40;30;2;Zd;30;20;10;40;Zb;10;10;0;8;80;20;0;40;Z8;49;0;10;0;10;Zc;8;8;84;Zb;8;80;Z7;1;Z6;1;Z3;70;\r\n"
				+ ";Ze;9;7;12;Zc;20;Z2;c0;Zd;2;14;90;Zc;2;c;2c;c0;Zd;5;0;4a;0;2;Z9;8;0;8f;e1;a;Zd;b;a8;Zd;40;1d;82;20;Zd;90;3;50;c0;Zb;2;5;69;c;Zc;1;34;6;21;Zd;10;48;28;0;4;Za;10;7;88;28;80;Z2;2;Z8;10;c8;89;4;80;Za;20;1;20;24;e0;Zc;a;d;8;64;Zc;2;8;c5;e;Zb;80;Z2;41;\r\n"
				+ ";94;Zc;1;28;10;6a;20;Z8;80;Z3;80;28;50;0;1;Z8;40;10;42;0;1;Zd;5c;1;8;98;Zb;40;20;0;1;4a;Zc;4;0;20;60;Zc;ae;0;49;Z9;8;Z3;4c;40;0;91;Zc;a0;0;2;4;Zb;1;a2;0;4;50;Zc;50;0;2;90;Zb;20;60;0;8;40;Za;1;0;40;0;80;40;Zb;2;Z2;24;Za;2;Z4;6;Zb;1;4;Z2;74;Zb;40;\r\n"
				+ ";c;0;2;a8;Zc;40;0;1;34;Zc;19;0;b0;20;Zc;28;0;8;60;Zb;4;a8;8;20;Zc;1;46;0;f;Zb;2;5;10;0;bb;8;Z3;2;Z4;80;0;1;c1;e0;Z3;4;Za;80;Z2;1;Zc;c;0;1;0;4d;Za;20;1a;80;20;c8;0;30;Z9;5;16;12;b0;68;a0;11;2;Z9;14;82;94;1;63;40;Z9;40;e1;2;42;8;9e;8;Z8;4;2;d2;\r\n"
				+ ";4;48;a;42;90;Za;8a;c;c1;2d;f3;8;80;Z7;28;5;5;9a;80;26;a1;4;Z9;48;e7;4e;30;c1;7;e0;Z8;82;42;d2;23;83;a2;99;30;Z8;3;20;4f;70;d;4;3;20;Za;31;44;20;8c;5;40;Z9;40;0;b9;2;a0;e;Z9;10;1;0;82;2c;80;30;Z4;40;Z3;2;Z2;52;1;90;0;2;40;Z7;42;10;0;8;15;5b;13;\r\n"
				+ ";Z9;43;0;1c;0;4e;22;e;60;10;Z6;3;Z3;23;c;52;9f;44;Z8;20;80;10;18;90;90;a;20;Z7;1;81;40;22;2;3;53;6c;10;Z8;10;2;10;0;49;44;90;Z8;4;0;2;0;10;80;82;12;Z9;2;a;0;12;44;a0;2;Z9;10;20;0;1;c4;11;Z9;20;Z3;10;b0;20;Zd;c;1;80;Za;11;10;Z3;80;Zb;e0;0;1;Zc;14;\r\n"
				+ ";60;2;2;40;Za;20;89;a0;5;34;Zc;43;e6;12;a;Zb;3;4;20;27;Zc;20;2;3a;1;20;Zb;40;0;84;2c;Zc;80;0;8;Ze;9;dd;Ze;a4;12;60;Zd;68;Ze;34;32;Ze;18;Z2d;T\r\n"
				+ "THRES 5D LMNE MATRIX;\r\n"
				+ "N1X;20;N1Y;15;N2X;35;N2Y;23;EosY;100;LneX;55;LneY;60;LnlX;50;LnlY;28;RneY;105;NmY;18;LmX;69;LmnX;63;LmnY;26;ICX;105;\r\n"
				+ "BasoX1;60;BasoY1;26;BasoX2;64;BasoY2;30;BasoX3;70;BasoY3;29;BasoX4;65;BasoY4;20;NHH;2;NHL;2;RLL;2;RLR;3;NLH;2;NLL;2;HLH;2;HLL;2;\r\n"
				+ "END_RESULT;";
		
		return sampleData;
		//@formatter:on
	}

}
