package com.floreantpos.model.dao;

import java.text.DecimalFormat;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.SequenceNumber;

public class SequenceNumberDAO extends BaseSequenceNumberDAO {

	private final static DecimalFormat fourDigitFormat = new DecimalFormat("0000");

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public SequenceNumberDAO() {
	}

	public String getNextLedgerRef(String ref) {
		int nextSequenceNumber = getNextSequenceNumber(SequenceNumber.SEQ_LEDGER_ENTRY);
		return ref + "/" + fourDigitFormat.format(nextSequenceNumber);
	}

	public int getNextSequenceNumber(String type) {
		int nextSequenceNumber = getNextSequenceNumber(type, null);

		return nextSequenceNumber;
	}

	public synchronized int getNextSequenceNumber(String type, String date) {
		try (Session session = createNewSession()) {
			Transaction transaction = session.beginTransaction();
			SequenceNumber ref = getLastSequenceNumber(session, type, date);

			int refNumber = 1;
			if (ref == null) {
				ref = new SequenceNumber();
				ref.setType(type);
				ref.setSequenceDate(date);
				ref.setNextSequenceNumber(2);
				session.save(ref);
			}
			else {
				refNumber = ref.getNextSequenceNumber();
				ref.setNextSequenceNumber(refNumber + 1);
				session.update(ref);
			}

			transaction.commit();
			return refNumber;
		}
	}

	public synchronized SequenceNumber getLastSequenceNumber(String type, String date) {
		try (Session session = createNewSession()) {
			return getLastSequenceNumber(session, type, date);
		}
	}

	public synchronized SequenceNumber getLastSequenceNumber(Session session, String type, String date) {
		Criteria criteria = session.createCriteria(SequenceNumber.class);
		criteria.add(Restrictions.eq(SequenceNumber.PROP_TYPE, type));
		if (StringUtils.isNotBlank(date)) {
			criteria.add(Restrictions.eq(SequenceNumber.PROP_SEQUENCE_DATE, date));
		}
		criteria.setMaxResults(1);
		return (SequenceNumber) criteria.uniqueResult();
	}

	public void resetAll(Session session) {
		List<SequenceNumber> refList = findAll(session);
		if (refList == null)
			return;
		for (SequenceNumber ref : refList) {
			ref.setNextSequenceNumber(0);
			session.saveOrUpdate(ref);
		}
	}
}