/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report.model;

import java.text.SimpleDateFormat;

import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.report.WeeklyPayrollReportData;
import com.floreantpos.swing.ListTableModel;

public class BiWeeklyPayrollReportModel extends ListTableModel {
	SimpleDateFormat dateFormat2 = new SimpleDateFormat("EEE MMM dd"); //$NON-NLS-1$

	public BiWeeklyPayrollReportModel() {
		super(new String[] { "userID", "userName", "role", "regHour", "overtime", "regHourDis", "overtimeDis", "regPmnt", "otPmnt", "total", "totalDis", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$//$NON-NLS-9$//$NON-NLS-10$//$NON-NLS-11$
				"payment", "decTips", "nonCashTips", "dateOfWeek", "groupKey" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
	}

	String userIdKey = ""; //$NON-NLS-1$
	int count = 0;

	public Object getValueAt(int rowIndex, int columnIndex) {
		WeeklyPayrollReportData data = (WeeklyPayrollReportData) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				String currentUserId = getUserId(data);
				if (!userIdKey.equals(currentUserId)) {
					userIdKey = currentUserId;
					count = 0;
				}
				count++;
				return currentUserId;

			case 1:
				return data.getUser().getFirstName() + " " + data.getUser().getLastName(); //$NON-NLS-1$

			case 2:
				UserType type = data.getUser().getType();
				if (type == null) {
					return ""; //$NON-NLS-1$
				}
				return type.getName();

			case 3:
				return data.getRegularWorkHourMs();

			case 4:
				return data.getOvertimeMs();

			case 5:
				return data.getRegularHourDisplay();

			case 6:
				return data.getOvertimeDisplay();

			case 7:
				return data.getRegularPayment();

			case 8:
				return data.getOvertimePayment();

			case 9:
				return data.getTotalWorkHourMs();

			case 10:
				return data.getTotalHourDisplay();

			case 11:
				return data.getTotalPayment();

			case 12:
				return data.getTotalDeclaredTips();

			case 13:
				return data.getTotalNoCashTips();

			case 14:
				return dateFormat2.format(data.getFromDateOfWeek()) + " - " //$NON-NLS-1$
						+ dateFormat2.format(data.getToDateOfWeek());

			case 15:
				if (count % 2 == 0) {
					return userIdKey + "_" + (count - 1); //$NON-NLS-1$
				}
				return userIdKey + "_" + count; //$NON-NLS-1$

		}
		return null;
	}

	private String getUserId(WeeklyPayrollReportData data) {
		User user = data.getUser();
		User parentUser = user.getParentUser();
		if (parentUser != null) {
			return parentUser.getId();
		}
		return user.getId();
	}

}
