package com.floreantpos.model;

import java.sql.Blob;

import javax.sql.rowset.serial.SerialBlob;
import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.apache.commons.codec.binary.Base64;

public class BlobXmlAdapter extends XmlAdapter<String, Blob> {
	@Override
	public Blob unmarshal(String v) throws Exception {
		if (v == null)
			v = ""; //$NON-NLS-1$
		byte[] bytes = Base64.decodeBase64(v);
		return new SerialBlob(bytes);
	}

	@Override
	public String marshal(Blob v) throws Exception {
		if (v == null)
			return ""; //$NON-NLS-1$
		return v.getBytes(1l, (int) v.length()).toString();
	}
}