package com.floreantpos.model;

import java.util.List;

import com.floreantpos.payment.PaymentListener;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.services.PostPaymentProcessor;

public class PaymentData {

	private PaymentType paymentType;
	private PaymentPlugin paymentPlugin;
	private PaymentListener paymentListener;
	private Ticket sourceTicket;
	private Ticket ticket;
	private PosTransaction transaction;
	private List<Ticket> unpaidCustomerTickets;
	private double tenderAmount;
	private User cashier;
	private PostPaymentProcessor postPaymentService;
	private boolean closeTicketIfApplicable;
	private boolean showTransactionCompleteDialog;
	private boolean shouldUpdateSource;

	private CustomPayment customPayment;
	private BankAccount linkedBankAccount;
	private String paymentRef;
	private boolean confirmPayment;

	public PaymentData() {
	}

	public PaymentType getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(PaymentType paymentType) {
		this.paymentType = paymentType;
	}

	public PaymentPlugin getPaymentPlugin() {
		return paymentPlugin;
	}

	public void setPaymentPlugin(PaymentPlugin paymentPlugin) {
		this.paymentPlugin = paymentPlugin;
	}

	public PaymentListener getPaymentListener() {
		return paymentListener;
	}

	public void setPaymentListener(PaymentListener paymentListener) {
		this.paymentListener = paymentListener;
	}

	public Ticket getSourceTicket() {
		return sourceTicket;
	}

	public void setSourceTicket(Ticket sourceTicket) {
		this.sourceTicket = sourceTicket;
	}

	public Ticket getTicket() {
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
	}

	public PosTransaction getTransaction() {
		return transaction;
	}

	public void setTransaction(PosTransaction transaction) {
		this.transaction = transaction;
	}

	public List<Ticket> getUnpaidCustomerTickets() {
		return unpaidCustomerTickets;
	}

	public void setUnpaidCustomerTickets(List<Ticket> unpaidCustomerTickets) {
		this.unpaidCustomerTickets = unpaidCustomerTickets;
	}

	public double getTenderAmount() {
		return tenderAmount;
	}

	public void setTenderAmount(double tenderAmount) {
		this.tenderAmount = tenderAmount;
	}

	public User getCashier() {
		return cashier;
	}

	public void setCashier(User cashier) {
		this.cashier = cashier;
	}

	public PostPaymentProcessor getPostPaymentService() {
		return postPaymentService;
	}

	public void setPostPaymentService(PostPaymentProcessor postPaymentService) {
		this.postPaymentService = postPaymentService;
	}

	public boolean isCloseTicketIfApplicable() {
		return closeTicketIfApplicable;
	}

	public void setCloseTicketIfApplicable(boolean closeTicketIfApplicable) {
		this.closeTicketIfApplicable = closeTicketIfApplicable;
	}

	public boolean isShowTransactionCompleteDialog() {
		return showTransactionCompleteDialog;
	}

	public void setShowTransactionCompleteDialog(boolean showTransactionCompleteDialog) {
		this.showTransactionCompleteDialog = showTransactionCompleteDialog;
	}

	public boolean isShouldUpdateSource() {
		return shouldUpdateSource;
	}

	public void setShouldUpdateSource(boolean shouldUpdateSource) {
		this.shouldUpdateSource = shouldUpdateSource;
	}

	public CustomPayment getCustomPayment() {
		return customPayment;
	}

	public void setCustomPayment(CustomPayment customPayment) {
		this.customPayment = customPayment;
	}

	public BankAccount getLinkedBankAccount() {
		return linkedBankAccount;
	}

	public void setLinkedBankAccount(BankAccount linkedBankAccount) {
		this.linkedBankAccount = linkedBankAccount;
	}

	public String getPaymentRef() {
		return paymentRef;
	}

	public void setPaymentRef(String paymentRef) {
		this.paymentRef = paymentRef;
	}

	public boolean isConfirmPayment() {
		return confirmPayment;
	}

	public void setConfirmPayment(boolean confirmPayment) {
		this.confirmPayment = confirmPayment;
	}

}
