package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CronJob;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class CronJobDAO extends BaseCronJobDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public CronJobDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		CronJob bean = (CronJob) obj;
		if (bean == null) {
			throw new PosException(Messages.getString("CronJobDAO.0")); //$NON-NLS-1$
		}
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	public List<CronJob> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}

	public List<CronJob> findAllActive() {
		try (Session session = this.createNewSession()) {
			Criteria criteria = session.createCriteria(CronJob.class);
			criteria.add(Restrictions.eq(CronJob.PROP_ACTIVE, true));
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}

	public List<CronJob> findCronJobByJobName(String jobName) {

		List<CronJob> cronJobs = null;
		Session session = null;
		Criteria criteria = null;
		try {

			session = this.createNewSession();
			criteria = session.createCriteria(CronJob.class);
			if (StringUtils.isNotEmpty(jobName)) {
				criteria.add(Restrictions.ilike(CronJob.PROP_JOB_NAME, jobName, MatchMode.ANYWHERE));
			}
			addDeletedFilter(criteria);
			cronJobs = criteria.list();
		} finally {

			this.closeSession(session);
		}

		return cronJobs;
	}

	public void saveOrUpdate(CronJob cronJob) {

		try {

			CronJob storedCronJob = super.get(cronJob.getId());
			if (storedCronJob == null) {

				storedCronJob = new CronJob();
				storedCronJob.setExecutionTime(cronJob.getExecutionTime());
				storedCronJob.setFrequency(cronJob.getFrequency());
				storedCronJob.setJobId(cronJob.getJobId());
				storedCronJob.setJobName(cronJob.getJobName());
				storedCronJob.setLastSyncTime(cronJob.getLastSyncTime());
				storedCronJob.setLastUpdateTime(cronJob.getLastUpdateTime());
				storedCronJob.setProperties(cronJob.getProperties());
				storedCronJob.setId(cronJob.getId());
				storedCronJob.setActive(cronJob.isActive());
				super.save(storedCronJob);
			}
			else {

				storedCronJob.setExecutionTime(cronJob.getExecutionTime());
				storedCronJob.setFrequency(cronJob.getFrequency());
				storedCronJob.setJobId(cronJob.getJobId());
				storedCronJob.setJobName(cronJob.getJobName());
				storedCronJob.setLastSyncTime(cronJob.getLastSyncTime());
				storedCronJob.setLastUpdateTime(cronJob.getLastUpdateTime());
				storedCronJob.setProperties(cronJob.getProperties());
				storedCronJob.setActive(cronJob.isActive());
				super.update(storedCronJob);
			}
		} catch (Exception e0) {

			PosLog.error(this.getClass(), e0);
		}
	}

	public void saveOrUpdateCronJob(List<CronJob> salesAreaList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (salesAreaList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();
			for (Iterator iterator = salesAreaList.iterator(); iterator.hasNext();) {
				CronJob item = (CronJob) iterator.next();
				CronJobDAO dao = CronJobDAO.getInstance();
				CronJob existingItem = dao.get(item.getId());
				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						PosLog.info(getClass(), item.getJobName() + " already updated"); //$NON-NLS-1$
						continue;
					}
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					dao.update(existingItem);
				}
				else {
					item.setVersion(0);
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					dao.save(item);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}

	}
}