/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.extension;

import java.awt.Component;

import com.floreantpos.model.CardReader;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.ui.views.payment.CardProcessor;

import net.xeoh.plugins.base.annotations.PluginImplementation;

@PluginImplementation
public class ExternalPaymentGatewayPlugin extends PaymentGatewayPlugin {
	public static final String ID = CardReader.EXTERNAL_TERMINAL.name(); //$NON-NLS-1$

	@Override
	public String getProductName() {
		return ID.replaceAll("_", " "); //$NON-NLS-1$
	}


	@Override
	public String toString() {
		return getProductName();
	}

	@Override
	public String getId() {
		return ID;
	}

	@Override
	public CardProcessor getProcessor() {
		return new ExtTermProcessor();
	}

	@Override
	public boolean shouldShowCardInputProcessor() {
		return true;
	}

	@Override
	public String getProductVersion() {
		return null;
	}

	@Override
	public Component getParent() {
		return null;
	}

	public Integer getProductNumericVersion() {
		return null;
	}

	public String getUpdateServerURL() {
		return null;
	}
	
	@Override
	public boolean supportsPreAuth() {
		return false;
	}
	
	public class ExtTermProcessor implements CardProcessor  {

		@Override
		public void preAuth(PosTransaction transaction) throws Exception {
		}

		@Override
		public void captureAuthAmount(PosTransaction transaction) throws Exception {
			transaction.setCaptured(true);
		}

		@Override
		public void chargeAmount(PosTransaction transaction) throws Exception {
		}

		@Override
		public void voidTransaction(PosTransaction transaction) throws Exception {
			transaction.setCaptured(false);
			transaction.setVoided(true);
		}

		@Override
		public void refundTransaction(PosTransaction transaction, double refundAmount) throws Exception {
		}

		@Override
		public String getCardInformationForReceipt(PosTransaction transaction) {
			return null;
		}

		@Override
		public void cancelTransaction() {
		}
		
	}

	public String getSecurityCode() {
		return null;
	}
}
