package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseAppointment;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlAccessorType(XmlAccessType.FIELD)
public class Appointment extends BaseAppointment implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;
	private transient Doctor doctor;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Appointment() {
	}

	/**
	 * Constructor for primary key
	 */
	public Appointment(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	public String getPatientNameByProperty() {
		return getProperty("patientName"); //$NON-NLS-1$
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public String getPatientPhoneNo() {
		return getProperty("patientPhoneNo"); //$NON-NLS-1$
	}

	public void setPatient(Customer patient) {
		setPatientId(patient == null ? null : patient.getId());
		addProperty("patientName", patient == null ? "" : patient.getName()); //$NON-NLS-1$ //$NON-NLS-2$
		addProperty("patientPhoneNo", patient == null ? "" : patient.getMobileNo()); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public String doctorNameDisplay() {
		Doctor doctor = getDoctor();
		if (doctor != null) {
			return doctor.getName();
		}

		return StringUtils.EMPTY;
	}

	public Doctor getDoctor() {
		String doctorId = getDoctorId();
		if (doctor == null && StringUtils.isNotBlank(doctorId)) {
			doctor = (Doctor) DataProvider.get().getObjectOf(Doctor.class, doctorId);
		}
		return doctor;
	}

	public void putOutdoorTicketId(String outdoorTicketId) {
		addProperty("outdoorTicketId", outdoorTicketId); //$NON-NLS-1$
	}

	public String getOutdoorTicketId() {
		return getProperty("outdoorTicketId"); //$NON-NLS-1$
	}

}