package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum BloodComponentType {
	WHOLE_BLOOD("Whole blood"), RCC("RCC"), FFP("FFP"), SDP("SDP (Apheresis PT)"), RDP("RDP");

	private final String displayName;

	BloodComponentType(String displayName) {
		this.displayName = displayName;
	}

	public String getDisplayName() {
		return displayName;
	}

	public static BloodComponentType fromString(String s) {
		if (StringUtils.isBlank(s)) {
			return null;
		}

		try {
			return valueOf(s);
		} catch (Exception e) {
			return null;
		}
	}

	@Override
	public String toString() {
		return getDisplayName();
	}
}
