package com.floreantpos.model.util;

import java.util.Random;

import com.floreantpos.model.dao.CustomerDAO;

public class CustomerPINGenerationUtil {

	public CustomerPINGenerationUtil() {

	}

	public String createPIN(String pinLength) throws Exception {
		String rawString = "1234567890"; //$NON-NLS-1$
		StringBuilder stringBuilder = new StringBuilder();
		String password = generatePIN(rawString, stringBuilder, pinLength);
		while (CustomerDAO.getInstance().findCustomerBySecretPin(password) != null) {
			stringBuilder.setLength(0);
			password = generatePIN(rawString, stringBuilder, pinLength);
		}
		return password;
	}

	public static String generatePIN(String rawString, StringBuilder stringBuilder, String passWordLength) {
		Random rand = new Random();
		String password = ""; //$NON-NLS-1$
		if (passWordLength.length() == 0) {
			while (stringBuilder.length() < 4) {
				int index = (int) (rand.nextFloat() * rawString.length());
				stringBuilder.append(rawString.charAt(index));
			}
			password = stringBuilder.toString();
		}
		else {
			while (stringBuilder.length() < Integer.parseInt(passWordLength)) {
				int index = (int) (rand.nextFloat() * rawString.length());
				stringBuilder.append(rawString.charAt(index));
			}
			password = stringBuilder.toString();
		}
		return password;
	}

	//	public String createRandomCustomerId(int passWordLength) {
	//		String rawString = "1234567890"; //$NON-NLS-1$
	//		StringBuilder stringBuilder = new StringBuilder();
	//		String userId = genUserId(rawString, stringBuilder, passWordLength);
	//		while (UserDAO.getInstance().isUserExist(userId)) {
	//			stringBuilder.setLength(0);
	//			userId = genUserId(rawString, stringBuilder, passWordLength);
	//		}
	//		return userId;
	//	}
	//
	//	private String genUserId(String rawString, StringBuilder stringBuilder, int passWordLength) {
	//		Random rand = new Random();
	//		String password = ""; //$NON-NLS-1$
	//		if (passWordLength == 0) {
	//			while (stringBuilder.length() < 5) {
	//				int index = (int) (rand.nextFloat() * rawString.length());
	//				stringBuilder.append(rawString.charAt(index));
	//			}
	//			password = stringBuilder.toString();
	//		}
	//		else {
	//			while (stringBuilder.length() < passWordLength) {
	//				int index = Math.abs((int) (rand.nextDouble() * 10));
	//				if (stringBuilder.length() == 0 && index > 0) {
	//					stringBuilder.append(index);
	//				}
	//				else if (stringBuilder.length() > 0) {
	//					stringBuilder.append(index);
	//				}
	//			}
	//			password = stringBuilder.toString();
	//		}
	//		return password;
	//	}

}
