package com.floreantpos.model.util.pricecalc;

import java.lang.reflect.Method;

import com.floreantpos.model.Ticket;

public class TicketCalcFactory {
	private static TicketCalc ticketCalcV2;

	public static TicketCalc getCalc(Ticket ticket) {
		try {
			if (ticketCalcV2 != null) {
				return ticketCalcV2;
			}

			Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.TicketPriceCalcV2"); //$NON-NLS-1$
			Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
			ticketCalcV2 = (TicketCalc) method.invoke(null);
			return ticketCalcV2;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
