package com.floreantpos.report.model;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;

public class ProvidentFundReportModel {

	public static final String PROP_EMPLOYEE_ID = "employeeId"; //$NON-NLS-1$
	public static final String PROP_PROVIDENT_FUND_AMOUNT = "providentFundAmount"; //$NON-NLS-1$
	public static final String PROP_START_DATE = "startDate"; //$NON-NLS-1$
	public static final String PROP_START_DATE_DISPLAY = "startDateDisplay"; //$NON-NLS-1$
	public static final String PROP_INSTALMENT_NO = "instalmentNo"; //$NON-NLS-1$
	public static final String PROP_TOTAL_AMOUNT = "totalAmount"; //$NON-NLS-1$
	public static final String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$

	private String employeeName;
	private String employeeId;
	private String startDateDisplay;
	private String outletId;

	private Double providentFundAmount;
	private Double totalAmount;

	private Date startDate;
	private Long instalmentNo;

	public ProvidentFundReportModel() {
	}

	public String getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(String employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		if (StringUtils.isNotBlank(employeeName)) {
			return employeeName;
		}
		if (StringUtils.isNotBlank(employeeId) && StringUtils.isNotBlank(outletId)) {
			User user = UserDAO.getInstance().get(employeeId, outletId);
			if (user != null) {
				employeeName = user.getFullName();
			}
		}
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Long getInstalmentNo() {
		return instalmentNo;
	}

	public void setInstalmentNo(Long instalmentNo) {
		this.instalmentNo = instalmentNo;
	}

	public Double getTotalAmount() {
		return totalAmount == null ? 0D : totalAmount;
	}

	public void setTotalAmount(Double totalAmount) {
		this.totalAmount = totalAmount;
	}

	public Double getProvidentFundAmount() {
		return providentFundAmount;
	}

	public void setProvidentFundAmount(Double providentFundAmount) {
		this.providentFundAmount = providentFundAmount;
	}

	public String getStartDateDisplay() {
		if (startDate != null) {
			return DateUtil.formatDateWithoutTime(startDate);
		}

		return startDateDisplay;
	}

	public void setStartDateDisplay(String startDateDisplay) {
		this.startDateDisplay = startDateDisplay;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

}
