package com.orocube.cloudpos.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.floreantpos.PosLog;
import com.floreantpos.model.DoctorVisit;
import com.floreantpos.model.DoctorVisitMedicineItem;
import com.floreantpos.model.MedicationSchedule;
import com.floreantpos.model.MedicationStatus;
import com.floreantpos.model.dao.MedicationScheduleDAO;

public class DoctorVisitMedicineItemScheduleAction {

	private DoctorVisit doctorVisit;

	public DoctorVisitMedicineItemScheduleAction() {
	}

	public DoctorVisitMedicineItemScheduleAction(DoctorVisit doctorVisit) {
		this.doctorVisit = doctorVisit;
	}

	public boolean execute() {
		if (doctorVisit == null) {
			return false;
		}

		try {
			List<DoctorVisitMedicineItem> dvMedicineItems = doctorVisit.getMedicineItems();
			List<MedicationSchedule> medScheduleList = createMedicationSchedule(doctorVisit, dvMedicineItems);

			MedicationScheduleDAO.getInstance().saveMedicineItemMedicationSchedules(dvMedicineItems, medScheduleList);
			PosLog.debug(DoctorVisitMedicineItemScheduleAction.class, "The medication schedule has been created successfully.");

			return true;
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}

		return false;
	}

	public static List<MedicationSchedule> createMedicationSchedule(DoctorVisit doctorVisit, List<DoctorVisitMedicineItem> dvMedicineItems) {

		String admissionId = doctorVisit.getAdmissionId();
		String patientId = doctorVisit.getPatientId();

		List<MedicationSchedule> medScheduleList = new ArrayList<MedicationSchedule>();
		List<MedicationSchedule> existingMedScheduleList = MedicationScheduleDAO.getInstance().getOtherPendingMedicationSchedulesBy(admissionId, patientId);
		PosLog.debug(DoctorVisitMedicineItemScheduleAction.class, "Existing pending medication schedule: " + existingMedScheduleList.size());

		if (dvMedicineItems != null) {
			for (Iterator<DoctorVisitMedicineItem> iterator = dvMedicineItems.iterator(); iterator.hasNext();) {
				DoctorVisitMedicineItem dvMedicineItem = (DoctorVisitMedicineItem) iterator.next();
				if (dvMedicineItem.isMedicationReScheduled()) {
					double medicationDuration = dvMedicineItem.getMedicationDuration();
					dvMedicineItem.putMedicationDuration(medicationDuration + 7);
					dvMedicineItem.putMedicationScheduled(false);
				}

				medScheduleList.addAll(dvMedicineItem.createMedicationSchedules(existingMedScheduleList));
			}
		}

		for (MedicationSchedule exSchedule : existingMedScheduleList) {
			exSchedule.setStatus(MedicationStatus.CANCELLED.name());
			exSchedule.putActionDescription(
					String.format("Medication schedule has been canceled for %s to %s.", exSchedule.getDoctorVisitId(), doctorVisit.getId()));
			exSchedule.putCancelReason("Medication schedule has been canceled for rescheduling.");

			medScheduleList.add(exSchedule);
		}
		return medScheduleList;
	}

}
