package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.floreantpos.model.base.BaseBed;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.RoomDAO;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class Bed extends BaseBed implements PropertyContainer2, TimedModel {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private Room room;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Bed () {
    }

	/**
	 * Constructor for primary key
	 */
	public Bed (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return super.getNumber();
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public Room getRoom() {
		if (room != null) {
			return room;
		}
		if (StringUtils.isNotBlank(super.getRoomId())) {
			room = RoomDAO.getInstance().get(super.getRoomId());
		}
		return room;
	}

	public void setRoom(Room room) {
		this.room = room;
	}

	public void putCustomerName(String customerName) {
		if (StringUtils.isBlank(customerName)) {
			removeProperty("customerName"); //$NON-NLS-1$
			return;
		}
		addProperty("customerName", customerName); //$NON-NLS-1$
	}

	public String getCustomerName() {
		String customerName = getProperty("customerName"); //$NON-NLS-1$
		if (customerName == null) {
			return ""; //$NON-NLS-1$
		}
		return customerName;
	}

	public String getNameDisplay() {
		String roomName = ""; //$NON-NLS-1$
		if (getRoom() != null) {
			roomName = getRoom().getName() + " "; //$NON-NLS-1$
		}
		return roomName + "bed " + getNumber().trim(); //$NON-NLS-1$
	}

	@XmlTransient
	@JsonIgnore
	public List<MenuItem> getEquipments() {
		List<MenuItem> equipments = new ArrayList<>();
		JsonObject jsonProperties = getPropertyStore();
		if (jsonProperties == null || !jsonProperties.has("equipments")) { //$NON-NLS-1$
			return equipments;
		}
		JsonArray equipmentsJsonArray = jsonProperties.get("equipments").getAsJsonArray(); //$NON-NLS-1$
		for (int i = 0; i < equipmentsJsonArray.size(); i++) {
			String itemId = equipmentsJsonArray.get(i).getAsString();
			if (StringUtils.isBlank(itemId)) {
				continue;
			}
			MenuItem item = MenuItemDAO.getInstance().get(itemId);
			if (item == null) {
				continue;
			}
			equipments.add(item);
		}
		return equipments;
	}

	public void setEquipments(List<MenuItem> equipments) {
		if (equipments == null) {
			equipments = new ArrayList<>();
		}
		JsonArray equipmentsJsonArray = new JsonArray();
		for (MenuItem item : equipments) {
			equipmentsJsonArray.add(item.getId());
		}
		getPropertyStore().add("equipments", equipmentsJsonArray); //$NON-NLS-1$
	}

}