package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.util.ServiceChargeType;

public class UserSalaryDeductionModel {
	private String deductionReason;
	private double deductionAmount;
	private String chargeTypeName;
	private double calculationAmount;
	private String methodType;
	private Double daysOf;
	private boolean repeat;

	public UserSalaryDeductionModel(String deductionReason, double deductionAmount, String chargeTypeName, double calculationAmount, String methodType,
			Double daysOf, boolean repeat) {
		super();
		this.deductionReason = deductionReason;
		this.deductionAmount = deductionAmount;
		this.chargeTypeName = chargeTypeName;
		this.calculationAmount = calculationAmount;
		this.methodType = methodType;
		this.daysOf = daysOf;
		this.repeat = repeat;
	}

	public String getDeductionReason() {
		return deductionReason;
	}

	public void setDeductionReason(String deductionReason) {
		this.deductionReason = deductionReason;
	}

	public double getDeductionAmount() {
		return deductionAmount;
	}

	public void setDeductionAmount(double deductionAmount) {
		this.deductionAmount = deductionAmount;
	}

	public String getChargeTypeName() {
		return chargeTypeName;
	}

	public void setChargeTypeName(String chargeTypeName) {
		this.chargeTypeName = chargeTypeName;
	}

	public double getCalculationAmount() {
		return calculationAmount;
	}

	public void setCalculationAmount(double calculationAmount) {
		this.calculationAmount = calculationAmount;
	}

	public String getMethodType() {
		return methodType;
	}

	public void setMethodType(String methodType) {
		this.methodType = methodType;
	}

	public double getDaysOf() {
		return daysOf == null ? 1 : daysOf;
	}

	public void setDaysOf(double daysOf) {
		this.daysOf = daysOf;
	}

	public boolean isRepeat() {
		return repeat;
	}

	public void setRepeat(boolean repeat) {
		this.repeat = repeat;
	}

	public double getCalculatedDeductionAmount(User user) {
		String chargeTypeName = getChargeTypeName();
		if (StringUtils.isBlank(chargeTypeName)) {
			return 0;
		}

		ServiceChargeType calculationType = ServiceChargeType.valueOf(chargeTypeName);
		return calculateDeductionAmount(user, calculationType, ServiceChargeType.FIXEDAMOUNT == calculationType ? deductionAmount : calculationAmount,
				methodType, getDaysOf());
	}

	public static double calculateDeductionAmount(User user, ServiceChargeType deductionTypeName, double calculationAmount, String methodType, double days) {

		if (deductionTypeName == ServiceChargeType.FIXEDAMOUNT) {
			return calculationAmount;
		}

		if (deductionTypeName == ServiceChargeType.PERCENTAGE) {
			double salaryAmount;
			if (methodType.equals("Monthly salary")) {
				salaryAmount = user.getMonthlySalaryAmount();
				double ratePersent = calculationAmount / 100;
				return (salaryAmount * ratePersent);
			}

			//daily calculation
			salaryAmount = user.getMonthlySalaryAmount() == 0 ? 0 : user.getMonthlySalaryAmount() / 30;
			double ratePersent = calculationAmount / 100;
			return (salaryAmount * ratePersent * days);
		}
		return 0;
	}

}