package com.floreantpos.report.model;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.swing.ListTableModel;

public class LabDoctorPaymentsReportModel extends ListTableModel {
	public LabDoctorPaymentsReportModel() {
		super(new String[] { "customerName", "orderId", "orderDate", "date", "paymentType", "amount", "customerId" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction reportData = (PosTransaction) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return reportData.getRecepientCustomerName();
			case 1:
				return reportData.getTransTicketIdsDisplay();
			case 2:
				return reportData.getOrderDateDisplayString();
			case 3:
				return reportData.getDateDisplayString();

			case 4:

				return reportData.getPaymentTypeDisplayString();

			case 5:
				Double amount = reportData.getAmount();
				if (amount.isNaN()) {
					return 0d;
				}
				return amount;

			case 6:
				return reportData.getRecepientId();
		}
		return null;
	}

}