package com.floreantpos.util;

import java.io.Serializable;
import java.lang.reflect.Method;

import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

import com.floreantpos.Messages;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.GenericDAO;

/**
 * An id generator class which will create id based on the model's name.
 * 
 * @author mshahriar
 */
public class NameBaseIdGenerator implements IdentifierGenerator {
	public Serializable generate(SessionImplementor sessionIm, Object object) throws HibernateException {
		Class<? extends Object> clazz = object.getClass();
		try {
			Method method = clazz.getMethod("getId", (Class<?>[]) null); //$NON-NLS-1$
			if (method != null) {
				Object id = method.invoke(object, (Object[]) null);
				if (id != null) {
					return (Serializable) id;
				}
			}

			method = clazz.getMethod("getName", (Class<?>[]) null); //$NON-NLS-1$
			if (method == null) {
				throw new HibernateException(clazz.getName() + Messages.getString("NameBaseIdGenerator.2")); //$NON-NLS-1$
			}
			String name = (String) method.invoke(object, (Object[]) null);
			if (name == null) {
				throw new HibernateException(Messages.getString("NameBaseIdGenerator.3") + clazz.getName()); //$NON-NLS-1$
			}
			try (Session session = GenericDAO.getInstance().createNewSession()) {
				return generateId(name, clazz, 0, session);
			}
		} catch (Exception e) {
			throw new HibernateException(e);
		}
	}

	public static String generateId(String name, Class<? extends Object> clazz, int count, Session session) {
//		String id = String.valueOf(Math.abs(name.hashCode()));
		String id = name.toLowerCase().replaceAll("\\W", "_");
		if (count > 0) {
			id += "_" + count;//$NON-NLS-1$
		}

		///check if the class is a subclass of Shift
		Class<?> superclass = clazz.getSuperclass().getSuperclass();
		if (superclass == Shift.class) {
			clazz = Shift.class;
		}
		///
		Object object = session.get(clazz, id);
		if (object == null) {
			return id;
		}
		return generateId(name, clazz, ++count, session);
	}

	public static String generateId(Class<? extends Object> clazz, String name) {
		int count = 0;
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			return generateId(name, clazz, ++count, session);
		}
	}

	/**
	 * @deprecated Use {@link #generateId(Class, String)}
	 *	when model have composite key use {@link #generateId(Class, String, String)} 
	 * @param name
	 * @return
	 */
	public static String generateId(String name) {
		return String.valueOf(Math.abs(name.hashCode()));
	}

	/**
	 * 
	 * @param name
	 * @param outletId
	 * 
	 * @return
	 */
	public static String generateId(Class<? extends Object> clazz, String name, String outletId) {
		int count = 0;
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			return generateId(name, outletId, clazz, count, session);
		}
	}

	public static String generateId(String name, String outletId, Class<? extends Object> clazz, int count, Session session) {
		String id = String.valueOf(Math.abs(name.hashCode()));
		if (count > 0) {
			id += "_" + count;//$NON-NLS-1$
		}

		///check if the class is a subclass of Shift
		Class<?> superclass = clazz.getSuperclass().getSuperclass();
		if (superclass == Shift.class) {
			clazz = Shift.class;
		}

		Object object = null;
		if (StringUtils.isNotBlank(outletId)) {
			object = GenericDAO.getInstance().findObjectByCompositeKey(clazz, id, outletId);
		}
		else {
			object = session.get(clazz, id);
		}

		if (object == null) {
			return id;
		}
		return generateId(name, outletId, clazz, ++count, session);
	}
}
