package com.floreantpos.teminaltype;

public enum TerminalCategory {
	REGULAR(0), WEB(1), KIOSK(2), TABLET(3);

	private Integer type;

	private TerminalCategory(Integer type) {
		this.type = type;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public static TerminalCategory getType(int type) {
		for (TerminalCategory category : TerminalCategory.values()) {
			if (category.getType() == type) {
				return category;
			}
		}
		return REGULAR;
	}

}
