package com.orocube.rest.service;

import java.lang.reflect.Type;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.PrescriptionItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class PrescriptionItemJsonSerializer implements JsonSerializer<PrescriptionItem> {
	private final GsonBuilder gsonBuilder = BaseDataServiceDao.getGsonBuilder();
	private Outlet outlet;

	public PrescriptionItemJsonSerializer(boolean serializeNulls) {
		if (serializeNulls) {
			gsonBuilder.serializeNulls();
		}

		Store store = StoreDAO.getRestaurant();
		if (store != null && StringUtils.isNotBlank(store.getDefaultOutletId())) {
			outlet = OutletDAO.getInstance().get(store.getDefaultOutletId());
		}
	}

	@Override
	public JsonElement serialize(PrescriptionItem src, Type typeOfSrc, JsonSerializationContext context) {
		JsonObject jsonObject = gsonBuilder.create().toJsonTree(src).getAsJsonObject();
		jsonObject.addProperty("itemNameDisplayWithInstruction",
				src.getItemNameDisplayWithInstruction(false, outlet == null ? false : outlet.isShowReportsInBangla()));
		return jsonObject;
	}

}
