package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PAYOUT_REASONS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PAYOUT_REASONS"
 */

public abstract class BasePayoutReason  implements Comparable, Serializable {

	public static String REF = "PayoutReason"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_REASON = "reason"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$


	// constructors
	public BasePayoutReason () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BasePayoutReason (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String reason;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */
				public long getVersion () {
						return version;
			}

	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
				public java.util.Date getLastUpdateTime () {
						return lastUpdateTime;
			}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
				public java.util.Date getLastSyncTime () {
						return lastSyncTime;
			}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: REASON
	 */
				public java.lang.String getReason () {
						return reason;
			}

	/**
	 * Set the value related to the column: REASON
	 * @param reason the REASON value
	 */
			public void setReason (java.lang.String reason) {
			this.reason = reason;
	}

			/**
			 	 * Return the value associated with the column: DELETED
			 	 */
			 
			 	public java.lang.Boolean isDeleted () {
			 						return deleted == null ? Boolean.valueOf(false) : deleted;
			 			}
			 
			 	public java.lang.Boolean getDeleted () {
			 					return deleted == null ? Boolean.valueOf(false) : deleted;
			 			}
			 
			 
			 	/**
			 	 * Set the value related to the column: DELETED
			 	 * @param deleted the DELETED value
			 	 */
			 			public void setDeleted (java.lang.Boolean deleted) {
			 			this.deleted = deleted;
			 	}
			 
			 
			 	/**
			 	 * Custom property
			 	 */
			 	public static String getDeletedDefaultValue () {
			 		return "false";
			 	}
			 




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.PayoutReason)) return false;
		else {
			com.floreantpos.model.PayoutReason payoutReason = (com.floreantpos.model.PayoutReason) obj;
			if (null == this.getId() || null == payoutReason.getId()) return this == obj;
			else return (this.getId().equals(payoutReason.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}