package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.Type;

import com.floreantpos.PosLog;
import com.floreantpos.model.BalanceSubType;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.BankAccount;
import com.floreantpos.model.COAAccountType;
import com.floreantpos.model.ChartOfAccounts;
import com.floreantpos.model.DirectionType;
import com.floreantpos.model.LedgerEntry;
import com.floreantpos.model.LedgerEntryType;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.PurchaseRefundTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.SalaryAdvanceBackTransaction;
import com.floreantpos.model.SalaryAdvanceTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.model.BalanceSheetLedgerEntryModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.NumberUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class LedgerEntryDAO extends BaseLedgerEntryDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public List<LedgerEntry> findByChartOfAcountName(Date fromDate, Date toDate, String accountId, String orderId, String refNo) {
		Pagination<LedgerEntry> pagination = new Pagination<>(0, -1);
		findByChartOfAcountName(pagination, true, fromDate, toDate, accountId, orderId, refNo);
		return pagination.getDataList();
	}

	public void findByChartOfAcountName(PaginationSupport paginationSupport, Date fromDate, Date toDate, String accountId, String orderId, String refNo) {
		findByChartOfAcountName(paginationSupport, false, fromDate, toDate, accountId, orderId, refNo);
	}

	private void findByChartOfAcountName(PaginationSupport paginationSupport, boolean ignorePagination, Date fromDate, Date toDate, String accountId,
			String orderId, String refNo) {
		try (Session session = createNewSession()) {

			Criteria criteria = session.createCriteria(LedgerEntry.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(orderId)) {
				criteria.add(Restrictions.eq(LedgerEntry.PROP_TICKET_ID, orderId));
			}
			else {

				if (fromDate != null) {
					criteria.add(Restrictions.ge(LedgerEntry.PROP_CREATE_DATE, fromDate));
				}
				if (toDate != null) {
					criteria.add(Restrictions.lt(LedgerEntry.PROP_CREATE_DATE, toDate));
				}

				if (StringUtils.isNotBlank(accountId)) {
					criteria.add(Restrictions.eq(LedgerEntry.PROP_ACCOUNT_ID, accountId));
				}

				if (StringUtils.isNotBlank(refNo)) {
					criteria.add(Restrictions.ilike(LedgerEntry.PROP_GROUP_ID, refNo, MatchMode.ANYWHERE));
				}
			}

			criteria.setProjection(Projections.rowCount());

			Number rowCount = (Number) criteria.uniqueResult();
			if (rowCount != null) {
				paginationSupport.setNumRows(rowCount.intValue());
			}
			criteria.setProjection(null);
			criteria.addOrder(Order.desc(LedgerEntry.PROP_CREATE_DATE));
			criteria.addOrder(Order.asc(LedgerEntry.PROP_SORT_ORDER));
			if (!ignorePagination) {
				criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
				criteria.setMaxResults(paginationSupport.getPageSize());
			}
			paginationSupport.setRows(criteria.list());
		}
	}

	//	public void saveTransactionLedgerEntry(Ticket ticket, PosTransaction transaction) {
	//		ChartOfAccountsDAO instance = ChartOfAccountsDAO.getInstance();
	//		try (Session session = instance.createNewSession()) {
	//			Transaction tx = session.beginTransaction();
	//
	//			ChartOfAccounts spendMethodCOA = getSpendMethodCOA(transaction.getPaymentType(), instance, session);
	//
	//			ChartOfAccounts receivableChartOfAccounts = instance.getCOAFromMap("5000", session);
	//			Date now = StoreDAO.getServerTimestamp();
	//			String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("TRANS");
	//			Double transAmount = transaction.isVoided() ? (-1) * transaction.getAmount() : transaction.getAmount();
	//			LedgerEntry createDebitLedgerEntry = LedgerEntry.createLedgerEntry(ticket, spendMethodCOA, DirectionType.DEBIT, transAmount,
	//					"TRANS/" + transaction.getId(), now);
	//			createDebitLedgerEntry.setTransactionId(transaction.getId());
	//			createDebitLedgerEntry.setGroupId(groupId);
	//			createDebitLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
	//			createDebitLedgerEntry.setSortOrder(1);
	//			LedgerEntryDAO.getInstance().save(createDebitLedgerEntry, session);
	//
	//			LedgerEntry createCreditLedgerEntry = LedgerEntry.createLedgerEntry(ticket, receivableChartOfAccounts, DirectionType.CREDIT, transAmount,
	//					"TRANS/" + transaction.getId(), now);
	//			createCreditLedgerEntry.setTransactionId(transaction.getId());
	//			createCreditLedgerEntry.setGroupId(groupId);
	//			createCreditLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
	//			createCreditLedgerEntry.setSortOrder(2);
	//			LedgerEntryDAO.getInstance().save(createCreditLedgerEntry, session);
	//
	//			tx.commit();
	//		} catch (Exception e) {
	//			PosLog.error(getClass(), e);
	//		}
	//	}

	public void savePurchaseOrderLedgerEntry(PurchaseOrder purchaseOrder) {
		savePurchaseOrderLedgerEntry(purchaseOrder, true, false);
	}

	public void savePurchaseOrderLedgerEntry(PurchaseOrder purchaseOrder, boolean isAdjustedInventroy, boolean isPurchaseOrderReturned) {
		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
			Transaction tx = session.beginTransaction();
			savePurchaseOrderLedgerEntry(purchaseOrder, session, isAdjustedInventroy, isPurchaseOrderReturned);
			tx.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	public void savePurchaseOrderLedgerEntry(PurchaseOrder purchaseOrder, Session session) {
		savePurchaseOrderLedgerEntry(purchaseOrder, session, true, false);
	}

	public void savePurchaseOrderLedgerEntry(PurchaseOrder purchaseOrder, Session session, boolean isAdjustedInventroy, boolean isPurchaseOrderReturned) {
		//		savePurchaseOrderLedgerEntry(purchaseOrder, session, false);
		//	}
		//
		//	public void savePurchaseOrderLedgerEntry(PurchaseOrder purchaseOrder, Session session, boolean isByzlogics) {
		//		if (isByzlogics) {
		savePurchaseOrderLedgerEntryForByz(purchaseOrder, session, isAdjustedInventroy, isPurchaseOrderReturned);
		//		return;
		//		}
		//		DataProvider dataProvider = DataProvider.get();
		//		ChartOfAccounts accountPayableCOA = dataProvider.getCOAFromMap("800", session);
		//		ChartOfAccounts inventoryCOA = dataProvider.getCOAFromMap("630", session);
		//		Double purchaseAmount = purchaseOrder.getTotalAmount();
		//		if (!NumberUtil.isZero(purchaseAmount)) {
		//			String purchaseGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("PURCHASE");
		//			String orderId = purchaseOrder.getOrderId();
		//			String entityId = purchaseOrder.getEntityId();
		//			Date now = StoreDAO.getServerTimestamp();
		//
		//			LedgerEntry createCRPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, accountPayableCOA, DirectionType.CREDIT, purchaseAmount,
		//					"PURCHASE/" + orderId, now);
		//			createCRPayableLedgerEntry.setGroupId(purchaseGroupId);
		//			createCRPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
		//			createCRPayableLedgerEntry.setSortOrder(1);
		//			createCRPayableLedgerEntry.setPurchaseOrderId(entityId);
		//			LedgerEntryDAO.getInstance().save(createCRPayableLedgerEntry, session);
		//
		//			if (!NumberUtil.isZero(purchaseAmount)) {
		//				LedgerEntry createInvLedgerEntry = LedgerEntry.createLedgerEntry(null, inventoryCOA, DirectionType.DEBIT, purchaseAmount, "PURCHASE/" + orderId,
		//						now);
		//				createInvLedgerEntry.setGroupId(purchaseGroupId);
		//				createInvLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
		//				createInvLedgerEntry.setSortOrder(2);
		//				createInvLedgerEntry.setPurchaseOrderId(entityId);
		//				LedgerEntryDAO.getInstance().save(createInvLedgerEntry, session);
		//			}
		//
		//			if (purchaseOrder.isFullPaid()) {
		//				purchaseOrder.setAccountProcessed(true);
		//				PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, session);
		//			}
		//		}
	}

	public void savePurchaseOrderLedgerEntryForByz(PurchaseOrder purchaseOrder, Session session, boolean isAdjustedInventroy, boolean isPurchaseOrderReturned) {
		DataProvider dataProvider = DataProvider.get();
		ChartOfAccounts accountPayableCOA = dataProvider.getCOAFromMap("2001", session);
		//		ChartOfAccounts purchaseCOA = dataProvider.getCOAFromMap("1005", session);
		ChartOfAccounts purchaseCOA = dataProvider.getCOAFromMap(purchaseOrder.getCOAId(), session);
		//		if (!isAdjustedInventroy && !purchaseOrder.hasFixedAssetItems()) {
		//			purchaseCOA = dataProvider.getCOAFromMap("5021", session);
		//		}

		ChartOfAccounts accountReceivableCOA = dataProvider.getCOAFromMap("1004", session);

		ChartOfAccounts advanceToSupplierCOA = dataProvider.getCOAFromMap("1007", session);
		double leAdvancedToSupplierAmount = getLedgerEntryAmountByOrderId(advanceToSupplierCOA.getId(), purchaseOrder.getId(), session);
		double leInventoryAmount = getLedgerEntryAmountByOrderId(purchaseCOA.getId(), purchaseOrder.getId(), session);
		double leAccountPayableAmount = getLedgerEntryAmountByOrderId(accountPayableCOA.getId(), purchaseOrder.getId(), session);

		double purchaseAmount = purchaseOrder.getTotalAmount();
		double purchaseItemReceivedAmount = 0;
		List<PurchaseOrderItem> orderItems = purchaseOrder.getOrderItems();
		for (PurchaseOrderItem purchaseOrderItem : orderItems) {
			purchaseItemReceivedAmount += purchaseOrderItem.getUnitCost() * purchaseOrderItem.getQuantityReceived();
		}
		double accountPayableAmount = 0;
		if (purchaseItemReceivedAmount > leAdvancedToSupplierAmount) {
			accountPayableAmount = purchaseItemReceivedAmount - (leAdvancedToSupplierAmount + leInventoryAmount);
		}
		purchaseItemReceivedAmount -= leInventoryAmount;

		String purchaseGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("PURCHASE");
		String orderId = purchaseOrder.getOrderId();
		String entityId = purchaseOrder.getEntityId();
		Date now = StoreDAO.getServerTimestamp();
		if (isPurchaseOrderReturned) {
			if (purchaseItemReceivedAmount > 0) {
				purchaseItemReceivedAmount = purchaseItemReceivedAmount * (-1);
			}
			if (!NumberUtil.isZero(purchaseItemReceivedAmount)) {
				LedgerEntry createReceivableLedgerEntry = LedgerEntry.createLedgerEntry(null, accountReceivableCOA, DirectionType.CREDIT,
						purchaseItemReceivedAmount, "PURCHASE/" + orderId, now);
				createReceivableLedgerEntry.setGroupId(purchaseGroupId);
				createReceivableLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
				createReceivableLedgerEntry.setSortOrder(1);
				createReceivableLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createReceivableLedgerEntry, session);
			}

			if (!NumberUtil.isZero(purchaseItemReceivedAmount)) {
				LedgerEntry createInvLedgerEntry = LedgerEntry.createLedgerEntry(null, purchaseCOA, DirectionType.DEBIT, purchaseItemReceivedAmount,
						"PURCHASE/" + orderId, now);
				createInvLedgerEntry.setGroupId(purchaseGroupId);
				createInvLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
				createInvLedgerEntry.setSortOrder(2);
				createInvLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createInvLedgerEntry, session);
			}

			if (purchaseOrder.isFullPaid()) {
				purchaseOrder.setAccountProcessed(true);
				PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, session);
			}

		}
		else if (!NumberUtil.isZero(purchaseAmount)) {
			//			String purchaseGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("PURCHASE");
			//			String orderId = purchaseOrder.getOrderId();
			//			String entityId = purchaseOrder.getEntityId();
			//			Date now = StoreDAO.getServerTimestamp();

			if (NumberUtil.isZero(leAdvancedToSupplierAmount)) {
				accountPayableAmount = purchaseItemReceivedAmount;
			}

			if (!NumberUtil.isZero(purchaseItemReceivedAmount)) {
				LedgerEntry createInvLedgerEntry = LedgerEntry.createLedgerEntry(null, purchaseCOA, DirectionType.DEBIT, purchaseItemReceivedAmount,
						"PURCHASE/" + orderId, now);
				createInvLedgerEntry.setGroupId(purchaseGroupId);
				createInvLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
				createInvLedgerEntry.setSortOrder(1);
				createInvLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createInvLedgerEntry, session);
			}
			leAdvancedToSupplierAmount = purchaseItemReceivedAmount - accountPayableAmount;
			if (!NumberUtil.isZero(leAdvancedToSupplierAmount)) {
				LedgerEntry createAdvancedToSupplierLedgerEntry = LedgerEntry.createLedgerEntry(null, advanceToSupplierCOA, DirectionType.CREDIT,
						leAdvancedToSupplierAmount, "PURCHASE/" + orderId, now);
				createAdvancedToSupplierLedgerEntry.setGroupId(purchaseGroupId);
				createAdvancedToSupplierLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
				createAdvancedToSupplierLedgerEntry.setSortOrder(2);
				createAdvancedToSupplierLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createAdvancedToSupplierLedgerEntry, session);
			}
			if (!NumberUtil.isZero(accountPayableAmount)) {
				LedgerEntry createCRPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, accountPayableCOA, DirectionType.CREDIT, accountPayableAmount,
						"PURCHASE/" + orderId, now);
				createCRPayableLedgerEntry.setGroupId(purchaseGroupId);
				createCRPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
				createCRPayableLedgerEntry.setSortOrder(2);
				createCRPayableLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createCRPayableLedgerEntry, session);
			}

			if (purchaseOrder.isFullPaid()
					&& (purchaseOrder.getStatus() == PurchaseOrder.ORDER_FULLY_RECEIVED || purchaseOrder.getStatus() == PurchaseOrder.ORDER_CLOSED)) {
				purchaseOrder.setAccountProcessed(true);
				PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, session);
			}
		}
	}

	public void saveServiceOrderLedgerEntry(PurchaseOrder serviceOrder, boolean isServiceOrderReturned) {
		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
			Transaction tx = session.beginTransaction();
			saveServiceOrderLedgerEntry(serviceOrder, session, isServiceOrderReturned);
			tx.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	public void saveServiceOrderLedgerEntry(PurchaseOrder serviceOrder, Session session, boolean isServiceOrderReturned) {
		DataProvider dataProvider = DataProvider.get();
		ChartOfAccounts accountPayableCOA = dataProvider.getCOAFromMap("2001", session);
		ChartOfAccounts serviceCOA = dataProvider.getCOAFromMap("5022", session, true);

		ChartOfAccounts accountReceivableCOA = dataProvider.getCOAFromMap("1004", session);

		ChartOfAccounts advanceToSupplierCOA = dataProvider.getCOAFromMap("1007", session);
		double leAdvancedToSupplierAmount = getLedgerEntryAmountByOrderId(advanceToSupplierCOA.getId(), serviceOrder.getId(), session, true);
		double leInventoryAmount = getLedgerEntryAmountByOrderId(serviceCOA.getId(), serviceOrder.getId(), session, true);
		double leAccountPayableAmount = getLedgerEntryAmountByOrderId(accountPayableCOA.getId(), serviceOrder.getId(), session, true);

		double purchaseAmount = serviceOrder.getTotalAmount();
		double purchaseItemReceivedAmount = 0;
		List<PurchaseOrderItem> orderItems = serviceOrder.getOrderItems();
		for (PurchaseOrderItem purchaseOrderItem : orderItems) {
			purchaseItemReceivedAmount += purchaseOrderItem.getUnitCost() * purchaseOrderItem.getQuantityReceived();
		}
		double accountPayableAmount = 0;
		if (purchaseItemReceivedAmount > leAdvancedToSupplierAmount) {
			accountPayableAmount = purchaseItemReceivedAmount - (leAdvancedToSupplierAmount + leInventoryAmount);
		}
		purchaseItemReceivedAmount -= leInventoryAmount;

		String purchaseGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("SERVICE_ORDER");
		String orderId = serviceOrder.getOrderId();
		String entityId = serviceOrder.getEntityId();
		Date now = StoreDAO.getServerTimestamp();
		if (isServiceOrderReturned) {
			if (purchaseItemReceivedAmount > 0) {
				purchaseItemReceivedAmount = purchaseItemReceivedAmount * (-1);
			}
			if (!NumberUtil.isZero(purchaseItemReceivedAmount)) {
				LedgerEntry createReceivableLedgerEntry = LedgerEntry.createLedgerEntry(null, accountReceivableCOA, DirectionType.CREDIT,
						purchaseItemReceivedAmount, "SERVICE_ORDER/" + orderId, now);
				createReceivableLedgerEntry.setGroupId(purchaseGroupId);
				createReceivableLedgerEntry.setLedgerEntryType(LedgerEntryType.SERVICE_ORDER.name());
				createReceivableLedgerEntry.setSortOrder(1);
				createReceivableLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createReceivableLedgerEntry, session);
			}

			if (!NumberUtil.isZero(purchaseItemReceivedAmount)) {
				LedgerEntry createInvLedgerEntry = LedgerEntry.createLedgerEntry(null, serviceCOA, DirectionType.DEBIT, purchaseItemReceivedAmount,
						"SERVICE_ORDER/" + orderId, now);
				createInvLedgerEntry.setGroupId(purchaseGroupId);
				createInvLedgerEntry.setLedgerEntryType(LedgerEntryType.SERVICE_ORDER.name());
				createInvLedgerEntry.setSortOrder(2);
				createInvLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createInvLedgerEntry, session);
			}

			if (serviceOrder.isFullPaid()) {
				serviceOrder.setAccountProcessed(true);
				PurchaseOrderDAO.getInstance().saveOrUpdate(serviceOrder, session);
			}

		}
		else if (!NumberUtil.isZero(purchaseAmount)) {
			//			String purchaseGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("PURCHASE");
			//			String orderId = purchaseOrder.getOrderId();
			//			String entityId = purchaseOrder.getEntityId();
			//			Date now = StoreDAO.getServerTimestamp();

			if (NumberUtil.isZero(leAdvancedToSupplierAmount)) {
				accountPayableAmount = purchaseItemReceivedAmount;
			}

			if (!NumberUtil.isZero(purchaseItemReceivedAmount)) {
				LedgerEntry createInvLedgerEntry = LedgerEntry.createLedgerEntry(null, serviceCOA, DirectionType.DEBIT, purchaseItemReceivedAmount,
						"SERVICE_ORDER/" + orderId, now);
				createInvLedgerEntry.setGroupId(purchaseGroupId);
				createInvLedgerEntry.setLedgerEntryType(LedgerEntryType.SERVICE_ORDER.name());
				createInvLedgerEntry.setSortOrder(1);
				createInvLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createInvLedgerEntry, session);
			}
			leAdvancedToSupplierAmount = purchaseItemReceivedAmount - accountPayableAmount;
			if (!NumberUtil.isZero(leAdvancedToSupplierAmount)) {
				LedgerEntry createAdvancedToSupplierLedgerEntry = LedgerEntry.createLedgerEntry(null, advanceToSupplierCOA, DirectionType.CREDIT,
						leAdvancedToSupplierAmount, "SERVICE_ORDER/" + orderId, now);
				createAdvancedToSupplierLedgerEntry.setGroupId(purchaseGroupId);
				createAdvancedToSupplierLedgerEntry.setLedgerEntryType(LedgerEntryType.SERVICE_ORDER.name());
				createAdvancedToSupplierLedgerEntry.setSortOrder(2);
				createAdvancedToSupplierLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createAdvancedToSupplierLedgerEntry, session);
			}
			if (!NumberUtil.isZero(accountPayableAmount)) {
				LedgerEntry createCRPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, accountPayableCOA, DirectionType.CREDIT, accountPayableAmount,
						"SERVICE_ORDER/" + orderId, now);
				createCRPayableLedgerEntry.setGroupId(purchaseGroupId);
				createCRPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.SERVICE_ORDER.name());
				createCRPayableLedgerEntry.setSortOrder(2);
				createCRPayableLedgerEntry.setPurchaseOrderId(entityId);
				LedgerEntryDAO.getInstance().save(createCRPayableLedgerEntry, session);
			}

			if (serviceOrder.isFullPaid() && (serviceOrder.getStatus() == PurchaseOrder.ORDER_CLOSED)) {
				serviceOrder.setAccountProcessed(true);
				PurchaseOrderDAO.getInstance().saveOrUpdate(serviceOrder, session);
			}
		}
	}

	public void savePurchaseBillLedgerEntry(PurchaseOrder purchaseOrder, PosTransaction transaction) {
		savePurchaseBillLedgerEntryForByz(purchaseOrder, transaction);

		//		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
		//			Transaction tx = session.beginTransaction();
		//
		//			ChartOfAccounts accountPayableCOA = DataProvider.get().getCOAFromMap("800", session);
		//			ChartOfAccounts spendMethodCOA = getSpendMethodCOA(transaction.getPaymentType(), DataProvider.get(), session);
		//
		//			String entityId = purchaseOrder.getEntityId();
		//			String orderId = purchaseOrder.getOrderId();
		//			String transactionId = transaction.getId();
		//			Date now = StoreDAO.getServerTimestamp();
		//			Double transAmount = transaction.getAmount();
		//			if (!NumberUtil.isZero(transAmount)) {
		//				String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("PURCHASE_BILL");
		//				LedgerEntry createDBTPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, accountPayableCOA, DirectionType.DEBIT, transAmount,
		//						"PURCHASE_BILL/" + orderId, now);
		//				createDBTPayableLedgerEntry.setGroupId(groupId);
		//				createDBTPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
		//				createDBTPayableLedgerEntry.setSortOrder(1);
		//				createDBTPayableLedgerEntry.setPurchaseOrderId(entityId);
		//				createDBTPayableLedgerEntry.setTransactionId(transactionId);
		//				LedgerEntryDAO.getInstance().save(createDBTPayableLedgerEntry, session);
		//
		//				LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.CREDIT, transAmount,
		//						"PURCHASE_BILL/" + orderId, now);
		//				createCashLedgerEntry.setGroupId(groupId);
		//				createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.PURCHASE.name());
		//				createCashLedgerEntry.setSortOrder(2);
		//				createCashLedgerEntry.setPurchaseOrderId(entityId);
		//				createCashLedgerEntry.setTransactionId(transactionId);
		//				LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);
		//
		//			}
		//
		//			tx.commit();
		//		} catch (Exception e) {
		//			PosLog.error(getClass(), e);
		//		}
	}

	public void savePurchaseBillLedgerEntryForByz(PurchaseOrder purchaseOrder, PosTransaction transaction) {

		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
			Transaction tx = session.beginTransaction();

			DataProvider dataProvider = DataProvider.get();
			ChartOfAccounts accountPayableCOA = dataProvider.getCOAFromMap("2001", session);
			double leAccountPayableAmount = getLedgerEntryAmountByOrderId(accountPayableCOA.getId(), purchaseOrder.getId(), session);
			ChartOfAccounts advanceToSupplierCOA = null;
			Double advanceAmount = purchaseOrder.getTotalAmount() + leAccountPayableAmount;
			if (NumberUtil.isZero(leAccountPayableAmount) || !NumberUtil.isZero(leAccountPayableAmount)
					&& !NumberUtil.isZero(advanceAmount) /*!(purchaseOrder.getStatus() == PurchaseOrder.ORDER_FULLY_RECEIVED)*/) {
				advanceToSupplierCOA = dataProvider.getCOAFromMap("1007", session);
			}
			ChartOfAccounts receivableCOA = dataProvider.getCOAFromMap("1004", session);
			//			double leReceivedAmount = getLedgerEntryAmountByPurchaseOrderId(receivableCOA.getId(), purchaseOrder.getId(), session);

			ChartOfAccounts spendMethodCOA = getSpendMethodCOAForByz(transaction, dataProvider, session);

			String entityId = purchaseOrder.getEntityId();
			String orderId = purchaseOrder.getOrderId();
			String transactionId = transaction.getId();
			Date now = StoreDAO.getServerTimestamp();
			Double transAmount = transaction.getAmount();

			String refText = "PURCHASE_BILL";
			String entryType = LedgerEntryType.PURCHASE.name();

			if (!NumberUtil.isZero(transAmount)) {
				if (transaction instanceof PurchaseRefundTransaction) {
					String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("PURCHASE_REFUND_BILL");
					LedgerEntry createPaymentLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.DEBIT, transAmount,
							"PURCHASE_REFUND_BILL/" + orderId, now);
					createPaymentLedgerEntry.setGroupId(groupId);
					createPaymentLedgerEntry.setLedgerEntryType(entryType);
					createPaymentLedgerEntry.setSortOrder(1);
					createPaymentLedgerEntry.setPurchaseOrderId(entityId);
					createPaymentLedgerEntry.setTransactionId(transactionId);
					LedgerEntryDAO.getInstance().save(createPaymentLedgerEntry, session);

					LedgerEntry createReceivableLedgerEntry = LedgerEntry.createLedgerEntry(null, receivableCOA, DirectionType.CREDIT, transAmount,
							"PURCHASE_REFUND_BILL/" + transactionId, now);
					createReceivableLedgerEntry.setGroupId(groupId);
					createReceivableLedgerEntry.setLedgerEntryType(entryType);
					createReceivableLedgerEntry.setSortOrder(2);
					createReceivableLedgerEntry.setPurchaseOrderId(entityId);
					createReceivableLedgerEntry.setTransactionId(transactionId);
					LedgerEntryDAO.getInstance().save(createReceivableLedgerEntry, session);

					if (purchaseOrder.isFullPaid()) {
						purchaseOrder.setAccountProcessed(true);
						PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, session);
					}

				}
				else {
					String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef(refText);
					double advanceToSupplierAmount = transAmount + leAccountPayableAmount;
					if (advanceToSupplierCOA != null && !NumberUtil.isZero(advanceToSupplierAmount) && transAmount > Math.abs(leAccountPayableAmount)) {
						LedgerEntry createDBTAdvancedSupplierLedgerEntry = LedgerEntry.createLedgerEntry(null, advanceToSupplierCOA, DirectionType.DEBIT,
								advanceToSupplierAmount, refText + "/" + orderId, now);
						createDBTAdvancedSupplierLedgerEntry.setGroupId(groupId);
						createDBTAdvancedSupplierLedgerEntry.setLedgerEntryType(entryType);
						createDBTAdvancedSupplierLedgerEntry.setSortOrder(1);
						createDBTAdvancedSupplierLedgerEntry.setPurchaseOrderId(entityId);
						createDBTAdvancedSupplierLedgerEntry.setTransactionId(transactionId);
						LedgerEntryDAO.getInstance().save(createDBTAdvancedSupplierLedgerEntry, session);
					}
					if (!NumberUtil.isZero(leAccountPayableAmount)) {
						double accountPayable = 0;
						if (Math.abs(leAccountPayableAmount) > transAmount) {
							accountPayable = transAmount;
						}
						else {
							accountPayable = Math.abs(leAccountPayableAmount);
						}
						LedgerEntry createDBTPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, accountPayableCOA, DirectionType.DEBIT, accountPayable,
								refText + "/" + orderId, now);
						createDBTPayableLedgerEntry.setGroupId(groupId);
						createDBTPayableLedgerEntry.setLedgerEntryType(entryType);
						createDBTPayableLedgerEntry.setSortOrder(1);
						createDBTPayableLedgerEntry.setPurchaseOrderId(entityId);
						createDBTPayableLedgerEntry.setTransactionId(transactionId);
						LedgerEntryDAO.getInstance().save(createDBTPayableLedgerEntry, session);
					}

					LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.CREDIT, transAmount,
							refText + "/" + orderId, now);
					createCashLedgerEntry.setGroupId(groupId);
					createCashLedgerEntry.setLedgerEntryType(entryType);
					createCashLedgerEntry.setSortOrder(2);
					createCashLedgerEntry.setPurchaseOrderId(entityId);
					createCashLedgerEntry.setTransactionId(transactionId);
					LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);

					if (purchaseOrder.isFullPaid()
							&& (purchaseOrder.getStatus() == PurchaseOrder.ORDER_FULLY_RECEIVED || purchaseOrder.getStatus() == PurchaseOrder.ORDER_CLOSED)) {
						purchaseOrder.setAccountProcessed(true);
						PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, session);
					}
				}

			}

			tx.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	public void saveServiceOrderBillLedgerEntry(PurchaseOrder purchaseOrder, PosTransaction transaction) {

		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
			Transaction tx = session.beginTransaction();

			DataProvider dataProvider = DataProvider.get();
			ChartOfAccounts accountPayableCOA = dataProvider.getCOAFromMap("2001", session);
			double leAccountPayableAmount = getLedgerEntryAmountByOrderId(accountPayableCOA.getId(), purchaseOrder.getId(), session, true);
			ChartOfAccounts advanceToSupplierCOA = null;
			Double advanceAmount = purchaseOrder.getTotalAmount() + leAccountPayableAmount;
			if (NumberUtil.isZero(leAccountPayableAmount) || !NumberUtil.isZero(leAccountPayableAmount)
					&& !NumberUtil.isZero(advanceAmount) /*!(purchaseOrder.getStatus() == PurchaseOrder.ORDER_FULLY_RECEIVED)*/) {
				advanceToSupplierCOA = dataProvider.getCOAFromMap("1007", session);
			}
			ChartOfAccounts receivableCOA = dataProvider.getCOAFromMap("1004", session);
			//			double leReceivedAmount = getLedgerEntryAmountByPurchaseOrderId(receivableCOA.getId(), purchaseOrder.getId(), session);

			ChartOfAccounts spendMethodCOA = getSpendMethodCOAForByz(transaction, dataProvider, session);

			String entityId = purchaseOrder.getEntityId();
			String orderId = purchaseOrder.getOrderId();
			String transactionId = transaction.getId();
			Date now = StoreDAO.getServerTimestamp();
			Double transAmount = transaction.getAmount();

			String refText = "SERVICE_ORDER_BILL";
			String entryType = LedgerEntryType.SERVICE_ORDER.name();

			if (!NumberUtil.isZero(transAmount)) {
				if (transaction instanceof PurchaseRefundTransaction) {
					String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("SERVICE_REFUND_BILL");
					LedgerEntry createPaymentLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.DEBIT, transAmount,
							"SERVICE_REFUND_BILL/" + orderId, now);
					createPaymentLedgerEntry.setGroupId(groupId);
					createPaymentLedgerEntry.setLedgerEntryType(entryType);
					createPaymentLedgerEntry.setSortOrder(1);
					createPaymentLedgerEntry.setPurchaseOrderId(entityId);
					createPaymentLedgerEntry.setTransactionId(transactionId);
					LedgerEntryDAO.getInstance().save(createPaymentLedgerEntry, session);

					LedgerEntry createReceivableLedgerEntry = LedgerEntry.createLedgerEntry(null, receivableCOA, DirectionType.CREDIT, transAmount,
							"SERVICE_REFUND_BILL/" + transactionId, now);
					createReceivableLedgerEntry.setGroupId(groupId);
					createReceivableLedgerEntry.setLedgerEntryType(entryType);
					createReceivableLedgerEntry.setSortOrder(2);
					createReceivableLedgerEntry.setPurchaseOrderId(entityId);
					createReceivableLedgerEntry.setTransactionId(transactionId);
					LedgerEntryDAO.getInstance().save(createReceivableLedgerEntry, session);

					if (purchaseOrder.isFullPaid()) {
						purchaseOrder.setAccountProcessed(true);
						PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, session);
					}

				}
				else {
					String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef(refText);
					double advanceToSupplierAmount = transAmount + leAccountPayableAmount;
					if (advanceToSupplierCOA != null && !NumberUtil.isZero(advanceToSupplierAmount) && transAmount > Math.abs(leAccountPayableAmount)) {
						LedgerEntry createDBTAdvancedSupplierLedgerEntry = LedgerEntry.createLedgerEntry(null, advanceToSupplierCOA, DirectionType.DEBIT,
								advanceToSupplierAmount, refText + "/" + orderId, now);
						createDBTAdvancedSupplierLedgerEntry.setGroupId(groupId);
						createDBTAdvancedSupplierLedgerEntry.setLedgerEntryType(entryType);
						createDBTAdvancedSupplierLedgerEntry.setSortOrder(1);
						createDBTAdvancedSupplierLedgerEntry.setPurchaseOrderId(entityId);
						createDBTAdvancedSupplierLedgerEntry.setTransactionId(transactionId);
						LedgerEntryDAO.getInstance().save(createDBTAdvancedSupplierLedgerEntry, session);
					}
					if (!NumberUtil.isZero(leAccountPayableAmount)) {
						double accountPayable = 0;
						if (Math.abs(leAccountPayableAmount) > transAmount) {
							accountPayable = transAmount;
						}
						else {
							accountPayable = Math.abs(leAccountPayableAmount);
						}
						LedgerEntry createDBTPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, accountPayableCOA, DirectionType.DEBIT, accountPayable,
								refText + "/" + orderId, now);
						createDBTPayableLedgerEntry.setGroupId(groupId);
						createDBTPayableLedgerEntry.setLedgerEntryType(entryType);
						createDBTPayableLedgerEntry.setSortOrder(1);
						createDBTPayableLedgerEntry.setPurchaseOrderId(entityId);
						createDBTPayableLedgerEntry.setTransactionId(transactionId);
						LedgerEntryDAO.getInstance().save(createDBTPayableLedgerEntry, session);
					}

					LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.CREDIT, transAmount,
							refText + "/" + orderId, now);
					createCashLedgerEntry.setGroupId(groupId);
					createCashLedgerEntry.setLedgerEntryType(entryType);
					createCashLedgerEntry.setSortOrder(2);
					createCashLedgerEntry.setPurchaseOrderId(entityId);
					createCashLedgerEntry.setTransactionId(transactionId);
					LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);

					if (purchaseOrder.isFullPaid()
							&& (purchaseOrder.getStatus() == PurchaseOrder.ORDER_FULLY_RECEIVED || purchaseOrder.getStatus() == PurchaseOrder.ORDER_CLOSED)) {
						purchaseOrder.setAccountProcessed(true);
						PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder, session);
					}
				}

			}

			tx.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	public void saveOrderLedgerEntry(Ticket ticket, Session session) {
		saveOrderLedgerEntry(ticket, null, session);
	}

	public void saveOrderLedgerEntry(Ticket ticket, PosTransaction transaction, Session session) {
		saveOrderLedgerEntry(ticket, transaction, session, null);
	}

	public void saveOrderLedgerEntry(Ticket ticket, PosTransaction transaction, Session session, Date selectedDate) {

		saveOrderLedgerEntryForByz(ticket, transaction, session, selectedDate);

		//		boolean isRecalculateTicket = selectedDate != null;
		//		boolean isLDFAndRFApplicable = TicketType.OUTDOOR != ticket.getTicketType();
		//		double maxRFFee = isLDFAndRFApplicable ? ticket.getReferrerFeeOnNetSales() : 0;
		//		double totalCost = 0;
		//		List<TicketItem> ticketItems = ticket.getTicketItems();
		//		if (ticketItems != null) {
		//			for (TicketItem ticketItem : ticketItems) {
		//				if (isRecalculateTicket) {
		//					if (isLDFAndRFApplicable) {
		//						maxRFFee += ticketItem.getReferrerFeeOnReport();
		//					}
		//
		//					if (ticketItem.isVoided()) {
		//						continue;
		//					}
		//
		//					if (ticketItem.isReturned()) {
		//						totalCost -= ticketItem.getUnitCost();
		//					}
		//					else {
		//						totalCost += ticketItem.getUnitCost();
		//					}
		//				}
		//				else {
		//					if (isLDFAndRFApplicable) {
		//						maxRFFee += ticketItem.getReferrerFeeOnReport();
		//					}
		//					if (ticketItem.isVoided() || ticketItem.isReturned() || ticketItem.isReturnedSource()) {
		//						continue;
		//					}
		//					totalCost += ticketItem.getUnitCost();
		//				}
		//			}
		//		}
		//
		//		DataProvider dataProvider = DataProvider.get();
		//		//		try (Session session = instance.createNewSession()) {
		//		//			Transaction tx = session.beginTransaction();
		//
		//		ChartOfAccounts productsSalesCOA = dataProvider.getCOAFromMap("200", session);
		//		ChartOfAccounts taxCOA = dataProvider.getCOAFromMap("831", session);
		//		ChartOfAccounts rfPayableCOA = dataProvider.getCOAFromMap("832", session);
		//		ChartOfAccounts ldfPayableCOA = dataProvider.getCOAFromMap("833", session, false);
		//		//			ChartOfAccounts taxCOA = instance.findByAcountCode("506", session);
		//		//			ChartOfAccounts rfPayableCOA = instance.findByAcountCode("507", session);
		//		//			ChartOfAccounts ldfPayableCOA = instance.findByAcountCode("508", session);
		//		ChartOfAccounts receivableCOA = dataProvider.getCOAFromMap("5000", session);
		//		//ChartOfAccounts ownerADrawings = instance.findByAcountCode("880", session);
		//
		//		String ticketId = ticket.getId();
		//		double leProductSalesAmount = getLedgerEntryAmount(productsSalesCOA.getId(), ticketId);
		//		double leTaxAmount = getLedgerEntryAmount(taxCOA.getId(), ticketId);
		//		double leRFAmount = 0;
		//		double leLDFAmount = 0;
		//
		//		if (isLDFAndRFApplicable) {
		//			if (ldfPayableCOA != null) {
		//				leLDFAmount = getLedgerEntryAmount(ldfPayableCOA.getId(), ticketId);
		//			}
		//			if (rfPayableCOA != null) {
		//				leRFAmount = getLedgerEntryAmount(rfPayableCOA.getId(), ticketId);
		//			}
		//
		//		}
		//
		//		Date now = StoreDAO.getServerTimestamp();
		//		int sortOrder = 0;
		//		double previousProcessAmount = leProductSalesAmount + leTaxAmount + leRFAmount + leLDFAmount;
		//		double remainLedgerAmount = ticket.getTotalAmount() + previousProcessAmount;
		//		//Need to update adj ledger entry time 
		//		if (isRecalculateTicket) {
		//			now = selectedDate;
		//		}
		//		double maxTaxAmount = ticket.getTaxAmount();
		//		double maxLabDoctorFee = isLDFAndRFApplicable ? ticket.getLabDoctorFee() : 0d;
		//		double otherAmount = maxTaxAmount + maxRFFee + maxLabDoctorFee;
		//		double maxSalesAmount = ticket.getTotalAmount() - otherAmount;
		//		//remainLedgerAmount = remainLedgerAmount - otherAmount;
		//		//double maxSalesAmount = ticket.getTotalAmount();
		//		double remainProductSalesAmount = maxSalesAmount + leProductSalesAmount;
		//		double remainTaxAmount = maxTaxAmount + leTaxAmount;
		//		double remainRFAmount = maxRFFee + leRFAmount;
		//		double remainLDFAmount = maxLabDoctorFee + leLDFAmount;
		//
		//		String orderGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("ORDER");
		//
		//		if (!NumberUtil.isZero(remainProductSalesAmount)) {
		//			LedgerEntry createPSLedgerEntry = LedgerEntry.createLedgerEntry(ticket, productsSalesCOA, DirectionType.CREDIT, remainProductSalesAmount,
		//					"ORDER/" + ticket.getId(), now);
		//			createPSLedgerEntry.setGroupId(orderGroupId);
		//			createPSLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//			createPSLedgerEntry.setSortOrder(++sortOrder);
		//			save(createPSLedgerEntry);
		//		}
		//
		//		if (!NumberUtil.isZero(remainTaxAmount)) {
		//			LedgerEntry createTaxLedgerEntry = LedgerEntry.createLedgerEntry(ticket, taxCOA, DirectionType.CREDIT, remainTaxAmount, "ORDER/" + ticket.getId(),
		//					now);
		//			createTaxLedgerEntry.setGroupId(orderGroupId);
		//			createTaxLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//			createTaxLedgerEntry.setSortOrder(++sortOrder);
		//			save(createTaxLedgerEntry);
		//		}
		//
		//		if (!NumberUtil.isZero(remainRFAmount)) {
		//			LedgerEntry createRFLedgerEntry = LedgerEntry.createLedgerEntry(ticket, rfPayableCOA, DirectionType.CREDIT, remainRFAmount,
		//					"ORDER/" + ticket.getId(), now);
		//			createRFLedgerEntry.setGroupId(orderGroupId);
		//			createRFLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//			createRFLedgerEntry.setSortOrder(++sortOrder);
		//			save(createRFLedgerEntry);
		//		}
		//
		//		if (!NumberUtil.isZero(remainLDFAmount)) {
		//			LedgerEntry createLDFLedgerEntry = LedgerEntry.createLedgerEntry(ticket, ldfPayableCOA, DirectionType.CREDIT, remainLDFAmount,
		//					"ORDER/" + ticket.getId(), now);
		//			createLDFLedgerEntry.setGroupId(orderGroupId);
		//			createLDFLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//			createLDFLedgerEntry.setSortOrder(++sortOrder);
		//			save(createLDFLedgerEntry);
		//		}
		//
		//		if (!NumberUtil.isZero(remainLedgerAmount)) {
		//			LedgerEntry createDebitLedgerEntry = LedgerEntry.createLedgerEntry(ticket, receivableCOA, DirectionType.DEBIT, remainLedgerAmount,
		//					"ORDER/" + ticket.getId(), now);
		//			createDebitLedgerEntry.setGroupId(orderGroupId);
		//			createDebitLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//			createDebitLedgerEntry.setSortOrder(++sortOrder);
		//			save(createDebitLedgerEntry);
		//		}
		//
		//		saveInventoryAdjLedgerEntry(dataProvider, session, orderGroupId, sortOrder, now, ticket, totalCost);
		//		sortOrder = sortOrder + 2;
		//		//}
		//
		//		if (ticket.isPaid()) {
		//			ticket.setAccountProcessed(true);
		//		}
		//
		//		if (transaction != null) {
		//			ChartOfAccounts spendMethodCOA = getSpendMethodCOA(transaction.getPaymentType(), dataProvider, session);
		//
		//			Double transAmount = transaction.getAmount();
		//			if (transaction instanceof RefundTransaction || transaction.isVoided()) {
		//				transAmount = (-1) * transAmount;
		//			}
		//			if (!NumberUtil.isZero(transAmount)) {
		//				String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("TRANS");
		//
		//				LedgerEntry createReceivableTransLedgerEntry = LedgerEntry.createLedgerEntry(ticket, receivableCOA, DirectionType.CREDIT, transAmount,
		//						"TRANS/" + transaction.getId(), now);
		//				createReceivableTransLedgerEntry.setTransactionId(transaction.getId());
		//				createReceivableTransLedgerEntry.setGroupId(groupId);
		//				createReceivableTransLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//				createReceivableTransLedgerEntry.setSortOrder(++sortOrder);
		//				createReceivableTransLedgerEntry.setCashDrawerId(transaction.getCashDrawerId());
		//				save(createReceivableTransLedgerEntry);
		//
		//				LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(ticket, spendMethodCOA, DirectionType.DEBIT, transAmount,
		//						"TRANS/" + transaction.getId(), now);
		//				createCashLedgerEntry.setTransactionId(transaction.getId());
		//				createCashLedgerEntry.setGroupId(groupId);
		//				createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//				createCashLedgerEntry.setSortOrder(++sortOrder);
		//				createCashLedgerEntry.setCashDrawerId(transaction.getCashDrawerId());
		//				save(createCashLedgerEntry);
		//			}
		//
		//			Set<PosTransaction> transactions = ticket.getTransactions();
		//			for (PosTransaction posTransaction : transactions) {
		//				if (posTransaction.getId().equals(transaction.getId())) {
		//					posTransaction.setAccountProcessed(true);
		//				}
		//			}
		//		}
		//
		//		if (!isRecalculateTicket) {
		//			TicketDAO.getInstance().saveOrUpdate(ticket, session);
		//		}

		//			tx.commit();
		//		} catch (Exception e) {
		//			PosLog.error(getClass(), e);
		//		}
	}

	public void saveOrderLedgerEntryForByz(Ticket ticket) {
		try (Session session = instance.createNewSession()) {
			Transaction tx = session.beginTransaction();
			saveOrderLedgerEntryForByz(ticket, null, session, null);
			tx.commit();
		}
	}

	public void saveOrderLedgerEntryForByz(Ticket ticket, PosTransaction transaction, Session session, Date selectedDate) {
		boolean isRecalculateTicket = selectedDate != null;
		DataProvider dataProvider = DataProvider.get();
		double maxRFFee = ticket.getReferrerFeeOnNetSales();
		double totalCost = 0;
		double unEarnedItemPrice = 0;
		double unEarnedItemTax = 0;
		double unEarnedItemDiscount = 0;
		double itemWastedAmount = 0;
		double ticketItemPrice = 0;
		double ticketItemTotalTaxAmount = 0;
		double ticketItemTotalDiscountAmount = 0;
		double leUnearnDebitAmount = 0;
		List<TicketItem> ticketItems = ticket.getTicketItems();
		ChartOfAccounts unEarnedCOA = dataProvider.getCOAFromMap("2002", session);
		if (ticketItems != null) {
			for (TicketItem ticketItem : ticketItems) {
				if ((ticketItem.isRequiredShipping() && !ticketItem.isInventoryAdjusted())
						|| (ticketItem.isRequiredShipping() && transaction != null && transaction instanceof RefundTransaction)) {
					unEarnedItemTax += ticketItem.getAdjustedTax();
					unEarnedItemDiscount += ticketItem.getAdjustedDiscount();

					unEarnedItemPrice += ticketItem.getUnitPrice() * ticketItem.getQuantity();
					leUnearnDebitAmount += getLedgerEntryAmountForDebit(unEarnedCOA.getId(), ticket.getId());
					continue;
				}
				maxRFFee += ticketItem.getReferrerFeeOnReport();
				ticketItemTotalTaxAmount += ticketItem.getAdjustedTax();
				ticketItemPrice += ticketItem.getUnitPrice() * ticketItem.getQuantity();
				ticketItemTotalDiscountAmount += ticketItem.getAdjustedDiscount();
				if (!ticketItem.isInventoryItem()) {
					continue;
				}
				totalCost += ticketItem.getTotalCost();
				if (ticketItem.isVoided()) {
					continue;
				}

				if (ticketItem.isItemWasted()) {
					itemWastedAmount += ticketItem.getUnitCost() * ticketItem.getQuantity();
				}
			}
		}

		ChartOfAccounts productsSalesCOA = dataProvider.getCOAFromMap("4001", session);
		ChartOfAccounts taxCOA = dataProvider.getCOAFromMap("2005", session);
		ChartOfAccounts ldfPayableCOA = dataProvider.getCOAFromMap("833", session, false);
		ChartOfAccounts receivableCOA = dataProvider.getCOAFromMap("1004", session);
		ChartOfAccounts payableCOA = dataProvider.getCOAFromMap("2001", session);
		ChartOfAccounts discountCOA = dataProvider.getCOAFromMap("5016", session);
		ChartOfAccounts productsReturnCOA = dataProvider.getCOAFromMap("6001", session);

		String ticketId = ticket.getId();
		double leProductSalesAmount = getLedgerEntryAmount(productsSalesCOA.getId(), ticketId);
		double leProductReturnAmount = getLedgerEntryAmount(productsReturnCOA.getId(), ticketId);
		double leTaxAmount = getLedgerEntryAmount(taxCOA.getId(), ticketId);
		double leDiscountAmount = getLedgerEntryAmount(discountCOA.getId(), ticketId);
		double leReceivableAmount = getLedgerEntryAmount(receivableCOA.getId(), ticketId);
		double lePayableAmount = getLedgerEntryAmount(payableCOA.getId(), ticketId);
		double leUnEarnedRevenueAmount = getLedgerEntryAmount(unEarnedCOA.getId(), ticketId);

		Date now = StoreDAO.getServerTimestamp();
		int sortOrder = 0;
		if (isRecalculateTicket) {
			now = selectedDate;
		}
		double taxAmount = ticket.getTaxAmount();
		double discountAmount = NumberUtil.round((ticket.getDiscountAmount() - leDiscountAmount));
		double salesAmount = ticket.getSubTotal() + leProductSalesAmount + leProductReturnAmount - unEarnedItemPrice;

		double remainTaxAmount = 0;
		if (!NumberUtil.isZero(ticketItemPrice) || (transaction != null && transaction instanceof RefundTransaction)) {
			remainTaxAmount = ticketItemTotalTaxAmount + leTaxAmount;
		}
		double unEarnedAmount = 0;
		discountAmount = discountAmount - unEarnedItemDiscount;
		Double paidAmount = ticket.getPaidAmount();
		unEarnedAmount = unEarnedItemPrice + unEarnedItemTax - (unEarnedItemDiscount + leUnearnDebitAmount);

		double remainProductSalesAmount = (ticket.getTotalAmount() - unEarnedAmount) - (paidAmount - ticket.getRefundAmount());

		double unEarnedRevenueAmount = 0;
		if (!NumberUtil.isZero(unEarnedItemPrice) && paidAmount > ticketItemPrice - ticketItemTotalDiscountAmount + ticketItemTotalTaxAmount) {
			unEarnedRevenueAmount = ((paidAmount - ticket.getRefundAmount()) - (ticketItemPrice - ticketItemTotalDiscountAmount + ticketItemTotalTaxAmount))
					+ leUnEarnedRevenueAmount;
		}
		if (!NumberUtil.isZero(unEarnedRevenueAmount) && !NumberUtil.isZero(leUnearnDebitAmount)) {
			unEarnedRevenueAmount = unEarnedRevenueAmount - (leUnearnDebitAmount + leReceivableAmount);
		}

		String orderGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("ORDER");

		if (transaction != null) {
			ChartOfAccounts spendMethodCOA = getSpendMethodCOAForByz(transaction, dataProvider, session);

			double transAmount = transaction.getAmount();
			if (transaction instanceof RefundTransaction || transaction.isVoided()) {
				transAmount = (-1) * transAmount;

				if (NumberUtil.isZero(unEarnedItemPrice) && !NumberUtil.isZero(leUnEarnedRevenueAmount)) {
					unEarnedRevenueAmount += leUnEarnedRevenueAmount;
				}

				if (!NumberUtil.isZero(salesAmount)) {
					LedgerEntry createPSLedgerEntry = LedgerEntry.createLedgerEntry(ticket, productsReturnCOA, DirectionType.CREDIT, salesAmount,
							"ORDER/" + ticket.getId(), now);
					createPSLedgerEntry.setGroupId(orderGroupId);
					createPSLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
					createPSLedgerEntry.setSortOrder(++sortOrder);
					save(createPSLedgerEntry);
				}
			}

			if (!NumberUtil.isZero(transAmount)) {
				String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("TRANS");

				LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(ticket, spendMethodCOA, DirectionType.DEBIT, transAmount,
						"TRANS/" + transaction.getId(), now);
				createCashLedgerEntry.setTransactionId(transaction.getId());
				createCashLedgerEntry.setGroupId(groupId);
				createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createCashLedgerEntry.setSortOrder(++sortOrder);
				createCashLedgerEntry.setCashDrawerId(transaction.getCashDrawerId());
				save(createCashLedgerEntry);

			}

			Set<PosTransaction> transactions = ticket.getTransactions();
			for (PosTransaction posTransaction : transactions) {
				if (posTransaction.getId().equals(transaction.getId())) {
					posTransaction.setAccountProcessed(true);
				}
			}

			if (!NumberUtil.isZero(discountAmount)) {
				LedgerEntry createDiscountLedgerEntry = LedgerEntry.createLedgerEntry(ticket, discountCOA, DirectionType.DEBIT, discountAmount,
						"ORDER/" + ticket.getId(), now);
				createDiscountLedgerEntry.setGroupId(orderGroupId);
				createDiscountLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createDiscountLedgerEntry.setSortOrder(++sortOrder);
				save(createDiscountLedgerEntry);
			}

			if (!NumberUtil.isZero(unEarnedRevenueAmount) /*&& !NumberUtil.isZero(totalCost)*/) {

				LedgerEntry createUnEarnedLedgerEntry = LedgerEntry.createLedgerEntry(ticket, unEarnedCOA, DirectionType.CREDIT, unEarnedRevenueAmount,
						"ORDER/" + ticket.getId(), now);
				createUnEarnedLedgerEntry.setGroupId(orderGroupId);
				createUnEarnedLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createUnEarnedLedgerEntry.setSortOrder(++sortOrder);
				save(createUnEarnedLedgerEntry);
			}

		}
		else if (!NumberUtil.isZero(salesAmount) && salesAmount < 0) {
			LedgerEntry createPSLedgerEntry = LedgerEntry.createLedgerEntry(ticket, productsReturnCOA, DirectionType.CREDIT, salesAmount,
					"ORDER/" + ticket.getId(), now);
			createPSLedgerEntry.setGroupId(orderGroupId);
			createPSLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createPSLedgerEntry.setSortOrder(++sortOrder);
			save(createPSLedgerEntry);

			LedgerEntry createPayableLedgerEntry = LedgerEntry.createLedgerEntry(ticket, payableCOA, DirectionType.DEBIT, salesAmount,
					"ORDER/" + ticket.getId(), now);
			createPayableLedgerEntry.setGroupId(orderGroupId);
			createPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createPayableLedgerEntry.setSortOrder(++sortOrder);
			save(createPayableLedgerEntry);
		}

		//		if (transaction != null && !NumberUtil.isZero(unEarnedItemPrice)) {
		//			LedgerEntry createUnEarnedLedgerEntry = LedgerEntry.createLedgerEntry(ticket, unEarnedCOA, DirectionType.CREDIT, unEarnedItemPrice,
		//					"ORDER/" + ticket.getId(), now);
		//			createUnEarnedLedgerEntry.setGroupId(orderGroupId);
		//			createUnEarnedLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//			createUnEarnedLedgerEntry.setSortOrder(++sortOrder);
		//			save(createUnEarnedLedgerEntry);
		//		}

		//		double leReveivableAmount = getLedgerEntryAmount(receivableCOA.getId(), ticket.getId(), session);

		if ((/*(!NumberUtil.isZero(totalCost))
				&& */(!NumberUtil.isZero(remainProductSalesAmount) || !NumberUtil.isZero(leReceivableAmount) || !NumberUtil.isZero(lePayableAmount)))
				|| (NumberUtil.isZero(totalCost)) && transaction != null && transaction instanceof RefundTransaction) {
			if (!NumberUtil.isZero(leReceivableAmount)) {
				DirectionType directionType = DirectionType.CREDIT;
				double accountReceivableAmount = 0;
				if (transaction != null && transaction.getAmount() <= leReceivableAmount) {
					accountReceivableAmount = transaction.getAmount();
				}
				if (transaction != null && transaction.getAmount() > leReceivableAmount) {
					accountReceivableAmount = leReceivableAmount;
				}
				else {
					accountReceivableAmount = NumberUtil.round(leReceivableAmount - remainProductSalesAmount);
				}
				if (transaction instanceof RefundTransaction) {
					accountReceivableAmount = leReceivableAmount * (-1);
					directionType = DirectionType.DEBIT;
				}

				LedgerEntry createCreditLedgerEntry = LedgerEntry.createLedgerEntry(ticket, receivableCOA, directionType, accountReceivableAmount,
						"ORDER/" + ticket.getId(), now);
				createCreditLedgerEntry.setGroupId(orderGroupId);
				createCreditLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createCreditLedgerEntry.setSortOrder(++sortOrder);
				save(createCreditLedgerEntry);
			}
			else if (!NumberUtil.isZero(ticketItemPrice) && (remainProductSalesAmount < 0 || !NumberUtil.isZero(lePayableAmount))) {
				double accountPayableAmount = (lePayableAmount - remainProductSalesAmount) - unEarnedAmount;
				if (!NumberUtil.isZero(accountPayableAmount)) {
					LedgerEntry createCreditLedgerEntry = LedgerEntry.createLedgerEntry(ticket, payableCOA, DirectionType.CREDIT, accountPayableAmount,
							"ORDER/" + ticket.getId(), now);
					createCreditLedgerEntry.setGroupId(orderGroupId);
					createCreditLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
					createCreditLedgerEntry.setSortOrder(++sortOrder);
					save(createCreditLedgerEntry);
				}
			}
			else if (!NumberUtil.isZero(ticketItemPrice) && !ticket.isPaid()) {
				LedgerEntry createDebitLedgerEntry = LedgerEntry.createLedgerEntry(ticket, receivableCOA, DirectionType.DEBIT, remainProductSalesAmount,
						"ORDER/" + ticket.getId(), now);
				createDebitLedgerEntry.setGroupId(orderGroupId);
				createDebitLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createDebitLedgerEntry.setSortOrder(++sortOrder);
				save(createDebitLedgerEntry);
			}
		}

		if (!NumberUtil.isZero(discountAmount) && transaction == null) {
			LedgerEntry createDiscountLedgerEntry = LedgerEntry.createLedgerEntry(ticket, discountCOA, DirectionType.DEBIT, discountAmount,
					"ORDER/" + ticket.getId(), now);
			createDiscountLedgerEntry.setGroupId(orderGroupId);
			createDiscountLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createDiscountLedgerEntry.setSortOrder(++sortOrder);
			save(createDiscountLedgerEntry);
		}

		if (!NumberUtil.isZero(salesAmount) && salesAmount > 0) {
			LedgerEntry createPSLedgerEntry = LedgerEntry.createLedgerEntry(ticket, productsSalesCOA, DirectionType.CREDIT, salesAmount,
					"ORDER/" + ticket.getId(), now);
			createPSLedgerEntry.setGroupId(orderGroupId);
			createPSLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createPSLedgerEntry.setSortOrder(++sortOrder);
			save(createPSLedgerEntry);
		}

		if (!NumberUtil.isZero(remainTaxAmount) /*&& !NumberUtil.isZero(totalCost)*/) {
			LedgerEntry createTaxLedgerEntry = LedgerEntry.createLedgerEntry(ticket, taxCOA, DirectionType.CREDIT, remainTaxAmount, "ORDER/" + ticket.getId(),
					now);
			createTaxLedgerEntry.setGroupId(orderGroupId);
			createTaxLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createTaxLedgerEntry.setSortOrder(++sortOrder);
			save(createTaxLedgerEntry);
		}

		saveInventoryAdjLedgerEntryForByz(dataProvider, session, orderGroupId, sortOrder, now, ticket, totalCost, 0, itemWastedAmount, transaction);
		sortOrder = sortOrder + 2;
		if (ticket.isPaid()) {
			ticket.setAccountProcessed(true);
		}

		if (!isRecalculateTicket) {
			TicketDAO.getInstance().saveOrUpdate(ticket, session);
		}

		//			tx.commit();
		//		} catch (Exception e) {
		//			PosLog.error(getClass(), e);
		//		}
	}

	public void saveLedgerEntryForVoidTransaction(Ticket ticket, PosTransaction transaction, Session session) {

		Date now = StoreDAO.getServerTimestamp();
		DataProvider dataProvider = DataProvider.get();

		ChartOfAccounts receivableCOA = dataProvider.getCOAFromMap("1004", session);
		ChartOfAccounts unEarnedCOA = dataProvider.getCOAFromMap("2002", session);

		ChartOfAccounts receivedMethodCOA = getSpendMethodCOAForByz(transaction, dataProvider, session);

		double leProductSalesAmount = getLedgerEntryAmount(receivedMethodCOA.getId(), ticket.getId(), session);
		double leUnEarnedRevenueAmount = getLedgerEntryAmount(unEarnedCOA.getId(), ticket.getId(), session);

		String orderGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("ORDER");
		String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("TRANS");

		double transactionAmount = transaction.getAmount();
		double salesAmountWithoutUnEarnedRevenue = transactionAmount - Math.abs(leUnEarnedRevenueAmount);
		double salesAmountRevenue = leProductSalesAmount - Math.abs(leUnEarnedRevenueAmount);

		int sortOrder = 0;

		if (!NumberUtil.isZero(salesAmountWithoutUnEarnedRevenue) && !NumberUtil.isZero(salesAmountRevenue)) {
			LedgerEntry createDebitLedgerEntry = LedgerEntry.createLedgerEntry(ticket, receivableCOA, DirectionType.DEBIT, salesAmountWithoutUnEarnedRevenue,
					"ORDER/" + ticket.getId(), now);
			createDebitLedgerEntry.setGroupId(orderGroupId);
			createDebitLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createDebitLedgerEntry.setSortOrder(++sortOrder);
			save(createDebitLedgerEntry);
		}

		if (!NumberUtil.isZero(leUnEarnedRevenueAmount)) {
			double unEarnedAmount = Math.abs(leUnEarnedRevenueAmount);
			if (unEarnedAmount > transactionAmount) {
				unEarnedAmount = transactionAmount;
			}
			LedgerEntry createUnEarnedLedgerEntry = LedgerEntry.createLedgerEntry(ticket, unEarnedCOA, DirectionType.DEBIT, unEarnedAmount,
					"ORDER/" + ticket.getId(), now);
			createUnEarnedLedgerEntry.setGroupId(orderGroupId);
			createUnEarnedLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createUnEarnedLedgerEntry.setSortOrder(++sortOrder);
			save(createUnEarnedLedgerEntry, session);
		}

		LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(ticket, receivedMethodCOA, DirectionType.CREDIT, transactionAmount,
				"TRANS/" + transaction.getId() + " (Voided)", now);
		createCashLedgerEntry.setTransactionId(transaction.getId());
		createCashLedgerEntry.setGroupId(groupId);
		createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		createCashLedgerEntry.setSortOrder(++sortOrder);
		createCashLedgerEntry.setCashDrawerId(transaction.getCashDrawerId());
		save(createCashLedgerEntry);
	}

	public void saveChallanLedgerEntryForByz(Ticket ticket, Session session) {
		Date now = StoreDAO.getServerTimestamp();
		int sortOrder = 0;
		double itemCost = 0;
		double itemPrice = 0;
		double salesAmount = 0;
		double totalTaxAmount = 0;
		double totalDiscountAmount = 0;
		double earnedAmount = 0;
		double earnedTaxAmount = 0;
		double earnedItemCostAmount = 0;
		double earnedItemDiscountAmount = 0;
		List<TicketItem> ticketItems = ticket.getTicketItems();
		for (TicketItem ticketItem : ticketItems) {

			if (!ticketItem.isRequiredShipping() || ticketItem.getMenuItemId() == null || ticketItem.isVoided() || ticketItem.isItemReturned()) {
				earnedAmount += ticketItem.getSubtotalAmount();
				earnedItemCostAmount += ticketItem.getTotalCost();
				earnedTaxAmount += ticketItem.getAdjustedTax();
				earnedItemDiscountAmount += ticketItem.getAdjustedDiscount();
				continue;
			}
			Boolean shipped = ticketItem.isShipped();
			Double quantityToShip = ticketItem.getQuantityToShip();
			double adjustQty = ticketItem.getInventoryAdjustQty();
			itemCost += ticketItem.getUnitCost() * adjustQty;
			totalTaxAmount += (ticketItem.getAdjustedTax() / ticketItem.getQuantity()) * adjustQty;
			//			itemPrice += (ticketItem.getAdjustedUnitPrice() * adjustQty) + taxAmount;
			itemPrice += ticketItem.getUnitPrice() * adjustQty;
			//			salesAmount += ticketItem.getUnitPrice() * adjustQty;

			totalDiscountAmount += (ticketItem.getAdjustedDiscount() / ticketItem.getQuantity()) * adjustQty;
		}

		if (NumberUtil.isZero(itemCost)) {
			return;
		}

		DataProvider dataProvider = DataProvider.get();
		ChartOfAccounts unEarnedCOA = dataProvider.getCOAFromMap("2002", session);
		ChartOfAccounts productsSalesCOA = dataProvider.getCOAFromMap("4001", session);
		ChartOfAccounts discountCOA = dataProvider.getCOAFromMap("5016", session);
		ChartOfAccounts taxCOA = dataProvider.getCOAFromMap("2005", session);

		ChartOfAccounts receivableCOA = dataProvider.getCOAFromMap("1004", session);
		ChartOfAccounts payableCOA = dataProvider.getCOAFromMap("2001", session);

		double leSalesAmount = getLedgerEntryAmount(productsSalesCOA.getId(), ticket.getId(), session);
		double leUnEarnedRevenueAmount = getLedgerEntryAmount(unEarnedCOA.getId(), ticket.getId(), session);
		double leUnEarnedDebitAmount = getLedgerEntryAmountForDebit(unEarnedCOA.getId(), ticket.getId());
		double leDiscountAmount = getLedgerEntryAmount(discountCOA.getId(), ticket.getId(), session);
		double leTaxtAmount = getLedgerEntryAmount(taxCOA.getId(), ticket.getId(), session);
		double leAccountReceivableAmount = getLedgerEntryAmount(receivableCOA.getId(), ticket.getId(), session);

		salesAmount += itemPrice + leSalesAmount + earnedAmount;
		double discountAmount = totalDiscountAmount - (leDiscountAmount - earnedItemDiscountAmount);
		double taxAmount = totalTaxAmount + leTaxtAmount + earnedTaxAmount;
		//		itemPrice = (itemPrice + taxAmount - discountAmount) - leUnEarnedRevenueAmount;

		//		double unEarnAmount = Math.abs(leUnEarnedRevenueAmount);

		//		double itemDueAmount = itemPrice - (unEarnAmount - taxAmount);

		double totalUnEarnItemPrice = (itemPrice + taxAmount - discountAmount);
		double unEarnAmount = totalUnEarnItemPrice;
		double unEarnedRevenueAmont = Math.abs(leUnEarnedRevenueAmount);
		if (unEarnedRevenueAmont < unEarnAmount) {
			unEarnAmount = unEarnedRevenueAmont;
		}
		//		double itemDueAmount = (totalUnEarnItemPrice - leTaxtAmount - leUnEarnedDebitAmount) - unEarnAmount;
		Double paidAmount = ticket.getPaidAmount() - (earnedAmount - earnedItemDiscountAmount + earnedTaxAmount);
		double itemDueAmount = (itemPrice - totalDiscountAmount + totalTaxAmount) - (paidAmount + leAccountReceivableAmount);

		String orderGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("ORDER");

		//		if (!NumberUtil.isZero(itemPrice)) {
		//			itemPrice = Math.abs(itemPrice);
		//			LedgerEntry createUnEarnedLedgerEntry = LedgerEntry.createLedgerEntry(ticket, unEarnedCOA, DirectionType.DEBIT, itemPrice,
		//					"ORDER/" + ticket.getId(), now);
		//			createUnEarnedLedgerEntry.setGroupId(orderGroupId);
		//			createUnEarnedLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//			createUnEarnedLedgerEntry.setSortOrder(++sortOrder);
		//			save(createUnEarnedLedgerEntry, session);
		//		}
		if (!NumberUtil.isZero(unEarnAmount)) {
			LedgerEntry createUnEarnedLedgerEntry = LedgerEntry.createLedgerEntry(ticket, unEarnedCOA, DirectionType.DEBIT, unEarnAmount,
					"ORDER/" + ticket.getId(), now);
			createUnEarnedLedgerEntry.setGroupId(orderGroupId);
			createUnEarnedLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createUnEarnedLedgerEntry.setSortOrder(++sortOrder);
			save(createUnEarnedLedgerEntry, session);
		}
		if (!NumberUtil.isZero(itemDueAmount) && itemDueAmount > 0) {
			//			if (itemDueAmount < 0) {
			//				LedgerEntry createPayableLedgerEntry = LedgerEntry.createLedgerEntry(ticket, payableCOA, DirectionType.DEBIT, itemDueAmount,
			//						"ORDER/" + ticket.getId(), now);
			//				createPayableLedgerEntry.setGroupId(orderGroupId);
			//				createPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			//				createPayableLedgerEntry.setSortOrder(++sortOrder);
			//				save(createPayableLedgerEntry, session);
			//			}
			//			else {
			LedgerEntry createCreditLedgerEntry = LedgerEntry.createLedgerEntry(ticket, receivableCOA, DirectionType.DEBIT, itemDueAmount,
					"ORDER/" + ticket.getId(), now);
			createCreditLedgerEntry.setGroupId(orderGroupId);
			createCreditLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createCreditLedgerEntry.setSortOrder(++sortOrder);
			save(createCreditLedgerEntry, session);
		}
		if (!NumberUtil.isZero(discountAmount)) {
			LedgerEntry createDiscountLedgerEntry = LedgerEntry.createLedgerEntry(ticket, discountCOA, DirectionType.DEBIT, discountAmount,
					"ORDER/" + ticket.getId(), now);
			createDiscountLedgerEntry.setGroupId(orderGroupId);
			createDiscountLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createDiscountLedgerEntry.setSortOrder(++sortOrder);
			save(createDiscountLedgerEntry, session);
		}

		//		double salesAmount = ticket.getSubTotal();
		if (!NumberUtil.isZero(salesAmount) && salesAmount > 0 && !NumberUtil.isZero(itemCost)) {
			LedgerEntry createPSLedgerEntry = LedgerEntry.createLedgerEntry(ticket, productsSalesCOA, DirectionType.CREDIT, salesAmount,
					"ORDER/" + ticket.getId(), now);
			createPSLedgerEntry.setGroupId(orderGroupId);
			createPSLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createPSLedgerEntry.setSortOrder(++sortOrder);
			save(createPSLedgerEntry, session);
		}

		if (!NumberUtil.isZero(taxAmount)) {
			taxAmount = Math.abs(taxAmount);
			LedgerEntry createTaxLedgerEntry = LedgerEntry.createLedgerEntry(ticket, taxCOA, DirectionType.CREDIT, taxAmount, "ORDER/" + ticket.getId(), now);
			createTaxLedgerEntry.setGroupId(orderGroupId);
			createTaxLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createTaxLedgerEntry.setSortOrder(++sortOrder);
			save(createTaxLedgerEntry, session);
		}

		saveInventoryAdjLedgerEntryForByz(dataProvider, session, orderGroupId, sortOrder, now, ticket, itemCost, earnedItemCostAmount);
	}

	private ChartOfAccounts getSpendMethodCOA(PaymentType paymentType, DataProvider dataProvider, Session session) {

		if (PaymentType.BANK_ACCOUNT == paymentType || PaymentType.DEBIT_CARD == paymentType || PaymentType.CREDIT_CARD == paymentType) {
			return dataProvider.getCOAFromMap("10200", session); //Bank - Regular Checking
		}

		if (PaymentType.CUSTOM_PAYMENT == paymentType) {
			return dataProvider.getCOAFromMap("10500", session); //Regular Checking
		}

		if (PaymentType.MEMBER_ACCOUNT == paymentType || PaymentType.ADVANCE_ADJUSTMENT == paymentType) {
			return dataProvider.getCOAFromMap("2100", session); //spend from member account
		}

		return dataProvider.getCOAFromMap("10100", session); //Cash - Regular Checking
	}

	private ChartOfAccounts getSpendMethodCOAForByz(PosTransaction transaction, DataProvider dataProvider, Session session) {
		return getSpendMethodCOAForByz(transaction, dataProvider, session, null, "");
	}

	private ChartOfAccounts getSpendMethodCOAForByz(PosTransaction transaction, DataProvider dataProvider, Session session,
			BalanceUpdateTransaction balanceUpdateTransaction, String linkeBankAccountId) {
		PaymentType paymentType = null;
		String linkedWithBankAccountId = "";
		if (transaction != null) {
			paymentType = transaction.getPaymentType();
			linkedWithBankAccountId = transaction.getLinkedBankAccountId();
		}
		else if (balanceUpdateTransaction != null) {
			paymentType = balanceUpdateTransaction.getPaymentType();
		}

		if (StringUtils.isBlank(linkedWithBankAccountId)) {
			linkedWithBankAccountId = linkeBankAccountId;
		}

		if (PaymentType.BANK_ACCOUNT == paymentType || PaymentType.DEBIT_CARD == paymentType || PaymentType.CREDIT_CARD == paymentType
				|| StringUtils.isNotBlank(linkedWithBankAccountId)) {
			return dataProvider.getCOAFromMap("1002", session); //Bank - Regular Checking
		}

		//		if (PaymentType.CUSTOM_PAYMENT == paymentType) {
		//			return dataProvider.getCOAFromMap("10500", session); //Regular Checking
		//		}

		if (PaymentType.MEMBER_ACCOUNT == paymentType || PaymentType.ADVANCE_ADJUSTMENT == paymentType) {
			return dataProvider.getCOAFromMap("2100", session); //spend from member account
		}

		return dataProvider.getCOAFromMap("1001", session); //Cash - Regular Checking
	}

	public void saveInventoryAdjLedgerEntry(DataProvider dataProvider, Session session, String groupId, int sortOrder, Date now, Ticket ticket,
			double totalCost) {
		ChartOfAccounts costOfGoodsSoldCOA = dataProvider.getCOAFromMap("310", session);
		ChartOfAccounts inventoryCOA = dataProvider.getCOAFromMap("630", session);

		double leCostOfGoodsSoldAmount = getLedgerEntryAmount(costOfGoodsSoldCOA.getId(), ticket.getId());
		double remainCostOfGoodsSoldAmount = totalCost - leCostOfGoodsSoldAmount;
		if (!NumberUtil.isZero(remainCostOfGoodsSoldAmount)) {
			LedgerEntry createInventoryLedgerEntry = LedgerEntry.createLedgerEntry(ticket, inventoryCOA, DirectionType.CREDIT, remainCostOfGoodsSoldAmount,
					"ORDER/" + ticket.getId(), now);
			createInventoryLedgerEntry.setGroupId(groupId);
			createInventoryLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createInventoryLedgerEntry.setSortOrder(++sortOrder);
			save(createInventoryLedgerEntry);

			LedgerEntry createCostOfGoodsSoldLedgerEntry = LedgerEntry.createLedgerEntry(ticket, costOfGoodsSoldCOA, DirectionType.DEBIT,
					remainCostOfGoodsSoldAmount, "ORDER/" + ticket.getId(), now);
			createCostOfGoodsSoldLedgerEntry.setGroupId(groupId);
			createCostOfGoodsSoldLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
			createCostOfGoodsSoldLedgerEntry.setSortOrder(++sortOrder);
			save(createCostOfGoodsSoldLedgerEntry);
		}
	}

	public void saveInventoryAdjLedgerEntryForByz(DataProvider dataProvider, Session session, String groupId, int sortOrder, Date now, Ticket ticket,
			double totalCost) {
		saveInventoryAdjLedgerEntryForByz(dataProvider, session, groupId, sortOrder, now, ticket, totalCost, 0);
	}

	public void saveInventoryAdjLedgerEntryForByz(DataProvider dataProvider, Session session, String groupId, int sortOrder, Date now, Ticket ticket,
			double totalCost, double unEarnedItemCost) {
		saveInventoryAdjLedgerEntryForByz(dataProvider, session, groupId, sortOrder, now, ticket, totalCost, unEarnedItemCost, 0, null);
	}

	public void saveInventoryAdjLedgerEntryForByz(DataProvider dataProvider, Session session, String groupId, int sortOrder, Date now, Ticket ticket,
			double totalCost, double unEarnedItemCost, double itemWastedAmount, PosTransaction transaction) {
		ChartOfAccounts costOfGoodsSoldCOA = dataProvider.getCOAFromMap("310", session);
		ChartOfAccounts inventoryCOA = dataProvider.getCOAFromMap("1005", session);
		//		ChartOfAccounts wastedItemCOA = dataProvider.getCOAFromMap("6150", session);

		double leCostOfGoodsSoldAmount = getLedgerEntryAmount(costOfGoodsSoldCOA.getId(), ticket.getId());
		//		totalCost += itemWastedAmount;
		double remainCostOfGoodsSoldAmount = totalCost - (leCostOfGoodsSoldAmount - unEarnedItemCost);

		//		double leInventoryAmount = getLedgerEntryAmount(inventoryCOA.getId(), ticket.getId());
		//		leInventoryAmount += itemWastedAmount;

		//		if (!NumberUtil.isZero(itemWastedAmount)) {
		//			LedgerEntry createItemWastedLedgerEntry = LedgerEntry.createLedgerEntry(ticket, wastedItemCOA, DirectionType.CREDIT, itemWastedAmount,
		//					"ORDER/" + ticket.getId(), now);
		//			createItemWastedLedgerEntry.setGroupId(groupId);
		//			createItemWastedLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
		//			createItemWastedLedgerEntry.setSortOrder(++sortOrder);
		//			save(createItemWastedLedgerEntry, session);
		//		}

		if (!NumberUtil.isZero(remainCostOfGoodsSoldAmount)) {

			if (remainCostOfGoodsSoldAmount < 0) {

				//				if (!NumberUtil.isZero(totalCost)) {

				LedgerEntry createInventoryLedgerEntry = LedgerEntry.createLedgerEntry(ticket, inventoryCOA, DirectionType.CREDIT, remainCostOfGoodsSoldAmount,
						"ORDER/" + ticket.getId(), now);
				createInventoryLedgerEntry.setGroupId(groupId);
				createInventoryLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createInventoryLedgerEntry.setSortOrder(++sortOrder);
				save(createInventoryLedgerEntry, session);
				//				}

				LedgerEntry createCostOfGoodsSoldLedgerEntry = LedgerEntry.createLedgerEntry(ticket, costOfGoodsSoldCOA, DirectionType.DEBIT,
						remainCostOfGoodsSoldAmount, "ORDER/" + ticket.getId(), now);
				createCostOfGoodsSoldLedgerEntry.setGroupId(groupId);
				createCostOfGoodsSoldLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createCostOfGoodsSoldLedgerEntry.setSortOrder(++sortOrder);
				save(createCostOfGoodsSoldLedgerEntry, session);

			}
			else {
				LedgerEntry createCostOfGoodsSoldLedgerEntry = LedgerEntry.createLedgerEntry(ticket, costOfGoodsSoldCOA, DirectionType.DEBIT,
						remainCostOfGoodsSoldAmount, "ORDER/" + ticket.getId(), now);
				createCostOfGoodsSoldLedgerEntry.setGroupId(groupId);
				createCostOfGoodsSoldLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createCostOfGoodsSoldLedgerEntry.setSortOrder(++sortOrder);
				save(createCostOfGoodsSoldLedgerEntry, session);

				LedgerEntry createInventoryLedgerEntry = LedgerEntry.createLedgerEntry(ticket, inventoryCOA, DirectionType.CREDIT, remainCostOfGoodsSoldAmount,
						"ORDER/" + ticket.getId(), now);
				createInventoryLedgerEntry.setGroupId(groupId);
				createInventoryLedgerEntry.setLedgerEntryType(LedgerEntryType.ORDER_ENTRY.name());
				createInventoryLedgerEntry.setSortOrder(++sortOrder);
				save(createInventoryLedgerEntry, session);
			}

		}
	}

	public double getLedgerEntryAmount(String accountId, String ticketId) {
		try (Session session = createNewSession()) {
			return getLedgerEntryAmount(accountId, ticketId, session);
		}
	}

	public double getLedgerEntryAmount(String accountId, String ticketId, Session session) {
		Criteria criteria = session.createCriteria(LedgerEntry.class);

		criteria.add(Restrictions.eq(LedgerEntry.PROP_ACCOUNT_ID, accountId));
		if (StringUtils.isNotBlank(ticketId)) {
			criteria.add(Restrictions.eq(LedgerEntry.PROP_TICKET_ID, ticketId));
		}

		criteria.add(Restrictions.eq(LedgerEntry.PROP_LEDGER_ENTRY_TYPE, LedgerEntryType.ORDER_ENTRY.name()));

		ProjectionList projectionList = Projections.projectionList();
		projectionList.add(Projections.sqlProjection("sum(direction*amount) AS " + LedgerEntry.PROP_AMOUNT, new String[] { LedgerEntry.PROP_AMOUNT },
				new Type[] { new DoubleType() }));
		criteria.setProjection(projectionList);
		Number number = (Number) criteria.uniqueResult();

		if (number != null) {
			return number.doubleValue();
		}
		return 0;
	}

	public double getLedgerEntryAmountByOrderId(String accountId, String purchaseOrderId, Session session) {
		return getLedgerEntryAmountByOrderId(accountId, purchaseOrderId, session, false);
	}

	public double getLedgerEntryAmountByOrderId(String accountId, String purchaseOrderId, Session session, boolean isServiceOrder) {
		Criteria criteria = session.createCriteria(LedgerEntry.class);

		criteria.add(Restrictions.eq(LedgerEntry.PROP_ACCOUNT_ID, accountId));
		criteria.add(Restrictions.eq(LedgerEntry.PROP_PURCHASE_ORDER_ID, purchaseOrderId));

		if (isServiceOrder) {
			criteria.add(Restrictions.eq(LedgerEntry.PROP_LEDGER_ENTRY_TYPE, LedgerEntryType.SERVICE_ORDER.name()));
		}
		else {
			criteria.add(Restrictions.eq(LedgerEntry.PROP_LEDGER_ENTRY_TYPE, LedgerEntryType.PURCHASE.name()));
		}

		ProjectionList projectionList = Projections.projectionList();
		projectionList.add(Projections.sqlProjection("sum(direction*amount) AS " + LedgerEntry.PROP_AMOUNT, new String[] { LedgerEntry.PROP_AMOUNT },
				new Type[] { new DoubleType() }));
		criteria.setProjection(projectionList);
		Number number = (Number) criteria.uniqueResult();

		if (number != null) {
			return number.doubleValue();
		}
		return 0;
	}

	public double getLedgerEntryAmountForDebit(String accountId, String ticketId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(LedgerEntry.class);

			criteria.add(Restrictions.eq(LedgerEntry.PROP_ACCOUNT_ID, accountId));
			criteria.add(Restrictions.eq(LedgerEntry.PROP_TICKET_ID, ticketId));
			criteria.add(Restrictions.eq(LedgerEntry.PROP_DIRECTION, DirectionType.DEBIT.getTypeNo()));

			criteria.add(Restrictions.eq(LedgerEntry.PROP_LEDGER_ENTRY_TYPE, LedgerEntryType.ORDER_ENTRY.name()));

			ProjectionList projectionList = Projections.projectionList();
			projectionList.add(Projections.sqlProjection("sum(direction*amount) AS " + LedgerEntry.PROP_AMOUNT, new String[] { LedgerEntry.PROP_AMOUNT },
					new Type[] { new DoubleType() }));
			criteria.setProjection(projectionList);
			Number number = (Number) criteria.uniqueResult();

			if (number != null) {
				return number.doubleValue();
			}
			return 0;
		}
	}

	public void saveRFPayLedgerEntry(Map<Ticket, Double> ticketsMap, String transactionId, Session session) {
		Set<Ticket> keySet = ticketsMap.keySet();
		Date now = StoreDAO.getServerTimestamp();
		int sortOrder = 0;
		for (Ticket ticket : keySet) {
			DataProvider dataProvider = DataProvider.get();

			ChartOfAccounts cashChartOfAccounts = dataProvider.getCOAFromMap("10100", session);
			//ChartOfAccounts rfPayableCOA = instance.getCOAFromMap("507", session);
			ChartOfAccounts rfPayableCOA = dataProvider.getCOAFromMap("832", session);

			double transAmount = ticketsMap.get(ticket);
			String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("RF");

			LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(ticket, cashChartOfAccounts, DirectionType.CREDIT, transAmount,
					"TRANS/" + transactionId, now);
			createCashLedgerEntry.setTransactionId(transactionId);
			createCashLedgerEntry.setGroupId(groupId);
			createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.RF_PAY.name());
			createCashLedgerEntry.setSortOrder(++sortOrder);
			LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);

			LedgerEntry createRFLedgerEntry = LedgerEntry.createLedgerEntry(ticket, rfPayableCOA, DirectionType.DEBIT, transAmount, "TRANS/" + transactionId,
					now);
			createRFLedgerEntry.setTransactionId(transactionId);
			createRFLedgerEntry.setGroupId(groupId);
			createRFLedgerEntry.setLedgerEntryType(LedgerEntryType.RF_PAY.name());
			createRFLedgerEntry.setSortOrder(++sortOrder);
			LedgerEntryDAO.getInstance().save(createRFLedgerEntry, session);
		}

	}

	public void saveLDFPayLedgerEntry(Map<Ticket, Double> ticketsMap, String transactionId, Session session) {
		Set<Ticket> keySet = ticketsMap.keySet();
		Date now = StoreDAO.getServerTimestamp();
		int sortOrder = 0;
		for (Ticket ticket : keySet) {
			DataProvider dataProvider = DataProvider.get();

			ChartOfAccounts cashChartOfAccounts = dataProvider.getCOAFromMap("10100", session);
			//ChartOfAccounts ldfPayableCOA = instance.findByAcountCode("508", session);
			ChartOfAccounts ldfPayableCOA = dataProvider.getCOAFromMap("833", session);

			double transAmount = ticketsMap.get(ticket);
			String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("LDF");

			LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(ticket, cashChartOfAccounts, DirectionType.CREDIT, transAmount,
					"TRANS/" + transactionId, now);
			createCashLedgerEntry.setTransactionId(transactionId);
			createCashLedgerEntry.setGroupId(groupId);
			createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.LDF_PAY.name());
			createCashLedgerEntry.setSortOrder(++sortOrder);
			LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);

			LedgerEntry createLDFPayLedgerEntry = LedgerEntry.createLedgerEntry(ticket, ldfPayableCOA, DirectionType.DEBIT, transAmount,
					"TRANS/" + transactionId, now);
			createLDFPayLedgerEntry.setTransactionId(transactionId);
			createLDFPayLedgerEntry.setGroupId(groupId);
			createLDFPayLedgerEntry.setLedgerEntryType(LedgerEntryType.LDF_PAY.name());
			createLDFPayLedgerEntry.setSortOrder(++sortOrder);
			LedgerEntryDAO.getInstance().save(createLDFPayLedgerEntry, session);
		}
	}

	public List getLedgerEntries(List<String> coaAccountTypeGroupIds) {
		try (Session session = createNewSession()) {

			DetachedCriteria coaTypeDetachedCriteria = DetachedCriteria.forClass(COAAccountType.class);
			coaTypeDetachedCriteria.setProjection(Property.forName(COAAccountType.PROP_ID));
			if (!coaAccountTypeGroupIds.isEmpty()) {
				coaTypeDetachedCriteria.add(Restrictions.in(COAAccountType.PROP_COA_ACCOUNT_TYPE_GROUP_ID, coaAccountTypeGroupIds));
			}

			DetachedCriteria coaDetachedCriteria = DetachedCriteria.forClass(ChartOfAccounts.class);
			coaDetachedCriteria.setProjection(Property.forName(ChartOfAccounts.PROP_ID));
			coaDetachedCriteria.add(Property.forName(ChartOfAccounts.PROP_COA_ACCOUNT_TYPE_ID).in(coaTypeDetachedCriteria)); //$NON-NLS-1$

			Criteria criteria = session.createCriteria(LedgerEntry.class);

			ProjectionList projectionList = Projections.projectionList();
			projectionList.add(Projections.property(LedgerEntry.PROP_ACCOUNT_ID), "coaId");
			projectionList.add(Projections.sqlProjection("sum(direction*amount) AS " + "amount", new String[] { "amount" }, new Type[] { new DoubleType() }));

			projectionList.add(Projections.groupProperty(LedgerEntry.PROP_ACCOUNT_ID));
			criteria.setProjection(projectionList);

			criteria.add(Property.forName(LedgerEntry.PROP_ACCOUNT_ID).in(coaDetachedCriteria)); //$NON-NLS-1$

			criteria.setResultTransformer(Transformers.aliasToBean(BalanceSheetLedgerEntryModel.class));
			return criteria.list();

		}
	}

	public BalanceSheetLedgerEntryModel getRetainedEarning(Date startDate, Date endDate) {
		try (Session session = createNewSession()) {
			List<String> coaAccountTypeGroupIds = Arrays.asList("revenue", "expense");

			DetachedCriteria coaTypeDetachedCriteria = DetachedCriteria.forClass(COAAccountType.class);
			coaTypeDetachedCriteria.setProjection(Property.forName(COAAccountType.PROP_ID));
			if (!coaAccountTypeGroupIds.isEmpty()) {
				coaTypeDetachedCriteria.add(Restrictions.in(COAAccountType.PROP_COA_ACCOUNT_TYPE_GROUP_ID, coaAccountTypeGroupIds));
			}

			DetachedCriteria coaDetachedCriteria = DetachedCriteria.forClass(ChartOfAccounts.class);
			coaDetachedCriteria.setProjection(Property.forName(ChartOfAccounts.PROP_ID));
			coaDetachedCriteria.add(Property.forName(ChartOfAccounts.PROP_COA_ACCOUNT_TYPE_ID).in(coaTypeDetachedCriteria)); //$NON-NLS-1$

			Criteria criteria = session.createCriteria(LedgerEntry.class);
			if (startDate != null) {
				criteria.add(Restrictions.ge(LedgerEntry.PROP_CREATE_DATE, startDate));
			}
			if (endDate != null) {
				criteria.add(Restrictions.lt(LedgerEntry.PROP_CREATE_DATE, endDate));
			}

			ProjectionList projectionList = Projections.projectionList();
			projectionList.add(Projections.sqlProjection("sum(direction*amount) AS " + "amount", new String[] { "amount" }, new Type[] { new DoubleType() }));
			criteria.setProjection(projectionList);

			criteria.add(Property.forName(LedgerEntry.PROP_ACCOUNT_ID).in(coaDetachedCriteria)); //$NON-NLS-1$
			BalanceSheetLedgerEntryModel retainedEarning = new BalanceSheetLedgerEntryModel();
			retainedEarning.setName("Retained earning");
			Number number = (Number) criteria.uniqueResult();
			if (number != null) {
				retainedEarning.setAmount(number.doubleValue());
			}
			return retainedEarning;

		}
	}

	public List getSumOfLedgerEntries(Date startDate, Date endDate) {
		try (Session session = createNewSession()) {
			Map<String, BalanceSheetLedgerEntryModel> map = new HashMap<String, BalanceSheetLedgerEntryModel>();
			Criteria criteria = session.createCriteria(LedgerEntry.class);

			if (startDate != null) {
				criteria.add(Restrictions.ge(LedgerEntry.PROP_CREATE_DATE, startDate));
			}
			if (endDate != null) {
				criteria.add(Restrictions.lt(LedgerEntry.PROP_CREATE_DATE, endDate));
			}

			ProjectionList projectionList = Projections.projectionList();
			projectionList.add(Projections.property(LedgerEntry.PROP_ACCOUNT_ID), "coaId");
			projectionList.add(Projections.property(LedgerEntry.PROP_DIRECTION), LedgerEntry.PROP_DIRECTION);
			projectionList.add(Projections.sqlProjection("sum(amount) AS " + "amount", new String[] { "amount" }, new Type[] { new DoubleType() }));

			projectionList.add(Projections.groupProperty(LedgerEntry.PROP_ACCOUNT_ID));
			projectionList.add(Projections.groupProperty(LedgerEntry.PROP_DIRECTION));
			criteria.setProjection(projectionList);

			criteria.setResultTransformer(Transformers.aliasToBean(BalanceSheetLedgerEntryModel.class));

			List<BalanceSheetLedgerEntryModel> list = criteria.list();
			if (list != null) {

				for (BalanceSheetLedgerEntryModel entryModel : list) {
					String coaId = entryModel.getCoaId();
					if (StringUtils.isBlank(coaId)) {
						continue;
					}

					BalanceSheetLedgerEntryModel model = map.get(coaId);
					if (model == null) {
						model = new BalanceSheetLedgerEntryModel();
						model.setCoaId(coaId);
						model.setDirection(null);
						map.put(coaId, model);
					}

					//double amount = model.getAmount();
					double amount = entryModel.getAmount() * entryModel.getDirection();
					//Show data based on Ledger entry direction
					DirectionType type = DirectionType.getByTypeNo(entryModel.getDirection());
					if (DirectionType.DEBIT == type) {
						model.setDebitAmount(amount);
					}
					else {
						model.setCreditAmount(amount);
					}
					model.setAmount(model.getDebitAmount() + model.getCreditAmount());

					//					//Show data based on  COA > COAAccountType > Account Type Group direction
					//					ChartOfAccounts chartOfAccounts = ChartOfAccountsDAO.getInstance().get(coaId);
					//					if (chartOfAccounts != null) {
					//						COAAccountType coaAccountType = COAAccountTypeDAO.getInstance().get(chartOfAccounts.getCoaAccountTypeId());
					//						COAAccountTypeGroup group = COAAccountTypeGroupDAO.getInstance().get(coaAccountType.getCoaAccountTypeGroupId());
					//						DirectionType type = DirectionType.getByTypeNo(group.getAccountDirection());
					//						if (DirectionType.DEBIT == type) {
					//							model.setDebitAmount(amount);
					//						}
					//						else {
					//							model.setCreditAmount(amount * (-1));
					//						}
					//						model.setAmount(amount);
					//					}
				}
			}
			return map.values().stream().filter(t -> !NumberUtil.isZero(t.getAmount())).collect(Collectors.toList());
		}
	}

	public double getTaxLedgerEntryAmount(Date startDate, Date endDate) {
		return getLedgerEntriesAmountByTypeId("expense", "506", startDate, endDate);
	}

	public double getLedgerEntriesAmountByTypeId(String coaAccountTypeId, Date startDate, Date endDate) {
		return getLedgerEntriesAmountByTypeId(coaAccountTypeId, "", startDate, endDate);
	}

	public double getLedgerEntriesAmountByTypeId(String coaAccountTypeId, String coaCode, Date startDate, Date endDate) {
		try (Session session = createNewSession()) {

			DetachedCriteria coaDetachedCriteria = DetachedCriteria.forClass(ChartOfAccounts.class);
			coaDetachedCriteria.setProjection(Property.forName(ChartOfAccounts.PROP_ID));
			if (StringUtils.isNotBlank(coaAccountTypeId)) {
				coaDetachedCriteria.add(Restrictions.eq(ChartOfAccounts.PROP_COA_ACCOUNT_TYPE_ID, coaAccountTypeId));
			}
			if (StringUtils.isNotBlank(coaCode)) {
				coaDetachedCriteria.add(Restrictions.eq(ChartOfAccounts.PROP_ACCOUNT_CODE, coaCode));
			}
			Criteria criteria = session.createCriteria(LedgerEntry.class);

			if (startDate != null) {
				criteria.add(Restrictions.ge(LedgerEntry.PROP_CREATE_DATE, startDate));
			}
			if (endDate != null) {
				criteria.add(Restrictions.lt(LedgerEntry.PROP_CREATE_DATE, endDate));
			}

			ProjectionList projectionList = Projections.projectionList();
			projectionList.add(Projections.sqlProjection("sum(direction*amount) AS " + "amount", new String[] { "amount" }, new Type[] { new DoubleType() }));
			criteria.setProjection(projectionList);

			criteria.add(Property.forName(LedgerEntry.PROP_ACCOUNT_ID).in(coaDetachedCriteria)); //$NON-NLS-1$

			Number number = (Number) criteria.uniqueResult();
			if (number != null) {
				return number.doubleValue();
			}

		}
		return 0;
	}

	/**
	 * @param startDate
	 * @param endDate
	 *  find all account type IDs with group id "expense"
	 *  find all ChartOfAccounts IDs with COAAccountType IDs without "direct_costs" account type
	 * 
	 * @return Expense amount by account type without cost
	 */
	public List getExpenseLedgerEntries(Date startDate, Date endDate) {
		return getExpenseLedgerEntries(startDate, endDate, false);
	}

	public List getExpenseLedgerEntries(Date startDate, Date endDate, boolean isShowExpenseWithoutDiscount) {
		return getCustomLedgerEntries(startDate, endDate, Arrays.asList("expense"), "direct_costs", "506", isShowExpenseWithoutDiscount);
	}

	public List getCustomLedgerEntries(Date startDate, Date endDate, List<String> accountTypeGroupIds, String withoutAccountTypeId, String withoutAccountCode) {
		return getCustomLedgerEntries(startDate, endDate, accountTypeGroupIds, withoutAccountTypeId, withoutAccountCode, false);
	}

	public List getCustomLedgerEntries(Date startDate, Date endDate, List<String> accountTypeGroupIds, String withoutAccountTypeId, String withoutAccountCode,
			boolean isShowExpenseWithoutDiscount) {
		return getCustomLedgerEntries(startDate, endDate, accountTypeGroupIds, Arrays.asList(withoutAccountTypeId), withoutAccountCode,
				isShowExpenseWithoutDiscount);
	}

	public List getCustomLedgerEntries(Date startDate, Date endDate, List<String> accountTypeGroupIds, List<String> withoutAccountTypeIds,
			String withoutAccountCode) {
		return getCustomLedgerEntries(startDate, endDate, accountTypeGroupIds, withoutAccountTypeIds, withoutAccountCode, false);
	}

	public List getCustomLedgerEntries(Date startDate, Date endDate, List<String> accountTypeGroupIds, List<String> withoutAccountTypeIds,
			String withoutAccountCode, boolean isShowExpenseWithoutDiscount) {
		try (Session session = createNewSession()) {

			DetachedCriteria coaTypeDetachedCriteria = DetachedCriteria.forClass(COAAccountType.class);
			coaTypeDetachedCriteria.setProjection(Property.forName(COAAccountType.PROP_ID));

			if (accountTypeGroupIds != null) {
				coaTypeDetachedCriteria.add(Restrictions.in(COAAccountType.PROP_COA_ACCOUNT_TYPE_GROUP_ID, accountTypeGroupIds));
			}

			DetachedCriteria coaDetachedCriteria = DetachedCriteria.forClass(ChartOfAccounts.class);
			coaDetachedCriteria.setProjection(Property.forName(ChartOfAccounts.PROP_ID));
			coaDetachedCriteria.add(Property.forName(ChartOfAccounts.PROP_COA_ACCOUNT_TYPE_ID).in(coaTypeDetachedCriteria)); //$NON-NLS-1$
			if (!withoutAccountTypeIds.isEmpty()) {
				coaDetachedCriteria.add(Restrictions.not(Restrictions.in(ChartOfAccounts.PROP_COA_ACCOUNT_TYPE_ID, withoutAccountTypeIds)));
			}
			if (StringUtils.isNotBlank(withoutAccountCode)) {
				coaDetachedCriteria.add(Restrictions.ne(ChartOfAccounts.PROP_ACCOUNT_CODE, withoutAccountCode));
			}
			if (isShowExpenseWithoutDiscount) {
				coaDetachedCriteria.add(Restrictions.ne(ChartOfAccounts.PROP_ACCOUNT_CODE, "5016"));
			}
			Criteria criteria = session.createCriteria(LedgerEntry.class);

			if (startDate != null) {
				criteria.add(Restrictions.ge(LedgerEntry.PROP_CREATE_DATE, startDate));
			}
			if (endDate != null) {
				criteria.add(Restrictions.lt(LedgerEntry.PROP_CREATE_DATE, endDate));
			}

			ProjectionList projectionList = Projections.projectionList();
			projectionList.add(Projections.property(LedgerEntry.PROP_ACCOUNT_ID), "coaId");
			projectionList.add(Projections.sqlProjection("sum(direction*amount) AS " + "amount", new String[] { "amount" }, new Type[] { new DoubleType() }));

			projectionList.add(Projections.groupProperty(LedgerEntry.PROP_ACCOUNT_ID));
			criteria.setProjection(projectionList);

			criteria.add(Property.forName(LedgerEntry.PROP_ACCOUNT_ID).in(coaDetachedCriteria)); //$NON-NLS-1$

			criteria.setResultTransformer(Transformers.aliasToBean(BalanceSheetLedgerEntryModel.class));
			return criteria.list();

		}
	}

	public List getLedgerEntriesByTypeId(String coaAccountTypeId, Date startDate, Date endDate) {
		return getLedgerEntriesByTypeId(Arrays.asList(coaAccountTypeId), startDate, endDate);
	}

	public List getLedgerEntriesByTypeId(List<String> coaAccountTypeId, Date startDate, Date endDate) {
		try (Session session = createNewSession()) {

			DetachedCriteria coaDetachedCriteria = DetachedCriteria.forClass(ChartOfAccounts.class);
			coaDetachedCriteria.setProjection(Property.forName(ChartOfAccounts.PROP_ID));
			coaDetachedCriteria.add(Property.forName(ChartOfAccounts.PROP_COA_ACCOUNT_TYPE_ID).in(coaAccountTypeId)); //$NON-NLS-1$
			Criteria criteria = session.createCriteria(LedgerEntry.class);

			if (startDate != null) {
				criteria.add(Restrictions.ge(LedgerEntry.PROP_CREATE_DATE, startDate));
			}
			if (endDate != null) {
				criteria.add(Restrictions.lt(LedgerEntry.PROP_CREATE_DATE, endDate));
			}

			ProjectionList projectionList = Projections.projectionList();
			projectionList.add(Projections.property(LedgerEntry.PROP_ACCOUNT_ID), "coaId");
			projectionList.add(Projections.sqlProjection("sum(direction*amount) AS " + "amount", new String[] { "amount" }, new Type[] { new DoubleType() }));

			projectionList.add(Projections.groupProperty(LedgerEntry.PROP_ACCOUNT_ID));
			criteria.setProjection(projectionList);

			criteria.add(Property.forName(LedgerEntry.PROP_ACCOUNT_ID).in(coaDetachedCriteria)); //$NON-NLS-1$

			criteria.setResultTransformer(Transformers.aliasToBean(BalanceSheetLedgerEntryModel.class));
			criteria.addOrder(Order.desc("coaId"));
			return criteria.list();

		}
	}

	public void savePayoutLedgerEntry(PosTransaction posTransaction, Session session) {
		savePayoutLedgerEntry(posTransaction, false, session);
	}

	public void savePayoutLedgerEntry(PosTransaction posTransaction, boolean isRevert, Session session) {
		DataProvider dataProvider = DataProvider.get();
		ChartOfAccounts cashExpenseCOA = dataProvider.getCOAFromMap("429", session);
		//			if (posTransaction.isExpenses()) {
		//				cashExpenseCOA = dataProvider.getCOAFromMap("430", session);
		//			}
		//			else {
		//				cashExpenseCOA = dataProvider.getCOAFromMap("429", session);
		//			}

		ChartOfAccounts cashCOA = dataProvider.getCOAFromMap("10100", session);
		Date now = StoreDAO.getServerTimestamp();
		Double payoutAmount = isRevert ? (-1) * posTransaction.getAmount() : posTransaction.getAmount();
		if (!NumberUtil.isZero(payoutAmount)) {

			String refKey = isRevert ? "PAYOUT_REVERT" : "PAYOUT";
			String descriptionKey = isRevert ? "PAYOUT_REVERT/" : "PAYOUT/";

			String payoutGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef(refKey);
			String transId = posTransaction.getId();
			String description = StringUtils.isBlank(posTransaction.getNote()) ? (descriptionKey + transId) : posTransaction.getNote();
			LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(null, cashCOA, DirectionType.CREDIT, payoutAmount, description, now);
			createCashLedgerEntry.setGroupId(payoutGroupId);
			createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.SALARY.name());
			createCashLedgerEntry.setTransactionId(transId);
			createCashLedgerEntry.setCashDrawerId(posTransaction.getCashDrawerId());
			createCashLedgerEntry.setPayoutRecepientId(posTransaction.getRecepientId());
			createCashLedgerEntry.setSortOrder(2);
			LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);

			LedgerEntry createCRPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, cashExpenseCOA, DirectionType.DEBIT, payoutAmount, description, now);
			createCRPayableLedgerEntry.setGroupId(payoutGroupId);
			createCRPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.SALARY.name());
			createCRPayableLedgerEntry.setTransactionId(transId);
			createCRPayableLedgerEntry.setCashDrawerId(posTransaction.getCashDrawerId());
			createCRPayableLedgerEntry.setPayoutRecepientId(posTransaction.getRecepientId());
			createCRPayableLedgerEntry.setSortOrder(1);
			LedgerEntryDAO.getInstance().save(createCRPayableLedgerEntry, session);

			posTransaction.setAccountProcessed(true);
			PayOutTransactionDAO.getInstance().saveOrUpdate(posTransaction, session);

		}
	}

	public void saveOrUpdateLedgerEntryList(List<LedgerEntry> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator<LedgerEntry> iterator = dataList.iterator(); iterator.hasNext();) {
				LedgerEntry item = (LedgerEntry) iterator.next();
				LedgerEntry existingItem = get(item.getId());
				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						PosLog.info(getClass(), item.getChartOfAccountDisplay() + " already updated"); //$NON-NLS-1$
						continue;
					}
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}
	}

	public List<LedgerEntry> getLedgerEntry(String ticketId, Session session) {
		Criteria criteria = session.createCriteria(LedgerEntry.class);
		criteria.add(Restrictions.eq(LedgerEntry.PROP_TICKET_ID, ticketId));
		return criteria.list();
	}

	public void saveExpensesLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, boolean isFromAM) {
		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
			Transaction tx = session.beginTransaction();

			saveExpensesLedgerEntry(balanceUpdateTransaction, isFromAM, session);

			balanceUpdateTransaction.setAccountProcessed(true);
			BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);

			tx.commit();
		}
	}

	public void saveExpensesLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, boolean isFromAM, Session session) {
		saveExpensesLedgerEntry(balanceUpdateTransaction, isFromAM, null, session);
	}

	public void saveExpensesLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, boolean isFromAM, String coaCode, Session session) {
		saveExpensesLedgerEntry(balanceUpdateTransaction, isFromAM, coaCode, session, null);
	}

	public void saveExpensesLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, boolean isFromAM, String coaCode, Session session,
			BankAccount linkedBankAccount) {
		DataProvider dataProvider = DataProvider.get();
		ChartOfAccounts expenseCOA = null;
		if (StringUtils.isNotBlank(coaCode)) {
			expenseCOA = dataProvider.getCOAFromMap(coaCode, session);
		}
		else {
			expenseCOA = dataProvider.getCOAFromMap("430", session);
		}
		String linkedBankAccountId = "";
		if (linkedBankAccount != null) {
			linkedBankAccountId = linkedBankAccount.getAccountNo();
		}
		ChartOfAccounts depositMethodCOA = getSpendMethodCOAForByz(null, dataProvider, session, balanceUpdateTransaction, linkedBankAccountId);

		Double payoutAmount = Math.abs(balanceUpdateTransaction.getAmount());
		if (!NumberUtil.isZero(payoutAmount)) {
			if (BalanceSubType.EXPENSE_REVERT.name().equals(balanceUpdateTransaction.getTransactionSubType())) {
				payoutAmount = payoutAmount * (-1);
			}

			String payoutGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("EXPENSES");
			String transId = balanceUpdateTransaction.getId();
			String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("EXPENSES/" + transId)
					: balanceUpdateTransaction.getDescription();

			Date eventTime = balanceUpdateTransaction.getEventTime();
			Calendar now = Calendar.getInstance();
			int currentHour = now.get(Calendar.HOUR_OF_DAY);
			int currentMinute = now.get(Calendar.MINUTE);
			int currentSecond = now.get(Calendar.SECOND);
			int currentMillisecond = now.get(Calendar.MILLISECOND);

			Calendar eventCal = Calendar.getInstance();
			eventCal.setTime(eventTime);
			eventCal.set(Calendar.HOUR_OF_DAY, currentHour);
			eventCal.set(Calendar.MINUTE, currentMinute);
			eventCal.set(Calendar.SECOND, currentSecond);
			eventCal.set(Calendar.MILLISECOND, currentMillisecond);

			eventTime = eventCal.getTime();

			LedgerEntry createDepositLedgerEntry = LedgerEntry.createLedgerEntry(null, depositMethodCOA, DirectionType.CREDIT, payoutAmount, description,
					eventTime);
			createDepositLedgerEntry.setGroupId(payoutGroupId);
			createDepositLedgerEntry.setLedgerEntryType(LedgerEntryType.EXPENSE.name());
			createDepositLedgerEntry.setTransactionId(transId);
			if (isFromAM) {
				createDepositLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
			}
			createDepositLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());

			LedgerEntry createExpenseLedgerEntry = LedgerEntry.createLedgerEntry(null, expenseCOA, DirectionType.DEBIT, payoutAmount, description, eventTime);
			createExpenseLedgerEntry.setGroupId(payoutGroupId);
			createExpenseLedgerEntry.setLedgerEntryType(LedgerEntryType.EXPENSE.name());
			createExpenseLedgerEntry.setTransactionId(transId);
			if (isFromAM) {
				createExpenseLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
			}
			createExpenseLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());

			if (payoutAmount > 0) {
				createExpenseLedgerEntry.setSortOrder(1);
				createDepositLedgerEntry.setSortOrder(2);
			}
			else {
				createExpenseLedgerEntry.setSortOrder(2);
				createDepositLedgerEntry.setSortOrder(1);
			}
			LedgerEntryDAO.getInstance().save(createExpenseLedgerEntry, session);
			LedgerEntryDAO.getInstance().save(createDepositLedgerEntry, session);

			//			balanceUpdateTransaction.setAccountProcessed(true);
			//			BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);

		}
	}

	public void saveLiabilityLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, boolean isFromAM, String coaCode, Session session,
			BankAccount linkedBankAccount) {
		DataProvider dataProvider = DataProvider.get();
		if (StringUtils.isBlank(coaCode)) {
			return;
		}
		ChartOfAccounts liabilityCOA = dataProvider.getCOAFromMap(coaCode, session);
		String linkedBankAccountId = "";
		if (linkedBankAccount != null) {
			linkedBankAccountId = linkedBankAccount.getAccountNo();
		}
		ChartOfAccounts depositMethodCOA = getSpendMethodCOAForByz(null, dataProvider, session, balanceUpdateTransaction, linkedBankAccountId);

		Double payoutAmount = Math.abs(balanceUpdateTransaction.getAmount());
		if (!NumberUtil.isZero(payoutAmount)) {
			if (BalanceSubType.EXPENSE_REVERT.name().equals(balanceUpdateTransaction.getTransactionSubType())) {
				payoutAmount = payoutAmount * (-1);
			}

			String payoutGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("EXPENSE");
			String transId = balanceUpdateTransaction.getId();
			String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("EXPENSE/" + transId)
					: balanceUpdateTransaction.getDescription();

			Date eventTime = balanceUpdateTransaction.getEventTime();
			Calendar now = Calendar.getInstance();
			int currentHour = now.get(Calendar.HOUR_OF_DAY);
			int currentMinute = now.get(Calendar.MINUTE);
			int currentSecond = now.get(Calendar.SECOND);
			int currentMillisecond = now.get(Calendar.MILLISECOND);

			Calendar eventCal = Calendar.getInstance();
			eventCal.setTime(eventTime);
			eventCal.set(Calendar.HOUR_OF_DAY, currentHour);
			eventCal.set(Calendar.MINUTE, currentMinute);
			eventCal.set(Calendar.SECOND, currentSecond);
			eventCal.set(Calendar.MILLISECOND, currentMillisecond);

			eventTime = eventCal.getTime();

			LedgerEntry createCashBookLedgerEntry = LedgerEntry.createLedgerEntry(null, liabilityCOA, DirectionType.DEBIT, payoutAmount, description,
					eventTime);
			createCashBookLedgerEntry.setGroupId(payoutGroupId);
			createCashBookLedgerEntry.setLedgerEntryType(LedgerEntryType.EXPENSE.name());
			createCashBookLedgerEntry.setTransactionId(transId);
			if (isFromAM) {
				createCashBookLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
			}
			createCashBookLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createCashBookLedgerEntry.setSortOrder(1);
			LedgerEntryDAO.getInstance().save(createCashBookLedgerEntry, session);

			LedgerEntry createAccountsManagerEntry = LedgerEntry.createLedgerEntry(null, depositMethodCOA, DirectionType.CREDIT, payoutAmount, description,
					eventTime);
			createAccountsManagerEntry.setGroupId(payoutGroupId);
			createAccountsManagerEntry.setLedgerEntryType(LedgerEntryType.EXPENSE.name());
			createAccountsManagerEntry.setTransactionId(transId);
			if (isFromAM) {
				createAccountsManagerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
			}
			createAccountsManagerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createAccountsManagerEntry.setSortOrder(2);
			LedgerEntryDAO.getInstance().save(createAccountsManagerEntry, session);

		}
	}

	public void saveBankAccountsAddBalanceLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, Session session) {
		DataProvider dataProvider = DataProvider.get();
		ChartOfAccounts bankCOA = dataProvider.getCOAFromMap("1002", session);
		ChartOfAccounts ownersEquityCOA = dataProvider.getCOAFromMap("3001", session);

		Double payoutAmount = Math.abs(balanceUpdateTransaction.getAmount());
		if (!NumberUtil.isZero(payoutAmount)) {
			String payoutGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("CAPITAL_INJECTION");
			String transId = balanceUpdateTransaction.getId();
			String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("Capital injection/" + transId)
					: balanceUpdateTransaction.getDescription();

			Date now = StoreDAO.getServerTimestamp();

			LedgerEntry createBankLedgerEntry = LedgerEntry.createLedgerEntry(null, bankCOA, DirectionType.DEBIT, payoutAmount, description, now);
			createBankLedgerEntry.setGroupId(payoutGroupId);
			createBankLedgerEntry.setLedgerEntryType(LedgerEntryType.IN.name());
			createBankLedgerEntry.setTransactionId(transId);
			createBankLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createBankLedgerEntry.setSortOrder(1);
			LedgerEntryDAO.getInstance().save(createBankLedgerEntry, session);

			LedgerEntry createOwnersEquityLedgerEntry = LedgerEntry.createLedgerEntry(null, ownersEquityCOA, DirectionType.CREDIT, payoutAmount, description,
					now);
			createOwnersEquityLedgerEntry.setGroupId(payoutGroupId);
			createOwnersEquityLedgerEntry.setLedgerEntryType(LedgerEntryType.IN.name());
			createOwnersEquityLedgerEntry.setTransactionId(transId);
			createOwnersEquityLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createOwnersEquityLedgerEntry.setSortOrder(2);
			LedgerEntryDAO.getInstance().save(createOwnersEquityLedgerEntry, session);
		}
	}

	public void saveBankAccountToCashInLedgerEntryForMed(BalanceUpdateTransaction balanceUpdateTransaction, Session session) {
		saveBankAccountToCashInLedgerEntry(balanceUpdateTransaction, session, "10100", "10200");
	}

	public void saveBankAccountToCashInLedgerEntryForByz(BalanceUpdateTransaction balanceUpdateTransaction, Session session) {
		saveBankAccountToCashInLedgerEntry(balanceUpdateTransaction, session, "1001", "1002");
	}

	public void saveBankAccountToCashInLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, Session session, String cashCoaCode, String bankCoaCode) {

		DataProvider dataProvider = DataProvider.get();
		ChartOfAccounts cashCOA = dataProvider.getCOAFromMap(cashCoaCode, session);
		ChartOfAccounts bankCOA = dataProvider.getCOAFromMap(bankCoaCode, session);

		Double payoutAmount = Math.abs(balanceUpdateTransaction.getAmount());
		if (!NumberUtil.isZero(payoutAmount)) {
			String payoutGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("BALANCE_TRANSFER");
			String transId = balanceUpdateTransaction.getId();
			String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("Balance transfer" + "/" + transId)
					: balanceUpdateTransaction.getDescription();

			Date now = StoreDAO.getServerTimestamp();

			LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(null, cashCOA, DirectionType.DEBIT, payoutAmount, description, now);
			createCashLedgerEntry.setGroupId(payoutGroupId);
			createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.TRANSFER.name());
			createCashLedgerEntry.setTransactionId(transId);
			createCashLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createCashLedgerEntry.setSortOrder(1);
			LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);

			LedgerEntry createOwnersEquityLedgerEntry = LedgerEntry.createLedgerEntry(null, bankCOA, DirectionType.CREDIT, payoutAmount, description, now);
			createOwnersEquityLedgerEntry.setGroupId(payoutGroupId);
			createOwnersEquityLedgerEntry.setLedgerEntryType(LedgerEntryType.TRANSFER.name());
			createOwnersEquityLedgerEntry.setTransactionId(transId);
			createOwnersEquityLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createOwnersEquityLedgerEntry.setSortOrder(2);
			LedgerEntryDAO.getInstance().save(createOwnersEquityLedgerEntry, session);
		}

		balanceUpdateTransaction.setAccountProcessed(true);
		BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);
	}

	public void saveCashDepositLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, boolean isFormCashDrawer, boolean isStoreDeposit) {
		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
			Transaction tx = session.beginTransaction();
			DataProvider dataProvider = DataProvider.get();
			Date now = StoreDAO.getServerTimestamp();

			ChartOfAccounts cashCOA;
			if (isFormCashDrawer) {
				cashCOA = dataProvider.getCOAFromMap("10100", session);
			}
			else {
				cashCOA = dataProvider.getCOAFromMap("880", session);
			}

			ChartOfAccounts depositMethodCOA;
			if (isStoreDeposit) {
				depositMethodCOA = dataProvider.getCOAFromMap("10400", session);
			}
			else {
				depositMethodCOA = dataProvider.getCOAFromMap("10300", session);
			}

			Double addAmount = balanceUpdateTransaction.getAmount();
			if (!NumberUtil.isZero(addAmount)) {
				String refKey = isStoreDeposit ? "STORE_DEPOSIT" : "ACCOUNTS_MANAGER";
				String prePaymentsId = SequenceNumberDAO.getInstance().getNextLedgerRef(refKey);
				String transId = balanceUpdateTransaction.getId();
				String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? (refKey + "/" + transId)
						: balanceUpdateTransaction.getDescription();

				LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(null, cashCOA, DirectionType.CREDIT, addAmount, description, now);
				createCashLedgerEntry.setGroupId(prePaymentsId);
				createCashLedgerEntry.setLedgerEntryType(isFormCashDrawer ? LedgerEntryType.TRANSFER.name() : LedgerEntryType.IN.name());
				createCashLedgerEntry.setTransactionId(transId);
				createCashLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
				createCashLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
				createCashLedgerEntry.setSortOrder(2);
				LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);

				LedgerEntry createAccountsManagerLedgerEntry = LedgerEntry.createLedgerEntry(null, depositMethodCOA, DirectionType.DEBIT, addAmount,
						description, now);
				createAccountsManagerLedgerEntry.setGroupId(prePaymentsId);
				createAccountsManagerLedgerEntry.setLedgerEntryType(LedgerEntryType.TRANSFER.name());
				createAccountsManagerLedgerEntry.setTransactionId(transId);
				createAccountsManagerLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
				createAccountsManagerLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
				createAccountsManagerLedgerEntry.setSortOrder(1);
				LedgerEntryDAO.getInstance().save(createAccountsManagerLedgerEntry, session);

				balanceUpdateTransaction.setAccountProcessed(true);
				BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);

			}

			tx.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	public void saveCashDepositLedgerEntryForMed(BalanceUpdateTransaction balanceUpdateTransaction, Session session) {
		saveCashDepositLedgerEntry(balanceUpdateTransaction, session, "10100", "10300");
	}

	public void saveCashDepositLedgerEntryForByz(BalanceUpdateTransaction balanceUpdateTransaction, Session session) {
		saveCashDepositLedgerEntry(balanceUpdateTransaction, session, "1001", "3001");
	}

	public void saveCashDepositLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, Session session, String cashCoaCode, String equityCoaCode) {

		DataProvider dataProvider = DataProvider.get();
		ChartOfAccounts ownersEquityCOA = dataProvider.getCOAFromMap(equityCoaCode, session);
		ChartOfAccounts cashCOA = dataProvider.getCOAFromMap(cashCoaCode, session);

		Double payoutAmount = Math.abs(balanceUpdateTransaction.getAmount());
		if (!NumberUtil.isZero(payoutAmount)) {
			String payoutGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("ADD_BALANCE");
			String transId = balanceUpdateTransaction.getId();
			String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("Add balance" + "/" + transId)
					: balanceUpdateTransaction.getDescription();

			Date now = StoreDAO.getServerTimestamp();

			LedgerEntry createCashLedgerEntry = LedgerEntry.createLedgerEntry(null, cashCOA, DirectionType.DEBIT, payoutAmount, description, now);
			createCashLedgerEntry.setGroupId(payoutGroupId);
			createCashLedgerEntry.setLedgerEntryType(LedgerEntryType.IN.name());
			createCashLedgerEntry.setTransactionId(transId);
			createCashLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createCashLedgerEntry.setSortOrder(1);
			LedgerEntryDAO.getInstance().save(createCashLedgerEntry, session);

			LedgerEntry createOwnersEquityLedgerEntry = LedgerEntry.createLedgerEntry(null, ownersEquityCOA, DirectionType.CREDIT, payoutAmount, description,
					now);
			createOwnersEquityLedgerEntry.setGroupId(payoutGroupId);
			createOwnersEquityLedgerEntry.setLedgerEntryType(LedgerEntryType.OUT.name());
			createOwnersEquityLedgerEntry.setTransactionId(transId);
			createOwnersEquityLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createOwnersEquityLedgerEntry.setSortOrder(2);
			LedgerEntryDAO.getInstance().save(createOwnersEquityLedgerEntry, session);
		}

		balanceUpdateTransaction.setAccountProcessed(true);
		BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);
	}

	public void saveAccManagerToStoreLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction) {
		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
			Transaction tx = session.beginTransaction();
			DataProvider dataProvider = DataProvider.get();
			Date now = StoreDAO.getServerTimestamp();

			ChartOfAccounts accountsManagerCOA = dataProvider.getCOAFromMap("10300", session);
			ChartOfAccounts cashCOA = dataProvider.getCOAFromMap("10100", session);

			Double transferToStoreAmount = Math.abs(balanceUpdateTransaction.getAmount());
			if (!NumberUtil.isZero(transferToStoreAmount)) {
				String accountsManagerGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("ACCOUNTS_MANAGER");
				String transId = balanceUpdateTransaction.getId();
				String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("ACCOUNTS_MANAGER/" + transId)
						: balanceUpdateTransaction.getDescription();
				LedgerEntry createAccountsManagerLedgerEntry = LedgerEntry.createLedgerEntry(null, accountsManagerCOA, DirectionType.CREDIT,
						transferToStoreAmount, description, now);
				createAccountsManagerLedgerEntry.setGroupId(accountsManagerGroupId);
				createAccountsManagerLedgerEntry.setLedgerEntryType(LedgerEntryType.TRANSFER.name());
				createAccountsManagerLedgerEntry.setTransactionId(transId);
				createAccountsManagerLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
				createAccountsManagerLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
				createAccountsManagerLedgerEntry.setSortOrder(2);
				LedgerEntryDAO.getInstance().save(createAccountsManagerLedgerEntry, session);

				LedgerEntry createCRPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, cashCOA, DirectionType.DEBIT, transferToStoreAmount, description,
						now);
				createCRPayableLedgerEntry.setGroupId(accountsManagerGroupId);
				createCRPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.TRANSFER.name());
				createCRPayableLedgerEntry.setTransactionId(transId);
				createCRPayableLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
				createCRPayableLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
				createCRPayableLedgerEntry.setSortOrder(1);
				LedgerEntryDAO.getInstance().save(createCRPayableLedgerEntry, session);

				balanceUpdateTransaction.setAccountProcessed(true);
				BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);

			}

			tx.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	public void saveWithdrawBalanceFromStoreLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction) {

		try (Session session = ChartOfAccountsDAO.getInstance().createNewSession()) {
			Transaction tx = session.beginTransaction();
			DataProvider dataProvider = DataProvider.get();
			Date now = StoreDAO.getServerTimestamp();

			ChartOfAccounts cashCOA = dataProvider.getCOAFromMap("10100", session);
			ChartOfAccounts ownerADrawingsCOA = dataProvider.getCOAFromMap("880", session);

			Double withdrawFromStoreAmount = Math.abs(balanceUpdateTransaction.getAmount());
			if (!NumberUtil.isZero(withdrawFromStoreAmount)) {
				String accountsManagerGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("ACCOUNTS_MANAGER");
				String transId = balanceUpdateTransaction.getId();
				String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("ACCOUNTS_MANAGER/" + transId)
						: balanceUpdateTransaction.getDescription();

				LedgerEntry createAccountsManagerLedgerEntry = LedgerEntry.createLedgerEntry(null, cashCOA, DirectionType.CREDIT, withdrawFromStoreAmount,
						description, now);
				createAccountsManagerLedgerEntry.setGroupId(accountsManagerGroupId);
				createAccountsManagerLedgerEntry.setLedgerEntryType(LedgerEntryType.OUT.name());
				createAccountsManagerLedgerEntry.setTransactionId(transId);
				createAccountsManagerLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
				createAccountsManagerLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
				createAccountsManagerLedgerEntry.setSortOrder(2);
				LedgerEntryDAO.getInstance().save(createAccountsManagerLedgerEntry, session);

				LedgerEntry createCRPayableLedgerEntry = LedgerEntry.createLedgerEntry(null, ownerADrawingsCOA, DirectionType.DEBIT, withdrawFromStoreAmount,
						description, now);
				createCRPayableLedgerEntry.setGroupId(accountsManagerGroupId);
				createCRPayableLedgerEntry.setLedgerEntryType(LedgerEntryType.OUT.name());
				createCRPayableLedgerEntry.setTransactionId(transId);
				createCRPayableLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
				createCRPayableLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
				createCRPayableLedgerEntry.setSortOrder(1);
				LedgerEntryDAO.getInstance().save(createCRPayableLedgerEntry, session);

				balanceUpdateTransaction.setAccountProcessed(true);
				BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);

			}

			tx.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}

	}

	public void saveBeginCashLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, Session session) {
		DataProvider dataProvider = DataProvider.get();
		Date now = StoreDAO.getServerTimestamp();

		ChartOfAccounts ownerDrawingCOA = dataProvider.getCOAFromMap("880", session);
		ChartOfAccounts cashCOA = dataProvider.getCOAFromMap("10100", session);

		Double beginCash = balanceUpdateTransaction.getAmount();
		if (!NumberUtil.isZero(beginCash)) {
			String beginCashGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("BEGIN_CASH");
			String transId = balanceUpdateTransaction.getId();
			String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("BEGIN_CASH/" + transId)
					: balanceUpdateTransaction.getDescription();

			LedgerEntry createCRLedgerEntry = LedgerEntry.createLedgerEntry(null, ownerDrawingCOA, DirectionType.CREDIT, beginCash, description, now);
			createCRLedgerEntry.setGroupId(beginCashGroupId);
			createCRLedgerEntry.setLedgerEntryType(LedgerEntryType.IN.name());
			createCRLedgerEntry.setTransactionId(transId);
			createCRLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
			createCRLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createCRLedgerEntry.setSortOrder(2);
			LedgerEntryDAO.getInstance().save(createCRLedgerEntry, session);

			LedgerEntry createDELedgerEntry = LedgerEntry.createLedgerEntry(null, cashCOA, DirectionType.DEBIT, beginCash, description, now);
			createDELedgerEntry.setGroupId(beginCashGroupId);
			createDELedgerEntry.setLedgerEntryType(LedgerEntryType.IN.name());
			createDELedgerEntry.setTransactionId(transId);
			createDELedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
			createDELedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
			createDELedgerEntry.setSortOrder(1);
			LedgerEntryDAO.getInstance().save(createDELedgerEntry, session);

			balanceUpdateTransaction.setAccountProcessed(true);
			BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);

		}

	}

	// TODO: Implement ledger creation logic 
	public void saveAddBalanceToCashDrawerLedgerEntry(BalanceUpdateTransaction balanceUpdateTransaction, Session session) {
		//DataProvider dataProvider = DataProvider.get();
		//Date now = StoreDAO.getServerTimestamp();
		//
		//ChartOfAccounts ownerDrawingCOA = dataProvider.getCOAFromMap("880", session);
		//ChartOfAccounts cashCOA = dataProvider.getCOAFromMap("10100", session);
		//
		//Double beginCash = balanceUpdateTransaction.getAmount();
		//if (!NumberUtil.isZero(beginCash)) {
		//	String beginCashGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("BEGIN_CASH");
		//	String transId = balanceUpdateTransaction.getId();
		//	String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("BEGIN_CASH/" + transId)
		//			: balanceUpdateTransaction.getDescription();
		//
		//	LedgerEntry createCRLedgerEntry = LedgerEntry.createLedgerEntry(null, ownerDrawingCOA, DirectionType.CREDIT, beginCash, description, now);
		//	createCRLedgerEntry.setGroupId(beginCashGroupId);
		//	createCRLedgerEntry.setLedgerEntryType(LedgerEntryType.IN.name());
		//	createCRLedgerEntry.setTransactionId(transId);
		//	createCRLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
		//	createCRLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
		//	createCRLedgerEntry.setSortOrder(2);
		//	LedgerEntryDAO.getInstance().save(createCRLedgerEntry, session);
		//
		//	LedgerEntry createDELedgerEntry = LedgerEntry.createLedgerEntry(null, cashCOA, DirectionType.DEBIT, beginCash, description, now);
		//	createDELedgerEntry.setGroupId(beginCashGroupId);
		//	createDELedgerEntry.setLedgerEntryType(LedgerEntryType.IN.name());
		//	createDELedgerEntry.setTransactionId(transId);
		//	createDELedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
		//	createDELedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());
		//	createDELedgerEntry.setSortOrder(1);
		//	LedgerEntryDAO.getInstance().save(createDELedgerEntry, session);
		//
		//	balanceUpdateTransaction.setAccountProcessed(true);
		//	BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);
		//
		//}

	}

	public void saveSalaryLedgerEntry(Session session, BalanceUpdateTransaction balanceUpdateTransaction, boolean isAMDepositMethod) {
		saveSalaryLedgerEntry(session, balanceUpdateTransaction, isAMDepositMethod, false, null);
	}

	public void saveSalaryLedgerEntry(Session session, BalanceUpdateTransaction balanceUpdateTransaction, boolean isAMDepositMethod, boolean isSalaryAdvanced,
			String linkedBankAccountId) {
		saveSalaryLedgerEntry(session, balanceUpdateTransaction, isAMDepositMethod, isSalaryAdvanced, linkedBankAccountId, false);
	}

	public void saveSalaryLedgerEntry(Session session, BalanceUpdateTransaction balanceUpdateTransaction, boolean isAMDepositMethod, boolean isSalaryAdvanced,
			String linkedBankAccountId, boolean isSalaryAdvancedRevert) {
		saveSalaryLedgerEntry(session, balanceUpdateTransaction, isAMDepositMethod, isSalaryAdvanced, linkedBankAccountId, isSalaryAdvancedRevert, null);
	}

	public void saveSalaryLedgerEntry(Session session, BalanceUpdateTransaction balanceUpdateTransaction, boolean isAMDepositMethod, boolean isSalaryAdvanced,
			String linkedBankAccountId, boolean isSalaryRevert, SalaryAdvanceBackTransaction slaryAdvanceBackTransaction) {
		DataProvider dataProvider = DataProvider.get();
		Date now = StoreDAO.getServerTimestamp();
		int sortOrder = 0;

		ChartOfAccounts wagesAndSalariesCOA = dataProvider.getCOAFromMap("5002", session);

		//		if (isSalaryAdvanced) {
		//			wagesAndSalariesCOA = dataProvider.getCOAFromMap("2105", session);
		//		}
		ChartOfAccounts spendMethodCOA = getSpendMethodCOAForByz(null, dataProvider, session, balanceUpdateTransaction, linkedBankAccountId);

		Double salaryAmount = Math.abs(balanceUpdateTransaction.getAmount());
		if (isSalaryRevert) {
			salaryAmount = salaryAmount * (-1);
		}
		if (!NumberUtil.isZero(salaryAmount)) {
			String salaryGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("SALARY");
			String transId = balanceUpdateTransaction.getId();
			String description = StringUtils.isBlank(balanceUpdateTransaction.getDescription()) ? ("SALARY/" + transId)
					: balanceUpdateTransaction.getDescription();

			LedgerEntry createSalaryPaymentLedgerEntry = LedgerEntry.createLedgerEntry(null, wagesAndSalariesCOA, DirectionType.DEBIT, salaryAmount,
					description, now);
			createSalaryPaymentLedgerEntry.setGroupId(salaryGroupId);
			createSalaryPaymentLedgerEntry.setLedgerEntryType(LedgerEntryType.SALARY.name());
			createSalaryPaymentLedgerEntry.setTransactionId(transId);
			createSalaryPaymentLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
			createSalaryPaymentLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());

			LedgerEntry createStoreOrAMLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.CREDIT, salaryAmount, description, now);
			createStoreOrAMLedgerEntry.setGroupId(salaryGroupId);
			createStoreOrAMLedgerEntry.setLedgerEntryType(LedgerEntryType.SALARY.name());
			createStoreOrAMLedgerEntry.setTransactionId(transId);
			createStoreOrAMLedgerEntry.setAccountsManagerId(balanceUpdateTransaction.getAccountNumber());
			createStoreOrAMLedgerEntry.setPayoutRecepientId(balanceUpdateTransaction.getRecepientId());

			if (isSalaryRevert) {
				createStoreOrAMLedgerEntry.setSortOrder(++sortOrder);
				createSalaryPaymentLedgerEntry.setSortOrder(++sortOrder);
			}
			else {
				createSalaryPaymentLedgerEntry.setSortOrder(++sortOrder);
				createStoreOrAMLedgerEntry.setSortOrder(++sortOrder);
			}

			LedgerEntryDAO.getInstance().save(createSalaryPaymentLedgerEntry, session);
			LedgerEntryDAO.getInstance().save(createStoreOrAMLedgerEntry, session);

			if (slaryAdvanceBackTransaction != null) {
				saveSalaryAdvanceBackLedgerEntryForByz(session, slaryAdvanceBackTransaction, linkedBankAccountId, sortOrder, now);
			}

			balanceUpdateTransaction.setAccountProcessed(true);
			BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(balanceUpdateTransaction, session);
		}
	}

	public void saveSalaryAdvanceBackLedgerEntryForByz(Session session, SalaryAdvanceBackTransaction slaryAdvanceBackTransaction, String linkedBankAccountId,
			int sortOrder, Date now) {
		DataProvider dataProvider = DataProvider.get();

		ChartOfAccounts advanceToEmployeeCOA = dataProvider.getCOAFromMap("1011", session);

		ChartOfAccounts spendMethodCOA = getSpendMethodCOAForByz(slaryAdvanceBackTransaction, dataProvider, session, null, linkedBankAccountId);

		Double salaryAmount = Math.abs(slaryAdvanceBackTransaction.getAmount());
		if (!NumberUtil.isZero(salaryAmount)) {
			String salaryGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("SALARY");
			String transId = slaryAdvanceBackTransaction.getId();
			String description = ("SALARY/" + transId);

			LedgerEntry createStoreOrAMLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.DEBIT, salaryAmount, description, now);
			createStoreOrAMLedgerEntry.setGroupId(salaryGroupId);
			createStoreOrAMLedgerEntry.setLedgerEntryType(LedgerEntryType.SALARY.name());
			createStoreOrAMLedgerEntry.setTransactionId(transId);
			createStoreOrAMLedgerEntry.setPayoutRecepientId(slaryAdvanceBackTransaction.getRecepientId());
			createStoreOrAMLedgerEntry.setSortOrder(++sortOrder);
			LedgerEntryDAO.getInstance().save(createStoreOrAMLedgerEntry, session);

			LedgerEntry createSalaryPaymentLedgerEntry = LedgerEntry.createLedgerEntry(null, advanceToEmployeeCOA, DirectionType.CREDIT, salaryAmount,
					description, now);
			createSalaryPaymentLedgerEntry.setGroupId(salaryGroupId);
			createSalaryPaymentLedgerEntry.setLedgerEntryType(LedgerEntryType.SALARY.name());
			createSalaryPaymentLedgerEntry.setTransactionId(transId);
			createSalaryPaymentLedgerEntry.setPayoutRecepientId(slaryAdvanceBackTransaction.getRecepientId());
			createSalaryPaymentLedgerEntry.setSortOrder(++sortOrder);
			LedgerEntryDAO.getInstance().save(createSalaryPaymentLedgerEntry, session);
		}
	}

	public void saveSalaryAdvanceLedgerEntry(Session session, SalaryAdvanceTransaction salaryAdvanceTransaction) {
		saveSalaryAdvanceLedgerEntry(session, salaryAdvanceTransaction, false);
	}

	public void saveSalaryAdvanceLedgerEntry(Session session, SalaryAdvanceTransaction salaryAdvanceTransaction, boolean isSalaryAdvanced) {
		saveSalaryAdvanceLedgerEntry(session, salaryAdvanceTransaction, isSalaryAdvanced, false);
	}

	public void saveSalaryAdvanceLedgerEntry(Session session, SalaryAdvanceTransaction salaryAdvanceTransaction, boolean isSalaryAdvanced,
			boolean isSalaryAdvancedRevert) {
		if (salaryAdvanceTransaction == null) {
			return;
		}
		DataProvider dataProvider = DataProvider.get();
		Date now = StoreDAO.getServerTimestamp();

		ChartOfAccounts spendMethodCOA = getSpendMethodCOAForByz(salaryAdvanceTransaction, dataProvider, session);
		ChartOfAccounts wagesAndSalariesCOA = dataProvider.getCOAFromMap("1011", session);

		Double salaryAmount = Math.abs(salaryAdvanceTransaction.getAmount());
		if (isSalaryAdvancedRevert) {
			salaryAmount = salaryAmount * (-1);
		}
		if (!NumberUtil.isZero(salaryAmount)) {
			String salaryGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("SALARY");
			String transId = salaryAdvanceTransaction.getId();
			String description = "";
			if (isSalaryAdvancedRevert) {
				description = StringUtils.isBlank(salaryAdvanceTransaction.getRevertReason()) ? ("Loan/Salary advance")
						: salaryAdvanceTransaction.getRevertReason();
			}
			else {
				description = StringUtils.isBlank(salaryAdvanceTransaction.getNote()) ? ("Loan/Salary advance") : salaryAdvanceTransaction.getNote();
			}
			LedgerEntry createStoreOrAMLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.CREDIT, salaryAmount, description, now);
			createStoreOrAMLedgerEntry.setGroupId(salaryGroupId);
			createStoreOrAMLedgerEntry.setLedgerEntryType(LedgerEntryType.SALARY.name());
			createStoreOrAMLedgerEntry.setTransactionId(transId);
			createStoreOrAMLedgerEntry.setAccountsManagerId(salaryAdvanceTransaction.getAccountManagerId());
			createStoreOrAMLedgerEntry.setPayoutRecepientId(salaryAdvanceTransaction.getRecepientId());

			LedgerEntry createSalaryPaymentLedgerEntry = LedgerEntry.createLedgerEntry(null, wagesAndSalariesCOA, DirectionType.DEBIT, salaryAmount,
					description, now);
			createSalaryPaymentLedgerEntry.setGroupId(salaryGroupId);
			createSalaryPaymentLedgerEntry.setLedgerEntryType(LedgerEntryType.SALARY.name());
			createSalaryPaymentLedgerEntry.setTransactionId(transId);
			createSalaryPaymentLedgerEntry.setAccountsManagerId(salaryAdvanceTransaction.getAccountManagerId());
			createSalaryPaymentLedgerEntry.setPayoutRecepientId(salaryAdvanceTransaction.getRecepientId());

			if (isSalaryAdvancedRevert) {
				createStoreOrAMLedgerEntry.setSortOrder(1);
				createSalaryPaymentLedgerEntry.setSortOrder(2);

			}
			else {
				createSalaryPaymentLedgerEntry.setSortOrder(1);
				createStoreOrAMLedgerEntry.setSortOrder(2);
			}
			LedgerEntryDAO.getInstance().save(createStoreOrAMLedgerEntry, session);
			LedgerEntryDAO.getInstance().save(createSalaryPaymentLedgerEntry, session);

			salaryAdvanceTransaction.setAccountProcessed(true);
			BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(salaryAdvanceTransaction, session);

		}

	}

	public void handleCustomerDepositOrRefundAmountLedgerEntry(PosTransaction transaction, boolean isDeposit, Session session) {

		ChartOfAccounts customerDepositAmountCOA = DataProvider.get().getCOAFromMap("2100", session);
		//		ChartOfAccounts cashCOA = DataProvider.get().getCOAFromMap("10100", session);
		ChartOfAccounts spendMethodCOA = getSpendMethodCOA(transaction.getPaymentType(), DataProvider.get(), session);

		String description = isDeposit ? "Deposit from customer " + transaction.getCustomerName() : "Refund deposit amount";
		String grpId = SequenceNumberDAO.getInstance().getNextLedgerRef(isDeposit ? "IN" : "OUT");

		LedgerEntry deditLedgerEntry = LedgerEntry.createLedgerEntry(null, isDeposit ? spendMethodCOA : customerDepositAmountCOA, DirectionType.DEBIT,
				transaction.getAmount(), description, StoreDAO.getServerTimestamp());
		deditLedgerEntry.setGroupId(grpId);
		deditLedgerEntry.setLedgerEntryType(isDeposit ? LedgerEntryType.IN.name() : LedgerEntryType.OUT.name());
		deditLedgerEntry.setTransactionId(transaction.getId());
		deditLedgerEntry.setPatientId(transaction.getCustomerId());
		deditLedgerEntry.setCashDrawerId(transaction.getCashDrawerId());
		deditLedgerEntry.setSortOrder(2);
		LedgerEntryDAO.getInstance().save(deditLedgerEntry, session);

		LedgerEntry creaditLedgerEntry = LedgerEntry.createLedgerEntry(null, isDeposit ? customerDepositAmountCOA : spendMethodCOA, DirectionType.CREDIT,
				transaction.getAmount(), description, StoreDAO.getServerTimestamp());
		creaditLedgerEntry.setGroupId(grpId);
		creaditLedgerEntry.setLedgerEntryType(isDeposit ? LedgerEntryType.IN.name() : LedgerEntryType.OUT.name());
		creaditLedgerEntry.setTransactionId(transaction.getId());
		creaditLedgerEntry.setPatientId(transaction.getCustomerId());
		creaditLedgerEntry.setCashDrawerId(transaction.getCashDrawerId());
		creaditLedgerEntry.setSortOrder(1);
		LedgerEntryDAO.getInstance().save(creaditLedgerEntry, session);

		transaction.setAccountProcessed(true);
		BalanceUpdateTransactionDAO.getInstance().saveOrUpdate(transaction, session);
	}

	public void saveTransferToAcmLedgerEntry(BalanceUpdateTransaction debitTransaction, BalanceUpdateTransaction creditTransaction, Session session) {
		Date now = StoreDAO.getServerTimestamp();

		ChartOfAccounts accountsManagerCOA = DataProvider.get().getCOAFromMap("10300", session);
		//ChartOfAccounts cashCOA = instance.getCOAFromMap("10100", session);

		Double transferAmount = Math.abs(debitTransaction.getAmount());
		if (!NumberUtil.isZero(transferAmount)) {
			String accountsManagerGroupId = SequenceNumberDAO.getInstance().getNextLedgerRef("ACCOUNTS_MANAGER");
			String transId = debitTransaction.getId();

			LedgerEntry debitLedgerEntry = LedgerEntry.createLedgerEntry(null, accountsManagerCOA, DirectionType.DEBIT, transferAmount,
					debitTransaction.getDescription(), now);
			debitLedgerEntry.setGroupId(accountsManagerGroupId);
			debitLedgerEntry.setLedgerEntryType(LedgerEntryType.TRANSFER.name());
			debitLedgerEntry.setTransactionId(transId);
			debitLedgerEntry.setAccountsManagerId(debitTransaction.getAccountNumber());
			debitLedgerEntry.setPayoutRecepientId(creditTransaction.getAccountNumber());
			debitLedgerEntry.setSortOrder(2);
			LedgerEntryDAO.getInstance().save(debitLedgerEntry, session);

			LedgerEntry creditLedgerEntry = LedgerEntry.createLedgerEntry(null, accountsManagerCOA, DirectionType.CREDIT, transferAmount,
					creditTransaction.getDescription(), now);
			creditLedgerEntry.setGroupId(accountsManagerGroupId);
			creditLedgerEntry.setLedgerEntryType(LedgerEntryType.TRANSFER.name());
			creditLedgerEntry.setTransactionId(creditTransaction.getId());
			creditLedgerEntry.setAccountsManagerId(creditTransaction.getAccountNumber());
			creditLedgerEntry.setPayoutRecepientId(debitTransaction.getAccountNumber());
			creditLedgerEntry.setSortOrder(1);
			LedgerEntryDAO.getInstance().save(creditLedgerEntry, session);
		}
	}

	public void handleCustomerDepositVoidedLedgerEntry(PosTransaction advanceTransaction, Session session) {

		ChartOfAccounts customerDepositAmountCOA = DataProvider.get().getCOAFromMap("2100", session);
		ChartOfAccounts spendMethodCOA = getSpendMethodCOA(advanceTransaction.getPaymentType(), DataProvider.get(), session);

		String description = "Refund deposit amount";
		String groupId = SequenceNumberDAO.getInstance().getNextLedgerRef("OUT");
		Date now = StoreDAO.getServerTimestamp();

		double amount = advanceTransaction.getAmount();
		LedgerEntry debitLedgerEntry = LedgerEntry.createLedgerEntry(null, customerDepositAmountCOA, DirectionType.DEBIT, amount, description, now);
		debitLedgerEntry.setGroupId(groupId);
		debitLedgerEntry.setLedgerEntryType(LedgerEntryType.OUT.name());
		debitLedgerEntry.setTransactionId(advanceTransaction.getId());
		debitLedgerEntry.setPatientId(advanceTransaction.getCustomerId());
		debitLedgerEntry.setCashDrawerId(advanceTransaction.getCashDrawerId());
		debitLedgerEntry.setSortOrder(2);
		LedgerEntryDAO.getInstance().save(debitLedgerEntry, session);

		LedgerEntry creditLedgerEntry = LedgerEntry.createLedgerEntry(null, spendMethodCOA, DirectionType.CREDIT, amount, description, now);
		creditLedgerEntry.setGroupId(groupId);
		creditLedgerEntry.setLedgerEntryType(LedgerEntryType.OUT.name());
		creditLedgerEntry.setTransactionId(advanceTransaction.getId());
		creditLedgerEntry.setPatientId(advanceTransaction.getCustomerId());
		creditLedgerEntry.setCashDrawerId(advanceTransaction.getCashDrawerId());
		creditLedgerEntry.setSortOrder(1);
		LedgerEntryDAO.getInstance().save(creditLedgerEntry, session);

	}
}