/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model.dao;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.RecepieItem;

public class RecepieItemDAO extends BaseRecepieItemDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public RecepieItemDAO() {
	}

	public boolean isRecipeItem(MenuItem item) {
		if (item == null || StringUtils.isBlank(item.getId())) {
			return false;
		}
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(RecepieItem.class).createAlias(RecepieItem.PROP_RECEPIE, "rcp");
			addDeletedFilter(criteria);
			Disjunction recipeDeleteFilter = Restrictions.disjunction();
			recipeDeleteFilter.add(Restrictions.or(Restrictions.isNull("rcp." + AppConstants.PROP_DELETED)));
			recipeDeleteFilter.add(Restrictions.eq("rcp." + AppConstants.PROP_DELETED, Boolean.FALSE));
			criteria.add(recipeDeleteFilter);
			criteria.add(Restrictions.eq(RecepieItem.PROP_INVENTORY_ITEM, item));
			return rowCount(criteria) > 0;
		}
	}

}