package com.floreantpos.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;

import javax.imageio.ImageIO;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;

public class CachedImageService {
	public static final String IMAGE_EXTENSION = "jpeg"; //$NON-NLS-1$
	private String menuImagesDirectory;
	private static CachedImageService instance;

	private CachedImageService() {
		this.menuImagesDirectory = System.getProperty("java.io.tmpdir") + "/orocube/pos/image-resources/"; //$NON-NLS-1$ //$NON-NLS-2$
		try {
			File file = new File(this.menuImagesDirectory);
			if (!file.exists()) {
				file.mkdirs();
			}
		} catch (Exception e0) {
			PosLog.error(getClass(), e0);
		}
	}

	public static CachedImageService getInstance() {
		return instance == null ? instance = new CachedImageService() : instance;
	}

	public String getMenuImagesDirectory() {
		return this.menuImagesDirectory;
	}

	public boolean cacheImage(ImageResource imageResource, String imageName) {
		boolean result = false;
		try {
			if (imageName == null) {
				imageName = this.buildImageFileName(imageResource);
			}
			File file = new File(this.menuImagesDirectory + imageName);
			BufferedImage bufferedImage = new BufferedImage(imageResource.getImage().getWidth(null), imageResource.getImage().getHeight(null),
					BufferedImage.TYPE_INT_ARGB);
			Graphics2D graphics2d = bufferedImage.createGraphics();
			graphics2d.drawImage(imageResource.getImage(), 0, 0, null);
			graphics2d.dispose();
			ImageIO.write(bufferedImage, IMAGE_EXTENSION, file);
			result = true;
		} catch (Exception e0) {
			PosLog.error(getClass(), e0);
		}
		return result;
	}

	public byte[] getImageAsByteArray(String imageName) {
		byte[] imageBytes = null;
		File file = new File(this.menuImagesDirectory + imageName);
		try (FileInputStream fileInputStream = new FileInputStream(file)) {
			imageBytes = new byte[(int) file.length()];
			fileInputStream.read(imageBytes);
		} catch (Exception e0) {
			PosLog.error(getClass(), e0);
		}
		return imageBytes;
	}

	public String buildImageFileName(ImageResource imageResource) {
		StringBuilder nameBuilder = new StringBuilder(""); //$NON-NLS-1$
		if (imageResource != null) {
			nameBuilder.append(imageResource.getId());
			nameBuilder.append("_"); //$NON-NLS-1$
			nameBuilder.append(imageResource.getVersion());
			nameBuilder.append("."); //$NON-NLS-1$
			nameBuilder.append(IMAGE_EXTENSION);
		}
		return nameBuilder.toString();
	}

	public boolean isImageCached(String imageName) {
		boolean result = false;
		try {
			File file = new File(this.menuImagesDirectory + imageName);
			result = file.exists();
		} catch (Exception e0) {
			PosLog.error(getClass(), e0);
		}
		return result;
	}
}
