package com.floreantpos.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;

public class ProjectIdGenerator implements IdentifierGenerator {

	@Override
	public Serializable generate(SessionImplementor session, Object object) throws HibernateException {

		Class<? extends Object> clazz = object.getClass();
		Serializable generatedId = null;
		try {
			Method method = clazz.getMethod("getId", (Class<?>[]) null); //$NON-NLS-1$
			if (method != null) {
				Object id = method.invoke(object, (Object[]) null);
				if (id != null) {
					generatedId = (Serializable) id;
				}
			}

		} catch (Exception e) {
		}
		
		if (generatedId == null) {
			generatedId = generateProjectId();
		}

		return generatedId;

	}

	public static String generateProjectId() {
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			String date = SequenceNumber.yearMonthDayFormat.format(new Date());

			String projectId = date + SequenceNumber.threeDigitDecimalFormat
					.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.PROJECT_ID_SEQUENCE_NUMBER, date));
			while (ProjectDAO.getInstance().get(projectId, session) != null) {
				projectId = date + SequenceNumber.threeDigitDecimalFormat
						.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.PROJECT_ID_SEQUENCE_NUMBER, date));
			}

			return projectId;
		}
	}

}
