package com.orocube.salary.reportservice;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SalaryTransaction;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.SalaryPaymentsReportModel;
import com.floreantpos.services.report.ReportService;

import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class SalaryPaymentsReport {

	private static String makeBoldString(String string) {
		return "<b>" + string + "</b> "; //$NON-NLS-1$ //$NON-NLS-2$
	}

	public static JasperPrint getSalaryPaymentsReportPrint(Date date, Outlet outlet, List<SalaryTransaction> dataList) throws Exception {

		if (dataList != null) {
			dataList.sort((o1, o2) -> o1.getUserName().compareTo(o2.getUserName()));
		}
		JasperReport report = ReportUtil.getReport("salary_payments_report"); //$NON-NLS-1$

		HashMap properties = new HashMap();
		populateReportTime(properties, date);
		ReportUtil.populateReportFooter(properties);
		ReportUtil.populateRestaurantProperties(properties, false, outlet);

		populateReportParamsSalaryPaymentsReport(properties);
		properties.put("reportDate", //$NON-NLS-1$
				makeBoldString("Report on:") + ReportService.formatFullDate(new Date())); //$NON-NLS-1$

		SalaryPaymentsReportModel reportModel = new SalaryPaymentsReportModel();
		reportModel.setRows(dataList);

		JasperPrint print = JasperFillManager.fillReport(report, properties, new JRTableModelDataSource(reportModel));
		return print;
	}

	private static void populateReportParamsSalaryPaymentsReport(HashMap<String, Object> properties) {
		properties.put("reportTitle", Messages.getString("SalaryPaymentsReport.1")); //$NON-NLS-1$ //$NON-NLS-2$
		properties.put("colUserId", "Employee id"); //$NON-NLS-1$
		properties.put("colUser", "Employee"); //$NON-NLS-1$
		properties.put("colDate", Messages.getString("SalaryPaymentsReport.7")); //$NON-NLS-1$ //$NON-NLS-2$
		properties.put("colSalary", Messages.getString("SalaryPaymentsReport.9")); //$NON-NLS-1$ //$NON-NLS-2$
		properties.put("colAmount", Messages.getString("SalaryPaymentsReport.11")); //$NON-NLS-1$ //$NON-NLS-2$
		properties.put("colAdvanceAdj", Messages.getString("SalaryPaymentsReport.13")); //$NON-NLS-1$ //$NON-NLS-2$
		properties.put("colDeduction", Messages.getString("SalaryPaymentsReport.15")); //$NON-NLS-1$ //$NON-NLS-2$
		properties.put("colNote", Messages.getString("SalaryPaymentsReport.17")); //$NON-NLS-1$ //$NON-NLS-2$
	}

	private static void populateReportTime(HashMap<String, Object> map, Date fromDate) {
		map.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + DateUtil.formatReportDateAsString(new Date())); //$NON-NLS-1$

		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM-yyyy"); //$NON-NLS-1$
		String date = simpleDateFormat.format(fromDate);
		if (fromDate != null) {
			map.put("fromDate", ReportUtil.reportLabelWithBoldTag(Messages.getString("SalaryPaymentsReport.19")) + date); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

}
