package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.dao.DepartmentDAO;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "department" })
@XmlRootElement
public class SalesArea extends BaseSalesArea implements IdContainer, TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public SalesArea() {
	}

	/**
	 * Constructor for primary key
	 */
	public SalesArea(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return super.getName();
	}

	@XmlTransient
	public Department getDepartment() {
		if (StringUtils.isNotEmpty(getDepartmentId())) {
			return DepartmentDAO.getInstance().get(getDepartmentId());
		}
		return null;
	}

	public void setDepartment(Department department) {
		String deptId = null;
		if (department != null) {
			deptId = department.getId();
		}
		super.setDepartmentId(deptId);
	}

}