package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the ORDER_TYPE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="ORDER_TYPE"
 */

public abstract class BaseOrderType  implements Comparable, Serializable {

	public static String REF = "OrderType"; //$NON-NLS-1$
	public static String PROP_SHOW_IMAGE_ONLY = "showImageOnly"; //$NON-NLS-1$
	public static String PROP_CLOSE_ON_PAID = "closeOnPaid"; //$NON-NLS-1$
	public static String PROP_SHOW_TABLE_SELECTION = "showTableSelection"; //$NON-NLS-1$
	public static String PROP_SHOULD_PRINT_TO_KITCHEN = "shouldPrintToKitchen"; //$NON-NLS-1$
	public static String PROP_ALLOW_SEAT_BASED_ORDER = "allowSeatBasedOrder"; //$NON-NLS-1$
	public static String PROP_PRE_AUTH_CREDIT_CARD = "preAuthCreditCard"; //$NON-NLS-1$
	public static String PROP_BAR_TAB = "barTab"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_ENABLE_REORDER = "enableReorder"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_IMAGE_DATA = "imageData"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_TO_GO_TAX_GROUP_ID = "toGoTaxGroupId"; //$NON-NLS-1$
	public static String PROP_SHOW_GUEST_SELECTION = "showGuestSelection"; //$NON-NLS-1$
	public static String PROP_PICKUP = "pickup"; //$NON-NLS-1$
	public static String PROP_REQUIRED_DELIVERY_DATA = "requiredDeliveryData"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_APPLICABLE = "serviceChargeApplicable"; //$NON-NLS-1$
	public static String PROP_HAS_FOR_HERE_AND_TO_GO = "hasForHereAndToGo"; //$NON-NLS-1$
	public static String PROP_SALES_AREA_ID = "salesAreaId"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_ENABLED = "enabled"; //$NON-NLS-1$
	public static String PROP_SHOW_IN_LOGIN_SCREEN = "showInLoginScreen"; //$NON-NLS-1$
	public static String PROP_TEXT_COLOR_CODE = "textColorCode"; //$NON-NLS-1$
	public static String PROP_DEFAULT_TAX_GROUP_ID = "defaultTaxGroupId"; //$NON-NLS-1$
	public static String PROP_PREPAID = "prepaid"; //$NON-NLS-1$
	public static String PROP_FOR_HERE_TAX_GROUP_ID = "forHereTaxGroupId"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_ENABLE_COURSE = "enableCourse"; //$NON-NLS-1$
	public static String PROP_ASSIGN_DRIVER = "assignDriver"; //$NON-NLS-1$
	public static String PROP_REQUIRED_CUSTOMER_DATA = "requiredCustomerData"; //$NON-NLS-1$
	public static String PROP_DELIVERY = "delivery"; //$NON-NLS-1$
	public static String PROP_HIDE_ITEM_WITH_EMPTY_INVENTORY = "hideItemWithEmptyInventory"; //$NON-NLS-1$
	public static String PROP_RETAIL_ORDER = "retailOrder"; //$NON-NLS-1$
	public static String PROP_CONSOLIDATE_ITEMS_IN_RECEIPT = "consolidateItemsInReceipt"; //$NON-NLS-1$
	public static String PROP_BUTTON_COLOR_CODE = "buttonColorCode"; //$NON-NLS-1$


	// constructors
	public BaseOrderType () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseOrderType (
		java.lang.String id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseOrderType (
		java.lang.String id,
		java.lang.String outletId,
		java.lang.String name) {

		this.setId(id);
		this.setOutletId(outletId);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.String id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.Integer sortOrder;
				private java.lang.Boolean enabled;
				private java.lang.Boolean showTableSelection;
				private java.lang.Boolean showGuestSelection;
				private java.lang.Boolean shouldPrintToKitchen;
				private java.lang.Boolean prepaid;
				private java.lang.Boolean closeOnPaid;
				private java.lang.Boolean requiredCustomerData;
				private java.lang.Boolean delivery;
				private java.lang.Boolean showInLoginScreen;
				private java.lang.Boolean consolidateItemsInReceipt;
				private java.lang.Boolean allowSeatBasedOrder;
				private java.lang.Boolean hideItemWithEmptyInventory;
				private java.lang.Boolean hasForHereAndToGo;
				private java.lang.Boolean preAuthCreditCard;
				private java.lang.Boolean barTab;
				private java.lang.Boolean enableReorder;
				private java.lang.Boolean enableCourse;
				private java.lang.Boolean pickup;
				private java.lang.Boolean retailOrder;
				private java.lang.Boolean requiredDeliveryData;
				private java.lang.Boolean assignDriver;
				private java.lang.Boolean serviceChargeApplicable;
				private java.sql.Blob imageData;
				private java.lang.Integer textColorCode;
				private java.lang.Integer buttonColorCode;
				private java.lang.Boolean showImageOnly;
				private java.lang.String salesAreaId;
				private java.lang.String defaultTaxGroupId;
				private java.lang.String forHereTaxGroupId;
				private java.lang.String toGoTaxGroupId;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.Set<com.floreantpos.model.TerminalType> terminalTypes;
	private java.util.Set<com.floreantpos.model.MenuCategory> categories;
	private java.util.Set<com.floreantpos.model.Department> departments;



	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.String getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: ENABLED
	 */

	public java.lang.Boolean isEnabled () {
					return enabled == null ? Boolean.FALSE : enabled;
		}

	public java.lang.Boolean getEnabled () {
				return enabled == null ? Boolean.FALSE : enabled;
			}


	/**
	 * Set the value related to the column: ENABLED
	 * @param enabled the ENABLED value
	 */
			public void setEnabled (java.lang.Boolean enabled) {
			this.enabled = enabled;
	}



	/**
	 * Return the value associated with the column: SHOW_TABLE_SELECTION
	 */

	public java.lang.Boolean isShowTableSelection () {
					return showTableSelection == null ? Boolean.FALSE : showTableSelection;
		}

	public java.lang.Boolean getShowTableSelection () {
				return showTableSelection == null ? Boolean.FALSE : showTableSelection;
			}


	/**
	 * Set the value related to the column: SHOW_TABLE_SELECTION
	 * @param showTableSelection the SHOW_TABLE_SELECTION value
	 */
			public void setShowTableSelection (java.lang.Boolean showTableSelection) {
			this.showTableSelection = showTableSelection;
	}



	/**
	 * Return the value associated with the column: SHOW_GUEST_SELECTION
	 */

	public java.lang.Boolean isShowGuestSelection () {
					return showGuestSelection == null ? Boolean.FALSE : showGuestSelection;
		}

	public java.lang.Boolean getShowGuestSelection () {
				return showGuestSelection == null ? Boolean.FALSE : showGuestSelection;
			}


	/**
	 * Set the value related to the column: SHOW_GUEST_SELECTION
	 * @param showGuestSelection the SHOW_GUEST_SELECTION value
	 */
			public void setShowGuestSelection (java.lang.Boolean showGuestSelection) {
			this.showGuestSelection = showGuestSelection;
	}



	/**
	 * Return the value associated with the column: SHOULD_PRINT_TO_KITCHEN
	 */

	public java.lang.Boolean isShouldPrintToKitchen () {
					return shouldPrintToKitchen == null ? Boolean.FALSE : shouldPrintToKitchen;
		}

	public java.lang.Boolean getShouldPrintToKitchen () {
				return shouldPrintToKitchen == null ? Boolean.FALSE : shouldPrintToKitchen;
			}


	/**
	 * Set the value related to the column: SHOULD_PRINT_TO_KITCHEN
	 * @param shouldPrintToKitchen the SHOULD_PRINT_TO_KITCHEN value
	 */
			public void setShouldPrintToKitchen (java.lang.Boolean shouldPrintToKitchen) {
			this.shouldPrintToKitchen = shouldPrintToKitchen;
	}



	/**
	 * Return the value associated with the column: PREPAID
	 */

	public java.lang.Boolean isPrepaid () {
					return prepaid == null ? Boolean.FALSE : prepaid;
		}

	public java.lang.Boolean getPrepaid () {
				return prepaid == null ? Boolean.FALSE : prepaid;
			}


	/**
	 * Set the value related to the column: PREPAID
	 * @param prepaid the PREPAID value
	 */
			public void setPrepaid (java.lang.Boolean prepaid) {
			this.prepaid = prepaid;
	}



	/**
	 * Return the value associated with the column: CLOSE_ON_PAID
	 */

	public java.lang.Boolean isCloseOnPaid () {
					return closeOnPaid == null ? Boolean.FALSE : closeOnPaid;
		}

	public java.lang.Boolean getCloseOnPaid () {
				return closeOnPaid == null ? Boolean.FALSE : closeOnPaid;
			}


	/**
	 * Set the value related to the column: CLOSE_ON_PAID
	 * @param closeOnPaid the CLOSE_ON_PAID value
	 */
			public void setCloseOnPaid (java.lang.Boolean closeOnPaid) {
			this.closeOnPaid = closeOnPaid;
	}



	/**
	 * Return the value associated with the column: REQUIRED_CUSTOMER_DATA
	 */

	public java.lang.Boolean isRequiredCustomerData () {
					return requiredCustomerData == null ? Boolean.FALSE : requiredCustomerData;
		}

	public java.lang.Boolean getRequiredCustomerData () {
				return requiredCustomerData == null ? Boolean.FALSE : requiredCustomerData;
			}


	/**
	 * Set the value related to the column: REQUIRED_CUSTOMER_DATA
	 * @param requiredCustomerData the REQUIRED_CUSTOMER_DATA value
	 */
			public void setRequiredCustomerData (java.lang.Boolean requiredCustomerData) {
			this.requiredCustomerData = requiredCustomerData;
	}



	/**
	 * Return the value associated with the column: DELIVERY
	 */

	public java.lang.Boolean isDelivery () {
					return delivery == null ? Boolean.FALSE : delivery;
		}

	public java.lang.Boolean getDelivery () {
				return delivery == null ? Boolean.FALSE : delivery;
			}


	/**
	 * Set the value related to the column: DELIVERY
	 * @param delivery the DELIVERY value
	 */
			public void setDelivery (java.lang.Boolean delivery) {
			this.delivery = delivery;
	}



	/**
	 * Return the value associated with the column: SHOW_IN_LOGIN_SCREEN
	 */

	public java.lang.Boolean isShowInLoginScreen () {
					return showInLoginScreen == null ? Boolean.FALSE : showInLoginScreen;
		}

	public java.lang.Boolean getShowInLoginScreen () {
				return showInLoginScreen == null ? Boolean.FALSE : showInLoginScreen;
			}


	/**
	 * Set the value related to the column: SHOW_IN_LOGIN_SCREEN
	 * @param showInLoginScreen the SHOW_IN_LOGIN_SCREEN value
	 */
			public void setShowInLoginScreen (java.lang.Boolean showInLoginScreen) {
			this.showInLoginScreen = showInLoginScreen;
	}



	/**
	 * Return the value associated with the column: CONSOLIDATE_TIEMS_IN_RECEIPT
	 */

	public java.lang.Boolean isConsolidateItemsInReceipt () {
					return consolidateItemsInReceipt == null ? Boolean.FALSE : consolidateItemsInReceipt;
		}

	public java.lang.Boolean getConsolidateItemsInReceipt () {
				return consolidateItemsInReceipt == null ? Boolean.FALSE : consolidateItemsInReceipt;
			}


	/**
	 * Set the value related to the column: CONSOLIDATE_TIEMS_IN_RECEIPT
	 * @param consolidateItemsInReceipt the CONSOLIDATE_TIEMS_IN_RECEIPT value
	 */
			public void setConsolidateItemsInReceipt (java.lang.Boolean consolidateItemsInReceipt) {
			this.consolidateItemsInReceipt = consolidateItemsInReceipt;
	}



	/**
	 * Return the value associated with the column: ALLOW_SEAT_BASED_ORDER
	 */

	public java.lang.Boolean isAllowSeatBasedOrder () {
					return allowSeatBasedOrder == null ? Boolean.FALSE : allowSeatBasedOrder;
		}

	public java.lang.Boolean getAllowSeatBasedOrder () {
				return allowSeatBasedOrder == null ? Boolean.FALSE : allowSeatBasedOrder;
			}


	/**
	 * Set the value related to the column: ALLOW_SEAT_BASED_ORDER
	 * @param allowSeatBasedOrder the ALLOW_SEAT_BASED_ORDER value
	 */
			public void setAllowSeatBasedOrder (java.lang.Boolean allowSeatBasedOrder) {
			this.allowSeatBasedOrder = allowSeatBasedOrder;
	}



	/**
	 * Return the value associated with the column: HIDE_ITEM_WITH_EMPTY_INVENTORY
	 */

	public java.lang.Boolean isHideItemWithEmptyInventory () {
					return hideItemWithEmptyInventory == null ? Boolean.FALSE : hideItemWithEmptyInventory;
		}

	public java.lang.Boolean getHideItemWithEmptyInventory () {
				return hideItemWithEmptyInventory == null ? Boolean.FALSE : hideItemWithEmptyInventory;
			}


	/**
	 * Set the value related to the column: HIDE_ITEM_WITH_EMPTY_INVENTORY
	 * @param hideItemWithEmptyInventory the HIDE_ITEM_WITH_EMPTY_INVENTORY value
	 */
			public void setHideItemWithEmptyInventory (java.lang.Boolean hideItemWithEmptyInventory) {
			this.hideItemWithEmptyInventory = hideItemWithEmptyInventory;
	}



	/**
	 * Return the value associated with the column: HAS_FORHERE_AND_TOGO
	 */

	public java.lang.Boolean isHasForHereAndToGo () {
					return hasForHereAndToGo == null ? Boolean.FALSE : hasForHereAndToGo;
		}

	public java.lang.Boolean getHasForHereAndToGo () {
				return hasForHereAndToGo == null ? Boolean.FALSE : hasForHereAndToGo;
			}


	/**
	 * Set the value related to the column: HAS_FORHERE_AND_TOGO
	 * @param hasForHereAndToGo the HAS_FORHERE_AND_TOGO value
	 */
			public void setHasForHereAndToGo (java.lang.Boolean hasForHereAndToGo) {
			this.hasForHereAndToGo = hasForHereAndToGo;
	}



	/**
	 * Return the value associated with the column: PRE_AUTH_CREDIT_CARD
	 */

	public java.lang.Boolean isPreAuthCreditCard () {
					return preAuthCreditCard == null ? Boolean.FALSE : preAuthCreditCard;
		}

	public java.lang.Boolean getPreAuthCreditCard () {
				return preAuthCreditCard == null ? Boolean.FALSE : preAuthCreditCard;
			}


	/**
	 * Set the value related to the column: PRE_AUTH_CREDIT_CARD
	 * @param preAuthCreditCard the PRE_AUTH_CREDIT_CARD value
	 */
			public void setPreAuthCreditCard (java.lang.Boolean preAuthCreditCard) {
			this.preAuthCreditCard = preAuthCreditCard;
	}



	/**
	 * Return the value associated with the column: BAR_TAB
	 */

	public java.lang.Boolean isBarTab () {
					return barTab == null ? Boolean.FALSE : barTab;
		}

	public java.lang.Boolean getBarTab () {
				return barTab == null ? Boolean.FALSE : barTab;
			}


	/**
	 * Set the value related to the column: BAR_TAB
	 * @param barTab the BAR_TAB value
	 */
			public void setBarTab (java.lang.Boolean barTab) {
			this.barTab = barTab;
	}



	/**
	 * Return the value associated with the column: ENABLE_REORDER
	 */

	public java.lang.Boolean isEnableReorder () {
					return enableReorder == null ? Boolean.FALSE : enableReorder;
		}

	public java.lang.Boolean getEnableReorder () {
				return enableReorder == null ? Boolean.FALSE : enableReorder;
			}


	/**
	 * Set the value related to the column: ENABLE_REORDER
	 * @param enableReorder the ENABLE_REORDER value
	 */
			public void setEnableReorder (java.lang.Boolean enableReorder) {
			this.enableReorder = enableReorder;
	}



	/**
	 * Return the value associated with the column: ENABLE_COURSE
	 */

	public java.lang.Boolean isEnableCourse () {
					return enableCourse == null ? Boolean.FALSE : enableCourse;
		}

	public java.lang.Boolean getEnableCourse () {
				return enableCourse == null ? Boolean.FALSE : enableCourse;
			}


	/**
	 * Set the value related to the column: ENABLE_COURSE
	 * @param enableCourse the ENABLE_COURSE value
	 */
			public void setEnableCourse (java.lang.Boolean enableCourse) {
			this.enableCourse = enableCourse;
	}



	/**
	 * Return the value associated with the column: PICK_UP
	 */

	public java.lang.Boolean isPickup () {
					return pickup == null ? Boolean.FALSE : pickup;
		}

	public java.lang.Boolean getPickup () {
				return pickup == null ? Boolean.FALSE : pickup;
			}


	/**
	 * Set the value related to the column: PICK_UP
	 * @param pickup the PICK_UP value
	 */
			public void setPickup (java.lang.Boolean pickup) {
			this.pickup = pickup;
	}



	/**
	 * Return the value associated with the column: RETAIL_ORDER
	 */

	public java.lang.Boolean isRetailOrder () {
					return retailOrder == null ? Boolean.FALSE : retailOrder;
		}

	public java.lang.Boolean getRetailOrder () {
				return retailOrder == null ? Boolean.FALSE : retailOrder;
			}


	/**
	 * Set the value related to the column: RETAIL_ORDER
	 * @param retailOrder the RETAIL_ORDER value
	 */
			public void setRetailOrder (java.lang.Boolean retailOrder) {
			this.retailOrder = retailOrder;
	}



	/**
	 * Return the value associated with the column: REQUIRED_DELIVERY_DATA
	 */

	public java.lang.Boolean isRequiredDeliveryData () {
					return requiredDeliveryData == null ? Boolean.FALSE : requiredDeliveryData;
		}

	public java.lang.Boolean getRequiredDeliveryData () {
				return requiredDeliveryData == null ? Boolean.FALSE : requiredDeliveryData;
			}


	/**
	 * Set the value related to the column: REQUIRED_DELIVERY_DATA
	 * @param requiredDeliveryData the REQUIRED_DELIVERY_DATA value
	 */
			public void setRequiredDeliveryData (java.lang.Boolean requiredDeliveryData) {
			this.requiredDeliveryData = requiredDeliveryData;
	}



	/**
	 * Return the value associated with the column: ASSIGN_DRIVER
	 */

	public java.lang.Boolean isAssignDriver () {
					return assignDriver == null ? Boolean.FALSE : assignDriver;
		}

	public java.lang.Boolean getAssignDriver () {
				return assignDriver == null ? Boolean.FALSE : assignDriver;
			}


	/**
	 * Set the value related to the column: ASSIGN_DRIVER
	 * @param assignDriver the ASSIGN_DRIVER value
	 */
			public void setAssignDriver (java.lang.Boolean assignDriver) {
			this.assignDriver = assignDriver;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE_APPLICABLE
	 */

	public java.lang.Boolean isServiceChargeApplicable () {
					return serviceChargeApplicable == null ? Boolean.FALSE : serviceChargeApplicable;
		}

	public java.lang.Boolean getServiceChargeApplicable () {
				return serviceChargeApplicable == null ? Boolean.FALSE : serviceChargeApplicable;
			}


	/**
	 * Set the value related to the column: SERVICE_CHARGE_APPLICABLE
	 * @param serviceChargeApplicable the SERVICE_CHARGE_APPLICABLE value
	 */
			public void setServiceChargeApplicable (java.lang.Boolean serviceChargeApplicable) {
			this.serviceChargeApplicable = serviceChargeApplicable;
	}



	/**
	 * Return the value associated with the column: IMAGE
	 */

@javax.xml.bind.annotation.XmlTransient
	public java.sql.Blob getImageData () {
			return imageData;
	}



	/**
	 * Set the value related to the column: IMAGE
	 * @param imageData the IMAGE value
	 */
			public void setImageData (java.sql.Blob imageData) {
			this.imageData = imageData;
	}


	/**
	 * Custom property
	 */
	public static String getImageDataXmlTransientAnnotation () {
		return "@javax.xml.bind.annotation.XmlTransient";
	}


	/**
	 * Return the value associated with the column: TEXT_COLOR
	 */

	public java.lang.Integer getTextColorCode () {
						return textColorCode == null ? null : textColorCode;
			}



	/**
	 * Set the value related to the column: TEXT_COLOR
	 * @param textColorCode the TEXT_COLOR value
	 */
			public void setTextColorCode (java.lang.Integer textColorCode) {
			this.textColorCode = textColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getTextColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: BTN_COLOR
	 */

	public java.lang.Integer getButtonColorCode () {
						return buttonColorCode == null ? null : buttonColorCode;
			}



	/**
	 * Set the value related to the column: BTN_COLOR
	 * @param buttonColorCode the BTN_COLOR value
	 */
			public void setButtonColorCode (java.lang.Integer buttonColorCode) {
			this.buttonColorCode = buttonColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getButtonColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: SHOW_IMAGE_ONLY
	 */

	public java.lang.Boolean isShowImageOnly () {
					return showImageOnly == null ? Boolean.FALSE : showImageOnly;
		}

	public java.lang.Boolean getShowImageOnly () {
				return showImageOnly == null ? Boolean.FALSE : showImageOnly;
			}


	/**
	 * Set the value related to the column: SHOW_IMAGE_ONLY
	 * @param showImageOnly the SHOW_IMAGE_ONLY value
	 */
			public void setShowImageOnly (java.lang.Boolean showImageOnly) {
			this.showImageOnly = showImageOnly;
	}



	/**
	 * Return the value associated with the column: SALES_AREA_ID
	 */

	public java.lang.String getSalesAreaId () {
			return salesAreaId;
	}



	/**
	 * Set the value related to the column: SALES_AREA_ID
	 * @param salesAreaId the SALES_AREA_ID value
	 */
			public void setSalesAreaId (java.lang.String salesAreaId) {
			this.salesAreaId = salesAreaId;
	}



	/**
	 * Return the value associated with the column: DEFAULT_TAX_GROUP_ID
	 */

	public java.lang.String getDefaultTaxGroupId () {
			return defaultTaxGroupId;
	}



	/**
	 * Set the value related to the column: DEFAULT_TAX_GROUP_ID
	 * @param defaultTaxGroupId the DEFAULT_TAX_GROUP_ID value
	 */
			public void setDefaultTaxGroupId (java.lang.String defaultTaxGroupId) {
			this.defaultTaxGroupId = defaultTaxGroupId;
	}



	/**
	 * Return the value associated with the column: FOR_HERE_TAX_GROUP_ID
	 */

	public java.lang.String getForHereTaxGroupId () {
			return forHereTaxGroupId;
	}



	/**
	 * Set the value related to the column: FOR_HERE_TAX_GROUP_ID
	 * @param forHereTaxGroupId the FOR_HERE_TAX_GROUP_ID value
	 */
			public void setForHereTaxGroupId (java.lang.String forHereTaxGroupId) {
			this.forHereTaxGroupId = forHereTaxGroupId;
	}



	/**
	 * Return the value associated with the column: TO_GO_TAX_GROUP_ID
	 */

	public java.lang.String getToGoTaxGroupId () {
			return toGoTaxGroupId;
	}



	/**
	 * Set the value related to the column: TO_GO_TAX_GROUP_ID
	 * @param toGoTaxGroupId the TO_GO_TAX_GROUP_ID value
	 */
			public void setToGoTaxGroupId (java.lang.String toGoTaxGroupId) {
			this.toGoTaxGroupId = toGoTaxGroupId;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: terminalTypes
	 */

	public java.util.Set<com.floreantpos.model.TerminalType> getTerminalTypes () {
			return terminalTypes;
	}



	/**
	 * Set the value related to the column: terminalTypes
	 * @param terminalTypes the terminalTypes value
	 */
			public void setTerminalTypes (java.util.Set<com.floreantpos.model.TerminalType> terminalTypes) {
			this.terminalTypes = terminalTypes;
	}

	public void addToterminalTypes (com.floreantpos.model.TerminalType terminalType) {
		if (null == getTerminalTypes()) setTerminalTypes(new java.util.TreeSet<com.floreantpos.model.TerminalType>());
		getTerminalTypes().add(terminalType);
	}



	/**
	 * Return the value associated with the column: categories
	 */

	public java.util.Set<com.floreantpos.model.MenuCategory> getCategories () {
			return categories;
	}



	/**
	 * Set the value related to the column: categories
	 * @param categories the categories value
	 */
			public void setCategories (java.util.Set<com.floreantpos.model.MenuCategory> categories) {
			this.categories = categories;
	}

	public void addTocategories (com.floreantpos.model.MenuCategory menuCategory) {
		if (null == getCategories()) setCategories(new java.util.TreeSet<com.floreantpos.model.MenuCategory>());
		getCategories().add(menuCategory);
	}



	/**
	 * Return the value associated with the column: departments
	 */

	public java.util.Set<com.floreantpos.model.Department> getDepartments () {
			return departments;
	}



	/**
	 * Set the value related to the column: departments
	 * @param departments the departments value
	 */
			public void setDepartments (java.util.Set<com.floreantpos.model.Department> departments) {
			this.departments = departments;
	}

	public void addTodepartments (com.floreantpos.model.Department department) {
		if (null == getDepartments()) setDepartments(new java.util.TreeSet<com.floreantpos.model.Department>());
		getDepartments().add(department);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.OrderType)) return false;
		else {
			com.floreantpos.model.OrderType orderType = (com.floreantpos.model.OrderType) obj;
			if (null != this.getId() && null != orderType.getId()) {
				if (!this.getId().equals(orderType.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != orderType.getOutletId()) {
				if (!this.getOutletId().equals(orderType.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}