/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.floreantpos.model.TicketItemTax;

public class ReportItem implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8028931560946604844L;
	//private String uniqueId;
	private String id;
	private String name;
	private double price;
	private String unit;
	private double adjustedPrice;
	private double cost;
	private double costPercent;
	private double quantity;
	private double taxRate;
	private double netTotal;
	private double grossTotal;
	private double taxTotal;
	private double discount;
	private String groupName;
	private String barcode;
	private double serviceCharge;
	private String outletId;
	private double grossSale;
	private double returnAmount;
	private String userName;
	private double profit;
	private double profitPrecentage;
	private boolean comboChildItem;

	private double labDoctorFeeAmount;
	private double agentFeeAmount;
	private double rfOnNetsalesAmount;

	private Date date;
	private String taxName;
	private double total;
	private double requiredShippingAmount;
	private double totalSalesAmount;

	public ReportItem() {
		super();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public double getQuantity() {
		return quantity;
	}

	public void setQuantity(double quantity) {
		this.quantity = quantity;
	}

	public double getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(double taxRate) {
		this.taxRate = taxRate;
	}

	public void setTaxRate(List<TicketItemTax> taxes) {
		//		this.taxRate = taxRate;
	}

	public double getNetTotal() {
		return netTotal;
	}

	public void setNetTotal(double total) {
		this.netTotal = total;
	}

	public double getPrice() {
		return price;
	}

	public void setPrice(double price) {
		this.price = price;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public double getDiscount() {
		return discount;
	}

	public void setDiscount(double discount) {
		this.discount = discount;
	}

	public double getGrossTotal() {
		return grossTotal;
	}

	public void setGrossTotal(double netTotal) {
		this.grossTotal = netTotal;
	}

	public double getTaxTotal() {
		return taxTotal;
	}

	public void setTaxTotal(double taxTotal) {
		this.taxTotal = taxTotal;
	}

	public String getBarcode() {
		return barcode;
	}

	public void setBarcode(String barcode) {
		this.barcode = barcode;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public double getCost() {
		return cost;
	}

	public void setCost(double cost) {
		this.cost = cost;
	}

	public double getAdjustedPrice() {
		return adjustedPrice;
	}

	public void setAdjustedPrice(double adjustedPrice) {
		this.adjustedPrice = adjustedPrice;
	}

	public double getServiceCharge() {
		return serviceCharge;
	}

	public void setServiceCharge(double serviceCharge) {
		this.serviceCharge = serviceCharge;
	}

	public double getCostPercent() {
		if (this.getAdjustedPrice() > 0) {
			this.costPercent = (this.getCost() / this.getAdjustedPrice()) * 100;
		}
		return this.costPercent;
	}

	public void setCostPercent(double costPercent) {
		this.costPercent = costPercent;
	}
	//	public String getUniqueId() {
	//		return uniqueId;
	//	}
	//
	//	public void setUniqueId(String uniqueId) {
	//		this.uniqueId = uniqueId;
	//	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public double getGrossSale() {
		return grossSale;
	}

	public void setGrossSale(double grossSale) {
		this.grossSale = grossSale;
	}

	public double getReturnAmount() {
		return returnAmount;
	}

	public void setReturnAmount(double returnAmount) {
		this.returnAmount = returnAmount;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public double getProfit() {
		return profit;
	}

	public void setProfit(double profit) {
		this.profit = profit;
	}

	public double getProfitPrecentage() {
		return profitPrecentage;
	}

	public void setProfitPrecentage(double profitPrecentage) {
		this.profitPrecentage = profitPrecentage;
	}

	public boolean isComboChildItem() {
		return comboChildItem;
	}

	public void setComboChildItem(boolean comboChildItem) {
		this.comboChildItem = comboChildItem;
	}

	public double getLabDoctorFeeAmount() {
		return labDoctorFeeAmount;
	}

	public void setLabDoctorFeeAmount(double labDoctorFeeAmount) {
		this.labDoctorFeeAmount = labDoctorFeeAmount;
	}

	public double getAgentFeeAmount() {
		return agentFeeAmount;
	}

	public void setAgentFeeAmount(double agentFeeAmount) {
		this.agentFeeAmount = agentFeeAmount;
	}

	public double getRfOnNetsalesAmount() {
		return rfOnNetsalesAmount;
	}

	public void setRfOnNetsalesAmount(double rfOnNetsalesAmount) {
		this.rfOnNetsalesAmount = rfOnNetsalesAmount;
	}

	public double getTotal() {
		return total;
	}

	public void setTotal(double netTotal) {
		this.total = netTotal;
	}

	public String getTaxName() {
		return taxName;
	}

	public void setTaxName(String taxName) {
		this.taxName = taxName;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public void calculate2() {
		//gross profit = total - cost of goods
		profit = total - cost;

		//profit margin percentage calculation:
		//profit percentage = gross profit / total * 100
		profitPrecentage = profit / Math.abs(total) * 100;
	}

	public void calculate() {
		//gross profit = total - cost of goods
		profit = grossTotal - cost;

		//profit margin percentage calculation:
		//profit percentage = gross profit / total * 100
		double abs = Math.abs(grossTotal);
		if (abs > 0) {
			profitPrecentage = profit / abs * 100;
		}
		else {
			profitPrecentage = 0d;
		}
	}
	
	public double getRequiredShippingAmount() {
		return requiredShippingAmount;
	}

	public void setRequiredShippingAmount(double requiredShippingAmount) {
		this.requiredShippingAmount = requiredShippingAmount;
	}
	
	public double getTotalSalesAmount() {
		return totalSalesAmount;
	}
	
	public void setTotalSalesAmount(double totalSalesAmount) {
		this.totalSalesAmount = totalSalesAmount;
	}

}
