package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseMedGenerics;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlAccessorType(XmlAccessType.FIELD)
public class MedGenerics extends BaseMedGenerics implements PropertyContainer2, TimedModel {
	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public MedGenerics() {
	}

	/**
	 * Constructor for primary key
	 */
	public MedGenerics(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public MedGenerics(java.lang.String id, java.lang.String name) {
		super(id, name);
	}

	/*[CONSTRUCTOR MARKER END]*/
	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProprties = super.getProperties();
		if (StringUtils.isEmpty(jsonProprties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProprties, com.google.gson.JsonObject.class);
		}
		return propertiesContainer;
	}

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public String getPrecaution() {
		return getProperty("precaution", "");
	}

	public void putPrecaution(String precaution) {
		addProperty("precaution", precaution); //$NON-NLS-1$
	}

	public String getModeOfAction() {
		return getProperty("mode_of_action", "");
	}

	public void putModeOfAction(String modeOfAction) {
		addProperty("mode_of_action", modeOfAction);
	}

	public String getAdultDose() {
		return getProperty("adult_dose", "");
	}

	public void putAdultDose(String adultDose) {
		addProperty("adult_dose", adultDose);
	}

	public String getChildDose() {
		return getProperty("child_dose", "");
	}

	public void putChildDose(String childDose) {
		addProperty("child_dose", childDose);
	}

	public String getRenalDose() {
		return getProperty("renal_dose", "");
	}

	public void putRenalDose(String renalDose) {
		addProperty("renal_dose", renalDose);
	}

	@Override
	public String toString() {
		return getName();
	}

}