package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseTestItemGroup;
import com.floreantpos.model.dao.TestItemDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
public class TestItemGroup extends BaseTestItemGroup implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	private transient List<TestItem> testItems;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TestItemGroup() {
	}

	/**
	 * Constructor for primary key
	 */
	public TestItemGroup(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public TestItemGroup(java.lang.String id, java.lang.String name) {

		super(id, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return getName();
	}

	public List<TestItem> getTestItems() {
		return testItems;
	}

	public void addToTestItem(TestItem testItem) {
		if (testItems == null) {
			testItems = new ArrayList<TestItem>();
		}
		testItems.add(testItem);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	@XmlTransient
	@JsonIgnore
	public boolean isValidateGroupTotalCount() {
		return getBooleanProperty("validate.group.total.count", false); //$NON-NLS-1$
	}

	public void setValidateGroupTotalCount(boolean validateGroupTotalCount) {
		addProperty("validate.group.total.count", String.valueOf(validateGroupTotalCount)); //$NON-NLS-1$
	}

	public String getItemNamesDisplay() {
		if (StringUtils.isBlank(getId())) {
			return null;
		}
		List<TestItem> testItems = TestItemDAO.getInstance().findByGroupId(getId());
		if (testItems != null && !testItems.isEmpty()) {
			return testItems.stream().map(t -> t.getName()).collect(Collectors.joining(", "));
		}
		return null;
	}
}