package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.RentalInvoice;
import com.floreantpos.swing.PaginationSupport;

public class RentalInvoiceDAO extends BaseRentalInvoiceDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public RentalInvoiceDAO() {
	}

	public void loadItems(PaginationSupport model, String searchString) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(RentalInvoice.class, "item"); //$NON-NLS-1$
			addDeletedFilter(criteria);
			if (StringUtils.isNotEmpty(searchString)) {
				criteria.add(Restrictions.eq(RentalInvoice.PROP_TICKET_ID, searchString));
			}
			model.setNumRows(super.rowCount(criteria));
			criteria.addOrder(Order.desc(RentalInvoice.PROP_CREATED_DATE));
			criteria.setFirstResult(model.getCurrentRowIndex());
			criteria.setMaxResults(model.getPageSize());
			List<RentalInvoice> result = criteria.list();
			model.setRows(result);
		}
	}
}