package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.RfPayTransaction;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.FeePaymentMapper;
import com.floreantpos.swing.PaginationSupport;

public class RfPayTransactionDAO extends BaseRfPayTransactionDAO {

	public RfPayTransactionDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public RfPayTransaction createRfPayTransaction(FeePaymentMapper rfPaymentMapper, Session session) throws Exception {
		return createRfPayTransaction(rfPaymentMapper, null, session);
	}

	public RfPayTransaction createRfPayTransaction(FeePaymentMapper rfPaymentMapper, String batchNo, Session session) throws Exception {
		if (rfPaymentMapper.getReferrer() == null) {
			return null;
		}

		//		StoreSession storeSession = DataProvider.get().getStoreSession();
		//		if (storeSession == null && rfPaymentMapper.getCashDrawer() != null) {
		//			storeSession = rfPaymentMapper.getCashDrawer().getStoreSession();
		//		}

		RfPayTransaction rfPayTransaction = new RfPayTransaction();

		double payoutAmount = rfPaymentMapper.getPayoutAmount();
		double tenderAmount = rfPaymentMapper.getTenderAmount();
		User currentUser = rfPaymentMapper.getUser();
		CustomPayment customPayment = rfPaymentMapper.getCustomPayment();
		if (customPayment != null) {
			rfPayTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
			rfPayTransaction.setCustomPaymentId(customPayment.getId());
			rfPayTransaction.setCustomPaymentRef(rfPaymentMapper.getCustomPaymnetRef());
			rfPayTransaction.setCustomPaymentName(customPayment.getName());
		}
		else {
			rfPayTransaction.setPaymentType(PaymentType.CASH);
		}

		if (rfPaymentMapper.isRefundPayment()) {
			rfPayTransaction.setTransactionType(TransactionType.IN.name());
		}
		else {
			rfPayTransaction.setTransactionType(TransactionType.OUT.name());
		}

		rfPayTransaction.setAmount(payoutAmount);
		rfPayTransaction.setTenderAmount(tenderAmount);
		if (tenderAmount > payoutAmount) {
			rfPayTransaction.setChangeAmount(tenderAmount - payoutAmount);
		}
		rfPayTransaction.setRecepientCustomer(rfPaymentMapper.getReferrer());
		rfPayTransaction.setCashDrawer(rfPaymentMapper.getCashDrawer());
		//		if (storeSession != null) {
		//			rfPayTransaction.setStoreSessionId(storeSession.getId());
		//		}
		rfPayTransaction.setTransTicketIds(rfPaymentMapper.getTicketIds());
		rfPayTransaction.setOutletId(DataProvider.get().getOutletId());
		rfPayTransaction.setUser(currentUser);
		rfPayTransaction.setServer(currentUser);
		rfPayTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
		rfPayTransaction.setTerminal(rfPaymentMapper.getTerminal());
		rfPayTransaction.setTicketType(rfPaymentMapper.getTicketTypeNo());

		if (StringUtils.isNotBlank(batchNo)) {
			rfPayTransaction.setBatchNo(batchNo);
		}

		saveOrUpdate(rfPayTransaction, session);
		return rfPayTransaction;
	}

	public List<RfPayTransaction> findRFPayments(Date fromDate, Date toDate, Customer referrer, String orderNo, String outletId) {
		Pagination pagination = new Pagination<>(0, -1);
		findRFPayments(fromDate, toDate, referrer, pagination, orderNo, outletId);
		return pagination.getDataList();
	}

	public void findRFPayments(Date fromDate, Date toDate, Customer referrer, PaginationSupport listModel) {
		findRFPayments(fromDate, toDate, referrer, listModel, "", null);
	}

	public void findRFPayments(Date fromDate, Date toDate, Customer referrer, PaginationSupport listModel, String orderNo, String outletId) {
		PosLog.debug(getClass(), String.format("RF fee payments search. Start date: %s, end date: %s", fromDate, toDate));

		if (listModel == null) {
			return;
		}

		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(RfPayTransaction.class);
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(RfPayTransaction.PROP_OUTLET_ID, outletId));
			}
			criteria.add(Restrictions.eq(RfPayTransaction.PROP_VOIDED, false));

			if (StringUtils.isNotBlank(orderNo)) {
				criteria.add(Restrictions.ilike(RfPayTransaction.PROP_TRANS_TICKET_IDS, orderNo, MatchMode.ANYWHERE)); //$NON-NLS-1$ //$NON-NLS-2$
			}
			else {
				if (referrer != null) {
					criteria.add(Restrictions.eq(RfPayTransaction.PROP_RECEPIENT_ID, referrer.getId()));
				}
				if (fromDate != null && toDate != null) {
					criteria.add(Restrictions.between(RfPayTransaction.PROP_TRANSACTION_TIME, fromDate, toDate));
				}
				TicketType ticketType = DataProvider.get().getTicketType();
				if (ticketType != null) {
					criteria.add(Restrictions.eq(RfPayTransaction.PROP_TICKET_TYPE, ticketType.getTypeNo()));
				}
			}

			listModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(listModel.getCurrentRowIndex());
			criteria.setMaxResults(listModel.getPageSize());
			criteria.addOrder(Order.desc(RfPayTransaction.PROP_TRANSACTION_TIME));
			listModel.setRows(criteria.list());
		}
	}
}