package com.floreantpos.print;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;

import com.floreantpos.PosException;

import io.github.escposjava.print.Printer;

public class AwtReceiptPrinter implements Printer, Printable {
	private String printerName;
	private ByteArrayOutputStream byteArray;

	public AwtReceiptPrinter(String printerName) {
		this.printerName = printerName;
	}

	@Override
	public void open() {
		byteArray = new ByteArrayOutputStream(1024);
	}

	@Override
	public boolean isConnected() {
		return byteArray != null;
	}

	@Override
	public void write(byte[] command) {
		try {
			byteArray.write(command);
		} catch (IOException e1) {
			throw new RuntimeException(e1);
		}
	}

	@Override
	public void close() throws Exception {
		try {
			AttributeSet attrSet = new HashPrintServiceAttributeSet(new PrinterName(printerName, null)); //EPSON TM-U220 ReceiptE4
			PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, attrSet);
			if (printServices == null || printServices.length == 0) {
				throw new PosException("Printer " + printerName + " not found.");
			}
			DocPrintJob printJob = printServices[0].createPrintJob();
			DocFlavor flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
			Doc doc = new SimpleDoc(byteArray.toByteArray(), flavor, null);

			printJob.print(doc, null);
		} finally {
			byteArray.close();
		}
	}

	@Override
	public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
		if (pageIndex > 0) { /* We have only one page, and 'page' is zero-based */
			return NO_SUCH_PAGE;
		}

		return PAGE_EXISTS;
	}

}
