package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.Brand;
import com.floreantpos.swing.PaginationSupport;

public class BrandDAO extends BaseBrandDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public BrandDAO() {
	}
	
	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		Brand bean = (Brand) obj;
		if (bean == null) {
			throw new PosException("Brand not found!");
		}
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	@Override
	public List<Brand> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.addOrder(Order.asc(Brand.PROP_NAME));
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}
	
	public void findByName(String brandName, PaginationSupport tableModel) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Brand.class);
			addDeletedFilter(criteria);
			
			if (StringUtils.isNotBlank(brandName)) {
				criteria.add(Restrictions.ilike(Brand.PROP_NAME, brandName, MatchMode.ANYWHERE));
			}
			tableModel.setNumRows(rowCount(criteria));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			criteria.addOrder(Order.asc(Brand.PROP_NAME).ignoreCase());
			tableModel.setRows(criteria.list());
		}
	}

}