package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum FundType {
	
	PROVIDENT_FUND("Provident fund");
	
	private String displayString;

	private FundType(String displayString) {
		this.displayString = displayString;
	}

	public static FundType fromString(String s) {
		if (StringUtils.isBlank(s)) {
			return PROVIDENT_FUND;
		}

		try {
			FundType filter = valueOf(s.toUpperCase());
			return filter;
		} catch (Exception e) {
			return PROVIDENT_FUND;
		}
	}

	public String getDisplayString() {
		return displayString;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

	public static boolean match(String src, FundType target) {
		FundType fundType = FundType.fromString(src);
		return target == fundType;
	}
}
