package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PRESCRIPTION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PRESCRIPTION"
 */

public abstract class BasePrescription  implements Comparable, Serializable {

	public static String REF = "Prescription"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_NEXT_FOLLOW_UP_DATE = "nextFollowUpDate"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_OUTDOOR_TICKET_ID = "outdoorTicketId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_APPOINMENT_ID = "appoinmentId"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BasePrescription () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BasePrescription (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date createdDate;
				private java.lang.String patientId;
				private java.lang.String doctorId;
				private java.lang.String appoinmentId;
				private java.lang.String status;
				private java.util.Date nextFollowUpDate;
				private java.lang.String outletId;
				private java.lang.String userId;
				private java.lang.String outdoorTicketId;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.List<com.floreantpos.model.PrescriptionItem> items;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: PATIENT_ID
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: APPOINTMENT_ID
	 */

	public java.lang.String getAppoinmentId () {
			return appoinmentId;
	}



	/**
	 * Set the value related to the column: APPOINTMENT_ID
	 * @param appoinmentId the APPOINTMENT_ID value
	 */
			public void setAppoinmentId (java.lang.String appoinmentId) {
			this.appoinmentId = appoinmentId;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: NEX_FOLLOWUP_DATE
	 */

	public java.util.Date getNextFollowUpDate () {
			return nextFollowUpDate;
	}



	/**
	 * Set the value related to the column: NEX_FOLLOWUP_DATE
	 * @param nextFollowUpDate the NEX_FOLLOWUP_DATE value
	 */
			public void setNextFollowUpDate (java.util.Date nextFollowUpDate) {
			this.nextFollowUpDate = nextFollowUpDate;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: OUTDOOR_TICKET_ID
	 */

	public java.lang.String getOutdoorTicketId () {
			return outdoorTicketId;
	}



	/**
	 * Set the value related to the column: OUTDOOR_TICKET_ID
	 * @param outdoorTicketId the OUTDOOR_TICKET_ID value
	 */
			public void setOutdoorTicketId (java.lang.String outdoorTicketId) {
			this.outdoorTicketId = outdoorTicketId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: items
	 */

	public java.util.List<com.floreantpos.model.PrescriptionItem> getItems () {
			return items;
	}



	/**
	 * Set the value related to the column: items
	 * @param items the items value
	 */
			public void setItems (java.util.List<com.floreantpos.model.PrescriptionItem> items) {
			this.items = items;
	}

	public void addToitems (com.floreantpos.model.PrescriptionItem prescriptionItem) {
		if (null == getItems()) setItems(new java.util.ArrayList<com.floreantpos.model.PrescriptionItem>());
		getItems().add(prescriptionItem);
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Prescription)) return false;
		else {
			com.floreantpos.model.Prescription prescription = (com.floreantpos.model.Prescription) obj;
			if (null == this.getId() || null == prescription.getId()) return this == obj;
			else return (this.getId().equals(prescription.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}